/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.api;

import de.unirostock.sems.bives.api.Single;
import de.unirostock.sems.bives.ds.graph.GraphTranslator;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorDot;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorGraphML;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorJson;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesFlattenException;
import de.unirostock.sems.bives.exception.BivesUnsupportedException;
import de.unirostock.sems.bives.sbml.algorithm.SBMLGraphProducer;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.exception.XmlDocumentParseException;
import java.io.File;
import java.io.IOException;
import org.jdom2.JDOMException;

public class SBMLSingle
extends Single {
    protected SBMLDocument doc;
    protected SBMLGraphProducer graphProducer;

    public SBMLSingle(File file) throws XmlDocumentParseException, IOException, JDOMException, BivesSBMLParseException, BivesDocumentConsistencyException {
        super(file);
        this.doc = new SBMLDocument(this.tree);
    }

    public SBMLSingle(String xml) throws XmlDocumentParseException, IOException, JDOMException, BivesSBMLParseException, BivesDocumentConsistencyException {
        super(xml);
        this.doc = new SBMLDocument(this.tree);
    }

    public SBMLSingle(TreeDocument td) throws XmlDocumentParseException, IOException, JDOMException, BivesSBMLParseException, BivesDocumentConsistencyException {
        super(td);
        this.doc = new SBMLDocument(this.tree);
    }

    public SBMLSingle(SBMLDocument doc) {
        super(doc.getTreeDocument());
        this.doc = doc;
    }

    public String getReactionsGraphML() {
        if (this.graphProducer == null) {
            this.graphProducer = new SBMLGraphProducer(this.doc);
        }
        return new GraphTranslatorGraphML().translate(this.graphProducer.getReactionNetwork());
    }

    public Object getReactionsGraph(GraphTranslator gt) throws Exception {
        if (this.graphProducer == null) {
            this.graphProducer = new SBMLGraphProducer(this.doc);
        }
        return gt.translate(this.graphProducer.getReactionNetwork());
    }

    public String getReactionsDotGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new SBMLGraphProducer(this.doc);
        }
        return new GraphTranslatorDot().translate(this.graphProducer.getReactionNetwork());
    }

    public String getReactionsJsonGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new SBMLGraphProducer(this.doc);
        }
        return new GraphTranslatorJson().translate(this.graphProducer.getReactionNetwork());
    }

    public Object getHierarchyGraph(GraphTranslator gt) throws BivesUnsupportedException {
        throw new BivesUnsupportedException("there is no hierarchy graph for SBML models");
    }

    public String getHierarchyGraphML() throws BivesUnsupportedException {
        throw new BivesUnsupportedException("there is no hierarchy graph for SBML models");
    }

    public String getHierarchyDotGraph() throws BivesUnsupportedException {
        throw new BivesUnsupportedException("there is no hierarchy graph for SBML models");
    }

    public String getHierarchyJsonGraph() throws BivesUnsupportedException {
        throw new BivesUnsupportedException("there is no hierarchy graph for SBML models");
    }

    public String flatten() throws Exception {
        throw new BivesFlattenException("flattening of SBML not supported yet.");
    }
}

