/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.tools.DocumentTools;
import java.util.List;
import javax.xml.transform.TransformerException;

public class SBMLEventAssignment
extends SBMLSBase {
    private MathML math;
    private SBMLSBase variable;

    public SBMLEventAssignment(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        List maths = documentNode.getChildrenWithTag("math");
        if (maths.size() != 1) {
            throw new BivesSBMLParseException("event trigger has " + maths.size() + " math elements. (expected exactly one element)");
        }
        this.math = new MathML((DocumentNode)maths.get(0));
        this.variable = this.resolveVariable(documentNode.getAttributeValue("variable"));
    }

    protected final SBMLSBase resolveVariable(String ref) throws BivesSBMLParseException {
        SBMLSBase var = this.sbmlModel.resolveSymbole(ref);
        if (var == null) {
            throw new BivesSBMLParseException("variable " + ref + " of rule unmappable.");
        }
        return var;
    }

    public SBMLSBase getVariable() {
        return this.variable;
    }

    public MathML getMath() {
        return this.math;
    }

    public void reportModification(SimpleConnectionManager conMgmt, SBMLEventAssignment a, SBMLEventAssignment b, MarkupElement me) {
        String varB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return;
        }
        String varA = SBMLModel.getSidName(a.variable);
        if (varA.equals(varB = SBMLModel.getSidName(b.variable))) {
            me.addValue("for: " + varA);
        } else {
            me.addValue("was for: " + MarkupDocument.delete((String)varA) + " but now for: " + MarkupDocument.insert((String)varB));
        }
        BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
    }

    public void reportInsert(MarkupElement me) {
        me.addValue(MarkupDocument.insert((String)(SBMLModel.getSidName(this.variable) + " = " + this.flattenMath(this.math.getDocumentNode()))));
    }

    public void reportDelete(MarkupElement me) {
        me.addValue(MarkupDocument.delete((String)(SBMLModel.getSidName(this.variable) + " = " + this.flattenMath(this.math.getDocumentNode()))));
    }

    private String flattenMath(DocumentNode math) {
        try {
            return DocumentTools.transformMathML((DocumentNode)math);
        }
        catch (TransformerException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot parse math in event assignment"});
            return "[math parsing err]";
        }
    }
}

