/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLGenericIdNameObject;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.List;

public class SBMLFunctionDefinition
extends SBMLGenericIdNameObject
implements DiffReporter {
    private MathML math;

    public SBMLFunctionDefinition(DocumentNode functionDefinition, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(functionDefinition, sbmlModel);
        List maths = functionDefinition.getChildrenWithTag("math");
        if (maths.size() != 1) {
            throw new BivesSBMLParseException("FunctionDefinition " + this.id + " has " + maths.size() + " math elements. (expected exactly one element)");
        }
        this.math = new MathML((DocumentNode)maths.get(0));
    }

    public MathML getMath() {
        return this.math;
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        SBMLFunctionDefinition a = (SBMLFunctionDefinition)docA;
        SBMLFunctionDefinition b = (SBMLFunctionDefinition)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = a.getNameAndId();
        String idB = b.getNameAndId();
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement(idA) : new MarkupElement(MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)this.getNameAndId()));
        BivesTools.genMathMarkupStats(null, (DocumentNode)this.math.getDocumentNode(), (MarkupElement)me);
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)this.getNameAndId()));
        BivesTools.genMathMarkupStats((DocumentNode)this.math.getDocumentNode(), null, (MarkupElement)me);
        return me;
    }
}

