/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.List;

public class SBMLInitialAssignment
extends SBMLSBase
implements DiffReporter {
    private SBMLSBase symbol;
    private MathML math;

    public SBMLInitialAssignment(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        String tmp = documentNode.getAttributeValue("symbol");
        this.symbol = sbmlModel.resolveSymbole(tmp);
        if (this.symbol == null) {
            throw new BivesSBMLParseException("symbol " + tmp + " of initial assignment unmappable.");
        }
        List maths = documentNode.getChildrenWithTag("math");
        if (maths.size() != 1) {
            throw new BivesSBMLParseException("initial assignment has " + maths.size() + " math elements. (expected exactly one element)");
        }
        this.math = new MathML((DocumentNode)maths.get(0));
    }

    public SBMLSBase getSymbol() {
        return this.symbol;
    }

    public MathML getMath() {
        return this.math;
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        SBMLInitialAssignment a = (SBMLInitialAssignment)docA;
        SBMLInitialAssignment b = (SBMLInitialAssignment)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = SBMLModel.getSidName(a.symbol);
        String idB = SBMLModel.getSidName(b.symbol);
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement(idA) : new MarkupElement(MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)SBMLModel.getSidName(this.symbol)));
        me.addValue(MarkupDocument.insert((String)"inserted"));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)SBMLModel.getSidName(this.symbol)));
        me.addValue(MarkupDocument.delete((String)"deleted"));
        return me;
    }
}

