/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.algorithm;

import de.unirostock.sems.bives.algorithm.Connector;
import de.unirostock.sems.bives.algorithm.NodeConnection;
import de.unirostock.sems.bives.algorithm.general.IdConnector;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.bives.sbml.parser.SBMLAssignmentRule;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.bives.sbml.parser.SBMLListOf;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLRateRule;
import de.unirostock.sems.bives.sbml.parser.SBMLReaction;
import de.unirostock.sems.bives.sbml.parser.SBMLRule;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.HashMap;
import java.util.List;

public class SBMLConnectorPreprocessor
extends Connector {
    private Connector preprocessor;
    private SBMLDocument sbmlDocA;
    private SBMLDocument sbmlDocB;

    public SBMLConnectorPreprocessor(SBMLDocument sbmlDocA, SBMLDocument sbmlDocB, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(sbmlDocA.getTreeDocument(), sbmlDocB.getTreeDocument(), allowDifferentIds, careAboutNames, stricterNames);
        this.sbmlDocA = sbmlDocA;
        this.sbmlDocB = sbmlDocB;
    }

    public SBMLConnectorPreprocessor(SBMLDocument sbmlDocA, SBMLDocument sbmlDocB) {
        super(sbmlDocA.getTreeDocument(), sbmlDocB.getTreeDocument());
        this.sbmlDocA = sbmlDocA;
        this.sbmlDocB = sbmlDocB;
    }

    public SBMLConnectorPreprocessor(Connector preprocessor, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(preprocessor.getDocA(), preprocessor.getDocB(), allowDifferentIds, careAboutNames, stricterNames);
        this.preprocessor = preprocessor;
    }

    public SBMLConnectorPreprocessor(Connector preprocessor) {
        super(preprocessor.getDocA(), preprocessor.getDocB());
        this.preprocessor = preprocessor;
    }

    protected void init() throws BivesConnectionException {
        if (this.preprocessor == null) {
            IdConnector id = new IdConnector(this.docA, this.docB, true);
            id.findConnections();
            this.conMgmt = id.getConnections();
        } else {
            this.preprocessor.findConnections();
            this.conMgmt = this.preprocessor.getConnections();
        }
    }

    protected void connect() throws BivesConnectionException {
        SBMLModel modelA = this.sbmlDocA.getModel();
        SBMLModel modelB = this.sbmlDocB.getModel();
        HashMap<String, List<SBMLSBase>> ontoMapA = modelA.getOntologyMappings();
        if (ontoMapA != null && ontoMapA.size() > 0) {
            HashMap<String, List<SBMLSBase>> ontoMapB = modelB.getOntologyMappings();
            for (String id : ontoMapB.keySet()) {
                List<SBMLSBase> bBases;
                List<SBMLSBase> aBases = ontoMapA.get(id);
                if (aBases == null || aBases.size() != 1 || (bBases = ontoMapB.get(id)).size() != 1) continue;
                this.nodeAssign(aBases.get(0), bBases.get(0));
            }
        }
        HashMap<String, SBMLReaction> reactionsA = modelA.getReactions();
        HashMap<String, SBMLReaction> reactionsB = modelB.getReactions();
        for (String id : reactionsA.keySet()) {
            SBMLReaction rB = reactionsB.get(id);
            if (rB == null) continue;
            SBMLReaction rA = reactionsA.get(id);
            if (this.conMgmt.getConnectionForNode((TreeNode)rA.getDocumentNode()) == null && this.conMgmt.getConnectionForNode((TreeNode)rB.getDocumentNode()) == null) {
                this.conMgmt.addConnection(new NodeConnection((TreeNode)rA.getDocumentNode(), (TreeNode)rB.getDocumentNode()));
            } else if (this.conMgmt.getConnectionForNode((TreeNode)rA.getDocumentNode()) == null || this.conMgmt.getConnectionForNode((TreeNode)rB.getDocumentNode()) == null || this.conMgmt.getConnectionForNode((TreeNode)rA.getDocumentNode()).getPartnerOf((TreeNode)rA.getDocumentNode()) != rB.getDocumentNode()) continue;
            SBMLListOf loA = rA.getListOfReactantsNode();
            SBMLListOf loB = rB.getListOfReactantsNode();
            if (loA != null && loB != null) {
                this.conMgmt.addConnection(new NodeConnection((TreeNode)loA.getDocumentNode(), (TreeNode)loB.getDocumentNode()));
            }
            loA = rA.getListOfProductsNode();
            loB = rB.getListOfProductsNode();
            if (loA != null && loB != null) {
                this.conMgmt.addConnection(new NodeConnection((TreeNode)loA.getDocumentNode(), (TreeNode)loB.getDocumentNode()));
            }
            loA = rA.getListOfModifiersNode();
            loB = rB.getListOfModifiersNode();
            if (loA == null || loB == null) continue;
            this.conMgmt.addConnection(new NodeConnection((TreeNode)loA.getDocumentNode(), (TreeNode)loB.getDocumentNode()));
        }
        HashMap<SBMLSBase, SBMLRule> aRuleMapper = new HashMap<SBMLSBase, SBMLRule>();
        HashMap<SBMLSBase, SBMLRule> rRuleMapper = new HashMap<SBMLSBase, SBMLRule>();
        List<SBMLRule> rules = modelA.getRules();
        for (SBMLRule rule : rules) {
            if (rule.getRuleType() == 1) {
                aRuleMapper.put(((SBMLAssignmentRule)rule).getVariable(), rule);
            }
            if (rule.getRuleType() != 3) continue;
            rRuleMapper.put(((SBMLRateRule)rule).getVariable(), rule);
        }
        rules = modelB.getRules();
        for (SBMLRule rule : rules) {
            SBMLRule a;
            if (rule.getRuleType() == 1 && (a = (SBMLRule)aRuleMapper.get(((SBMLAssignmentRule)rule).getVariable())) != null) {
                this.conMgmt.addConnection(new NodeConnection((TreeNode)a.getDocumentNode(), (TreeNode)rule.getDocumentNode()));
            }
            if (rule.getRuleType() != 3 || (a = (SBMLRule)rRuleMapper.get(((SBMLRateRule)rule).getVariable())) == null) continue;
            this.conMgmt.addConnection(new NodeConnection((TreeNode)a.getDocumentNode(), (TreeNode)rule.getDocumentNode()));
        }
    }

    private boolean nodeAssign(SBMLSBase sA, SBMLSBase sB) throws BivesConnectionException {
        if (sA == null || sB == null) {
            return false;
        }
        return this.nodeAssign((TreeNode)sA.getDocumentNode(), (TreeNode)sB.getDocumentNode());
    }
}

