/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLAlgebraicRule;
import de.unirostock.sems.bives.sbml.parser.SBMLAssignmentRule;
import de.unirostock.sems.bives.sbml.parser.SBMLCompartment;
import de.unirostock.sems.bives.sbml.parser.SBMLCompartmentType;
import de.unirostock.sems.bives.sbml.parser.SBMLConstraint;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.bives.sbml.parser.SBMLEvent;
import de.unirostock.sems.bives.sbml.parser.SBMLFunctionDefinition;
import de.unirostock.sems.bives.sbml.parser.SBMLInitialAssignment;
import de.unirostock.sems.bives.sbml.parser.SBMLMeta;
import de.unirostock.sems.bives.sbml.parser.SBMLParameter;
import de.unirostock.sems.bives.sbml.parser.SBMLRateRule;
import de.unirostock.sems.bives.sbml.parser.SBMLReaction;
import de.unirostock.sems.bives.sbml.parser.SBMLRule;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.sbml.parser.SBMLSimpleSpeciesReference;
import de.unirostock.sems.bives.sbml.parser.SBMLSpecies;
import de.unirostock.sems.bives.sbml.parser.SBMLSpeciesType;
import de.unirostock.sems.bives.sbml.parser.SBMLUnit;
import de.unirostock.sems.bives.sbml.parser.SBMLUnitDefinition;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SBMLModel
extends SBMLSBase {
    private SBMLDocument document;
    private HashMap<TreeNode, SBMLSBase> nodeMapper;
    private HashMap<String, SBMLSBase> metaIdMapper;
    private HashMap<String, SBMLFunctionDefinition> listOfFunctionDefinitions;
    private HashMap<String, SBMLUnitDefinition> listOfUnitDefinitions;
    private HashMap<String, SBMLCompartment> listOfCompartments;
    private HashMap<String, SBMLCompartmentType> listOfCompartmentTypes;
    private HashMap<String, SBMLSpecies> listOfSpecies;
    private HashMap<String, SBMLSpeciesType> listOfSpeciesTypes;
    private HashMap<String, SBMLParameter> listOfParameters;
    private List<SBMLInitialAssignment> listOfInitialAssignments;
    private List<SBMLRule> listOfRules;
    private List<SBMLConstraint> listOfConstraints;
    private HashMap<String, SBMLReaction> listOfReactions;
    private List<SBMLEvent> listOfEvents;
    private HashMap<String, SBMLSimpleSpeciesReference> listOfSpeciesReferences;
    private String id;
    private String name;
    private SBMLUnitDefinition substanceUnits;
    private SBMLUnitDefinition timeUnits;
    private SBMLUnitDefinition volumeUnits;
    private SBMLUnitDefinition areaUnits;
    private SBMLUnitDefinition lengthUnits;
    private SBMLUnitDefinition extentUnits;
    private SBMLParameter conversionFactor;

    public SBMLModel(DocumentNode documentNode, SBMLDocument sbmlDocument) throws BivesSBMLParseException, BivesDocumentConsistencyException {
        super(documentNode, null);
        this.sbmlModel = this;
        this.document = sbmlDocument;
        if (this.nodeMapper == null) {
            this.nodeMapper = new HashMap();
        }
        if (this.metaIdMapper == null) {
            this.metaIdMapper = new HashMap();
        }
        this.listOfFunctionDefinitions = new HashMap();
        this.listOfUnitDefinitions = new HashMap();
        this.listOfCompartments = new HashMap();
        this.listOfCompartmentTypes = new HashMap();
        this.listOfSpecies = new HashMap();
        this.listOfSpeciesTypes = new HashMap();
        this.listOfParameters = new HashMap();
        this.listOfInitialAssignments = new ArrayList<SBMLInitialAssignment>();
        this.listOfRules = new ArrayList<SBMLRule>();
        this.listOfConstraints = new ArrayList<SBMLConstraint>();
        this.listOfReactions = new HashMap();
        this.listOfEvents = new ArrayList<SBMLEvent>();
        this.listOfSpeciesReferences = new HashMap();
        this.parseTree();
        for (DocumentNode rdf : sbmlDocument.getTreeDocument().getNodesByTag("RDF")) {
            SBMLMeta.extractOntologyLinks(rdf, this);
        }
    }

    public HashMap<String, List<SBMLSBase>> getOntologyMappings() {
        HashMap<String, List<SBMLSBase>> ontomap = new HashMap<String, List<SBMLSBase>>();
        for (SBMLSBase sbase : this.metaIdMapper.values()) {
            HashMap<String, List<String>> links = sbase.getOntologyLinks();
            if (links.size() <= 0) continue;
            Object[] keys = links.keySet().toArray();
            Arrays.sort(keys);
            StringBuilder sb = new StringBuilder();
            for (Object key : keys) {
                sb.append("{").append(key).append("=[");
                List<String> ontolinks = links.get(key);
                Collections.sort(ontolinks);
                for (String link : ontolinks) {
                    sb.append(link).append(",");
                }
            }
            String id = sb.toString();
            List<SBMLSBase> sbases = ontomap.get(id);
            if (sbases == null) {
                sbases = new ArrayList<SBMLSBase>();
                ontomap.put(id, sbases);
            }
            sbases.add(sbase);
        }
        return ontomap;
    }

    private void parseTree() throws BivesSBMLParseException, BivesDocumentConsistencyException {
        DocumentNode modelRoot = this.documentNode;
        this.parseFunctions(modelRoot);
        this.parseUnits(modelRoot);
        this.parseCompartmentTypes(modelRoot);
        this.parseCompartments(modelRoot);
        this.parseParameters(modelRoot);
        this.parseSpeciesTypes(modelRoot);
        this.parseSpecies(modelRoot);
        this.parseReactions(modelRoot);
        this.parseInitialAssignments(modelRoot);
        this.parseRules(modelRoot);
        this.parseConstraints(modelRoot);
        this.parseEvents(modelRoot);
        this.parseModelRoot(modelRoot);
    }

    private void parseModelRoot(DocumentNode modelRoot) throws BivesSBMLParseException {
        String tmp;
        this.id = this.documentNode.getAttributeValue("id");
        this.name = this.documentNode.getAttributeValue("name");
        if (this.documentNode.getAttributeValue("substanceUnits") != null) {
            tmp = this.documentNode.getAttributeValue("substanceUnits");
            this.substanceUnits = this.sbmlModel.getUnitDefinition(tmp);
            if (this.substanceUnits == null) {
                throw new BivesSBMLParseException("substanceUnits attribute in model root not defined: " + tmp);
            }
        }
        if (this.documentNode.getAttributeValue("timeUnits") != null) {
            tmp = this.documentNode.getAttributeValue("timeUnits");
            this.timeUnits = this.sbmlModel.getUnitDefinition(tmp);
            if (this.timeUnits == null) {
                throw new BivesSBMLParseException("timeUnits attribute in model root not defined: " + tmp);
            }
        }
        if (this.documentNode.getAttributeValue("volumeUnits") != null) {
            tmp = this.documentNode.getAttributeValue("volumeUnits");
            this.volumeUnits = this.sbmlModel.getUnitDefinition(tmp);
            if (this.volumeUnits == null) {
                throw new BivesSBMLParseException("volumeUnits attribute in model root not defined: " + tmp);
            }
        }
        if (this.documentNode.getAttributeValue("areaUnits") != null) {
            tmp = this.documentNode.getAttributeValue("areaUnits");
            this.areaUnits = this.sbmlModel.getUnitDefinition(tmp);
            if (this.areaUnits == null) {
                throw new BivesSBMLParseException("areaUnits attribute in model root not defined: " + tmp);
            }
        }
        if (this.documentNode.getAttributeValue("lengthUnits") != null) {
            tmp = this.documentNode.getAttributeValue("lengthUnits");
            this.lengthUnits = this.sbmlModel.getUnitDefinition(tmp);
            if (this.lengthUnits == null) {
                throw new BivesSBMLParseException("lengthUnits attribute in model root not defined: " + tmp);
            }
        }
        if (this.documentNode.getAttributeValue("extentUnits") != null) {
            tmp = this.documentNode.getAttributeValue("extentUnits");
            this.extentUnits = this.sbmlModel.getUnitDefinition(tmp);
            if (this.extentUnits == null) {
                throw new BivesSBMLParseException("extentUnits attribute in model root not defined: " + tmp);
            }
        }
        if (this.documentNode.getAttributeValue("conversionFactor") != null) {
            tmp = this.documentNode.getAttributeValue("conversionFactor");
            this.conversionFactor = this.sbmlModel.getParameter(tmp);
            if (this.conversionFactor == null) {
                throw new BivesSBMLParseException("conversionFactor attribute in model root not defined: " + tmp);
            }
        }
    }

    private void parseEvents(DocumentNode root) throws BivesSBMLParseException {
        List loss = root.getChildrenWithTag("listOfEvents");
        for (int i = 0; i < loss.size(); ++i) {
            DocumentNode los = (DocumentNode)loss.get(i);
            List node = los.getChildrenWithTag("event");
            for (int j = 0; j < node.size(); ++j) {
                SBMLEvent n = new SBMLEvent((DocumentNode)node.get(j), this);
                this.listOfEvents.add(n);
            }
        }
    }

    private void parseReactions(DocumentNode root) throws BivesSBMLParseException {
        List loss = root.getChildrenWithTag("listOfReactions");
        for (int i = 0; i < loss.size(); ++i) {
            DocumentNode los = (DocumentNode)loss.get(i);
            List node = los.getChildrenWithTag("reaction");
            for (int j = 0; j < node.size(); ++j) {
                SBMLReaction n = new SBMLReaction((DocumentNode)node.get(j), this);
                this.listOfReactions.put(n.getID(), n);
            }
        }
    }

    private void parseConstraints(DocumentNode root) throws BivesSBMLParseException {
        List loss = root.getChildrenWithTag("listOfConstraints");
        for (int i = 0; i < loss.size(); ++i) {
            DocumentNode los = (DocumentNode)loss.get(i);
            List node = los.getChildrenWithTag("constraint");
            for (int j = 0; j < node.size(); ++j) {
                SBMLConstraint n = new SBMLConstraint((DocumentNode)node.get(j), this);
                this.listOfConstraints.add(n);
            }
        }
    }

    private void parseRules(DocumentNode root) throws BivesSBMLParseException {
        List loss = root.getChildrenWithTag("listOfRules");
        for (int i = 0; i < loss.size(); ++i) {
            SBMLRule n;
            int j;
            DocumentNode los = (DocumentNode)loss.get(i);
            List node = los.getChildrenWithTag("algebraicRule");
            for (j = 0; j < node.size(); ++j) {
                n = new SBMLAlgebraicRule((DocumentNode)node.get(j), this);
                this.listOfRules.add(n);
            }
            node = los.getChildrenWithTag("assignmentRule");
            for (j = 0; j < node.size(); ++j) {
                n = new SBMLAssignmentRule((DocumentNode)node.get(j), this);
                this.listOfRules.add(n);
            }
            node = los.getChildrenWithTag("rateRule");
            for (j = 0; j < node.size(); ++j) {
                n = new SBMLRateRule((DocumentNode)node.get(j), this);
                this.listOfRules.add(n);
            }
        }
    }

    private void parseInitialAssignments(DocumentNode root) throws BivesSBMLParseException {
        List loss = root.getChildrenWithTag("listOfInitialAssignments");
        for (int i = 0; i < loss.size(); ++i) {
            DocumentNode los = (DocumentNode)loss.get(i);
            List node = los.getChildrenWithTag("initialAssignment");
            for (int j = 0; j < node.size(); ++j) {
                SBMLInitialAssignment n = new SBMLInitialAssignment((DocumentNode)node.get(j), this);
                this.listOfInitialAssignments.add(n);
            }
        }
    }

    private void parseSpecies(DocumentNode root) throws BivesSBMLParseException {
        List lospeciess = root.getChildrenWithTag("listOfSpecies");
        for (int i = 0; i < lospeciess.size(); ++i) {
            DocumentNode lospecies = (DocumentNode)lospeciess.get(i);
            List species = lospecies.getChildrenWithTag("species");
            for (int j = 0; j < species.size(); ++j) {
                SBMLSpecies s = new SBMLSpecies((DocumentNode)species.get(j), this);
                this.listOfSpecies.put(s.getID(), s);
            }
        }
    }

    private void parseSpeciesTypes(DocumentNode root) throws BivesSBMLParseException {
        List loss = root.getChildrenWithTag("listOfSpeciesTypes");
        for (int i = 0; i < loss.size(); ++i) {
            DocumentNode los = (DocumentNode)loss.get(i);
            List node = los.getChildrenWithTag("speciesType");
            for (int j = 0; j < node.size(); ++j) {
                SBMLSpeciesType n = new SBMLSpeciesType((DocumentNode)node.get(j), this);
                this.listOfSpeciesTypes.put(n.getID(), n);
            }
        }
    }

    private void parseParameters(DocumentNode root) throws BivesSBMLParseException {
        List loss = root.getChildrenWithTag("listOfParameters");
        for (int i = 0; i < loss.size(); ++i) {
            DocumentNode los = (DocumentNode)loss.get(i);
            List node = los.getChildrenWithTag("parameter");
            for (int j = 0; j < node.size(); ++j) {
                SBMLParameter n = new SBMLParameter((DocumentNode)node.get(j), this);
                this.listOfParameters.put(n.getID(), n);
            }
        }
    }

    private void parseCompartments(DocumentNode root) throws BivesSBMLParseException {
        List locompartments = root.getChildrenWithTag("listOfCompartments");
        for (int i = 0; i < locompartments.size(); ++i) {
            DocumentNode locompartment = (DocumentNode)locompartments.get(i);
            List compartments = locompartment.getChildrenWithTag("compartment");
            for (int j = 0; j < compartments.size(); ++j) {
                SBMLCompartment c = new SBMLCompartment((DocumentNode)compartments.get(j), this);
                this.listOfCompartments.put(c.getID(), c);
            }
        }
    }

    private void parseCompartmentTypes(DocumentNode root) throws BivesSBMLParseException {
        List loss = root.getChildrenWithTag("listOfCompartmentTypes");
        for (int i = 0; i < loss.size(); ++i) {
            DocumentNode los = (DocumentNode)loss.get(i);
            List node = los.getChildrenWithTag("compartmentType");
            for (int j = 0; j < node.size(); ++j) {
                SBMLCompartmentType n = new SBMLCompartmentType((DocumentNode)node.get(j), this);
                this.listOfCompartmentTypes.put(n.getID(), n);
            }
        }
    }

    private void parseUnits(DocumentNode root) throws BivesSBMLParseException, BivesDocumentConsistencyException {
        int i;
        for (int i2 = 0; i2 < SBMLUnit.BASE_UNITS.length; ++i2) {
            SBMLUnitDefinition ud = new SBMLUnitDefinition(SBMLUnit.BASE_UNITS[i2], this);
            this.listOfUnitDefinitions.put(ud.getID(), ud);
        }
        List lounits = root.getChildrenWithTag("listOfUnitDefinitions");
        for (i = 0; i < lounits.size(); ++i) {
            DocumentNode lounit = (DocumentNode)lounits.get(i);
            List units = lounit.getChildrenWithTag("unitDefinition");
            ArrayList<String> problems = new ArrayList<String>();
            boolean nextRound = true;
            while (nextRound && units.size() > 0) {
                nextRound = false;
                problems.clear();
                for (int j = units.size() - 1; j >= 0; --j) {
                    SBMLUnitDefinition ud = null;
                    try {
                        ud = new SBMLUnitDefinition((DocumentNode)units.get(j), this);
                        String id = ud.getID();
                        if (this.listOfUnitDefinitions.get(id) != null) {
                            if (id.equals("substance") || id.equals("volume") || id.equals("area") || id.equals("length")) {
                                LOGGER.warn((Object[])new Object[]{"std unit ", id, " redefined"});
                            } else {
                                throw new BivesSBMLParseException("Multiple definitions of unit " + ud.getID());
                            }
                        }
                        this.listOfUnitDefinitions.put(id, ud);
                        units.remove(j);
                        nextRound = true;
                        continue;
                    }
                    catch (BivesDocumentConsistencyException ex) {
                        problems.add(ex.getMessage());
                    }
                }
            }
            if (units.size() == 0) continue;
            throw new BivesDocumentConsistencyException("inconsistencies for " + units.size() + " units, problems: " + problems);
        }
        for (i = 0; i < SBMLUnit.PREDEFINED_UNITS.length; ++i) {
            SBMLUnitDefinition ud = new SBMLUnitDefinition(SBMLUnit.PREDEFINED_UNITS[i], this);
            String id = ud.getID();
            if (this.listOfUnitDefinitions.get(id) != null) continue;
            this.listOfUnitDefinitions.put(ud.getID(), ud);
        }
    }

    private void parseFunctions(DocumentNode root) throws BivesSBMLParseException {
        List lofunctions = root.getChildrenWithTag("listOfFunctionDefinitions");
        for (int i = 0; i < lofunctions.size(); ++i) {
            DocumentNode lofunction = (DocumentNode)lofunctions.get(i);
            List functions = lofunction.getChildrenWithTag("functionDefinition");
            for (int j = 0; j < functions.size(); ++j) {
                SBMLFunctionDefinition fd = new SBMLFunctionDefinition((DocumentNode)functions.get(j), this);
                this.listOfFunctionDefinitions.put(fd.getID(), fd);
            }
        }
    }

    public HashMap<String, SBMLFunctionDefinition> getFunctionDefinitions() {
        return this.listOfFunctionDefinitions;
    }

    public HashMap<String, SBMLUnitDefinition> getUnitDefinitions() {
        return this.listOfUnitDefinitions;
    }

    public SBMLUnitDefinition getUnitDefinition(String kind) {
        return this.listOfUnitDefinitions.get(kind);
    }

    public SBMLCompartmentType getCompartmentType(String id) {
        return this.listOfCompartmentTypes.get(id);
    }

    public HashMap<String, SBMLCompartmentType> getCompartmentTypes() {
        return this.listOfCompartmentTypes;
    }

    public HashMap<String, SBMLCompartment> getCompartments() {
        return this.listOfCompartments;
    }

    public SBMLCompartment getCompartment(String id) {
        return this.listOfCompartments.get(id);
    }

    public SBMLSpecies getSpecies(String id) {
        return this.listOfSpecies.get(id);
    }

    public HashMap<String, SBMLSpecies> getSpecies() {
        return this.listOfSpecies;
    }

    public SBMLSpeciesType getSpeciesType(String id) {
        return this.listOfSpeciesTypes.get(id);
    }

    public HashMap<String, SBMLSpeciesType> getSpeciesTypes() {
        return this.listOfSpeciesTypes;
    }

    public HashMap<String, SBMLParameter> getParameters() {
        return this.listOfParameters;
    }

    public SBMLParameter getParameter(String id) {
        return this.listOfParameters.get(id);
    }

    public void registerSpeciesReference(String id, SBMLSimpleSpeciesReference ref) {
        this.listOfSpeciesReferences.put(id, ref);
    }

    public SBMLSimpleSpeciesReference getSpeciesReference(String id) {
        return this.listOfSpeciesReferences.get(id);
    }

    public SBMLReaction getReaction(String id) {
        return this.listOfReactions.get(id);
    }

    public HashMap<String, SBMLReaction> getReactions() {
        return this.listOfReactions;
    }

    public List<SBMLConstraint> getConstraints() {
        return this.listOfConstraints;
    }

    public List<SBMLInitialAssignment> getInitialAssignments() {
        return this.listOfInitialAssignments;
    }

    public List<SBMLEvent> getEvents() {
        return this.listOfEvents;
    }

    public List<SBMLRule> getRules() {
        return this.listOfRules;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void mapNode(DocumentNode node, SBMLSBase sbase) {
        String metaId;
        if (this.nodeMapper == null) {
            this.nodeMapper = new HashMap();
        }
        this.nodeMapper.put((TreeNode)node, sbase);
        if (this.metaIdMapper == null) {
            this.metaIdMapper = new HashMap();
        }
        if ((metaId = sbase.getMetaId()) != null) {
            this.metaIdMapper.put(metaId, sbase);
        }
    }

    public SBMLSBase getFromNode(TreeNode node) {
        return this.nodeMapper.get(node);
    }

    public SBMLSBase getFromMetaId(String metaId) {
        return this.metaIdMapper.get(metaId);
    }

    public SBMLDocument getDocument() {
        return this.document;
    }

    public SBMLSBase resolveSymbole(String symbol) {
        return this.resolveSymbol(symbol);
    }

    public SBMLSBase resolveSymbol(String symbol) {
        SBMLSBase entity = this.sbmlModel.getCompartment(symbol);
        if (entity == null) {
            entity = this.sbmlModel.getSpecies(symbol);
        }
        if (entity == null) {
            entity = this.sbmlModel.getParameter(symbol);
        }
        if (entity == null) {
            entity = this.sbmlModel.getSpeciesReference(symbol);
        }
        return entity;
    }

    public static String getSidName(SBMLSBase ref) {
        if (ref instanceof SBMLParameter) {
            return ((SBMLParameter)ref).getNameAndId();
        }
        if (ref instanceof SBMLSpecies) {
            return ((SBMLSpecies)ref).getNameAndId();
        }
        if (ref instanceof SBMLCompartment) {
            return ((SBMLCompartment)ref).getNameAndId();
        }
        if (ref instanceof SBMLSimpleSpeciesReference) {
            return ((SBMLSimpleSpeciesReference)ref).getSpecies().getNameAndId();
        }
        return null;
    }
}

