/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLCompartment;
import de.unirostock.sems.bives.sbml.parser.SBMLGenericIdNameObject;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLParameter;
import de.unirostock.sems.bives.sbml.parser.SBMLSpeciesType;
import de.unirostock.sems.bives.sbml.parser.SBMLUnitDefinition;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;

public class SBMLSpecies
extends SBMLGenericIdNameObject
implements DiffReporter {
    private SBMLCompartment compartment;
    private Double initialAmount;
    private Double initialConcentration;
    private SBMLUnitDefinition substanceUnits;
    private boolean hasOnlySubstanceUnits;
    private boolean boundaryCondition;
    private boolean constant;
    private Integer charge;
    private SBMLParameter conversionFactor;
    private SBMLSpeciesType speciesType;

    public SBMLSpecies(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        String tmp = documentNode.getAttributeValue("compartment");
        this.compartment = sbmlModel.getCompartment(tmp);
        if (this.compartment == null) {
            throw new BivesSBMLParseException("no valid compartment for species " + this.id + " defined: " + tmp);
        }
        this.initialAmount = null;
        this.initialConcentration = null;
        tmp = documentNode.getAttributeValue("speciesType");
        if (tmp != null) {
            this.speciesType = sbmlModel.getSpeciesType(tmp);
            if (this.speciesType == null) {
                throw new BivesSBMLParseException("no valid speciesType for species " + this.id + " defined: " + tmp);
            }
        }
        if (documentNode.getAttributeValue("charge") != null) {
            try {
                this.charge = Integer.parseInt(documentNode.getAttributeValue("charge"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("charge of species " + this.id + " of unexpected format: " + documentNode.getAttributeValue("charge"));
            }
        }
        if (documentNode.getAttributeValue("initialAmount") != null) {
            try {
                this.initialAmount = Double.parseDouble(documentNode.getAttributeValue("initialAmount"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("initialAmount of species " + this.id + " of unexpected format: " + documentNode.getAttributeValue("initialAmount"));
            }
        }
        if (documentNode.getAttributeValue("initialConcentration") != null) {
            try {
                this.initialConcentration = Double.parseDouble(documentNode.getAttributeValue("initialConcentration"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("initialConcentration of species " + this.id + " of unexpected format: " + documentNode.getAttributeValue("initialConcentration"));
            }
        }
        if (this.initialAmount != null && this.initialConcentration != null) {
            throw new BivesSBMLParseException("initialAmount AND initialConcentration of species " + this.id + " defined. ");
        }
        if (documentNode.getAttributeValue("substanceUnits") != null) {
            tmp = documentNode.getAttributeValue("substanceUnits");
            this.substanceUnits = sbmlModel.getUnitDefinition(tmp);
            if (this.substanceUnits == null) {
                throw new BivesSBMLParseException("substanceUnits attribute in species " + this.id + " not defined: " + tmp);
            }
        }
        if (documentNode.getAttributeValue("hasOnlySubstanceUnits") != null) {
            try {
                this.hasOnlySubstanceUnits = Boolean.parseBoolean(documentNode.getAttributeValue("hasOnlySubstanceUnits"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("hasOnlySubstanceUnits of species " + this.id + " of unexpected format: " + documentNode.getAttributeValue("hasOnlySubstanceUnits"));
            }
        } else {
            this.hasOnlySubstanceUnits = false;
        }
        if (documentNode.getAttributeValue("boundaryCondition") != null) {
            try {
                this.boundaryCondition = Boolean.parseBoolean(documentNode.getAttributeValue("boundaryCondition"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("boundaryCondition of species " + this.id + " of unexpected format: " + documentNode.getAttributeValue("boundaryCondition"));
            }
        } else {
            this.boundaryCondition = false;
        }
        if (documentNode.getAttributeValue("constant") != null) {
            try {
                this.constant = Boolean.parseBoolean(documentNode.getAttributeValue("constant"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("constant attr of species " + this.id + " of unexpected format: " + documentNode.getAttributeValue("constant"));
            }
        } else {
            this.constant = false;
        }
        if (documentNode.getAttributeValue("conversionFactor") != null) {
            tmp = documentNode.getAttributeValue("conversionFactor");
            this.conversionFactor = sbmlModel.getParameter(tmp);
            if (this.conversionFactor == null) {
                throw new BivesSBMLParseException("conversionFactor attribute in species " + this.id + " not defined: " + tmp);
            }
            if (!this.conversionFactor.isConstant()) {
                throw new BivesSBMLParseException("conversionFactor attribute in species " + this.id + " is not constant: " + tmp);
            }
        }
    }

    public double getInitialAmount() {
        return this.initialAmount;
    }

    public double getInitialConcentration() {
        return this.initialConcentration;
    }

    public SBMLCompartment getCompartment() {
        return this.compartment;
    }

    public boolean canHaveAssignmentRule() {
        return !this.constant;
    }

    public boolean canBeReactantOrProduct() {
        return this.boundaryCondition || !this.boundaryCondition && !this.constant;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public boolean hasBoundaryCondition() {
        return this.boundaryCondition;
    }

    public boolean hasOnlySubstanceUnits() {
        return this.hasOnlySubstanceUnits;
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        SBMLSpecies a = (SBMLSpecies)docA;
        SBMLSpecies b = (SBMLSpecies)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = a.getNameAndId();
        String idB = b.getNameAndId();
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement(idA) : new MarkupElement(MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)this.getNameAndId()));
        me.addValue(MarkupDocument.insert((String)"inserted"));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)this.getNameAndId()));
        me.addValue(MarkupDocument.delete((String)"deleted"));
        return me;
    }
}

