/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.algorithm;

import de.unirostock.sems.bives.algorithm.Connector;
import de.unirostock.sems.bives.algorithm.general.XyDiffConnector;
import de.unirostock.sems.bives.ds.ontology.SBOTerm;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.bives.sbml.algorithm.SBMLConnectorPreprocessor;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.comparison.ConnectionManager;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.List;

public class SBMLConnector
extends Connector {
    private Connector preprocessor;
    private SBMLDocument sbmlDocA;
    private SBMLDocument sbmlDocB;

    public SBMLConnector(SBMLDocument sbmlDocA, SBMLDocument sbmlDocB, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(sbmlDocA.getTreeDocument(), sbmlDocB.getTreeDocument(), allowDifferentIds, careAboutNames, stricterNames);
        this.sbmlDocA = sbmlDocA;
        this.sbmlDocB = sbmlDocB;
    }

    public SBMLConnector(SBMLDocument sbmlDocA, SBMLDocument sbmlDocB) {
        super(sbmlDocA.getTreeDocument(), sbmlDocB.getTreeDocument());
        this.sbmlDocA = sbmlDocA;
        this.sbmlDocB = sbmlDocB;
    }

    public SBMLConnector(Connector preprocessor, boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) {
        super(preprocessor.getDocA(), preprocessor.getDocB(), allowDifferentIds, careAboutNames, stricterNames);
        this.preprocessor = preprocessor;
    }

    public SBMLConnector(Connector preprocessor) {
        super(preprocessor.getDocA(), preprocessor.getDocB());
        this.preprocessor = preprocessor;
    }

    protected void init() throws BivesConnectionException {
        if (this.preprocessor == null) {
            XyDiffConnector id = new XyDiffConnector((Connector)new SBMLConnectorPreprocessor(this.sbmlDocA, this.sbmlDocB, this.allowDifferentIds, this.careAboutNames, this.stricterNames), this.allowDifferentIds, this.careAboutNames, this.stricterNames);
            id.findConnections();
            this.conMgmt = id.getConnections();
        } else {
            this.preprocessor.findConnections();
            this.conMgmt = this.preprocessor.getConnections();
        }
    }

    protected void connect() {
        Connection con;
        List lists = this.docA.getNodesByTag("listOfModifiers");
        lists.addAll(this.docA.getNodesByTag("listOfProducts"));
        lists.addAll(this.docA.getNodesByTag("listOfReactants"));
        lists.addAll(this.docA.getNodesByTag("listOfEventAssignments"));
        lists.addAll(this.docA.getNodesByTag("modifierSpeciesReference"));
        lists.addAll(this.docA.getNodesByTag("speciesReference"));
        lists.addAll(this.docA.getNodesByTag("trigger"));
        lists.addAll(this.docA.getNodesByTag("eventAssignment"));
        lists.addAll(this.docA.getNodesByTag("delay"));
        lists.addAll(this.docA.getNodesByTag("priority"));
        for (DocumentNode tn : lists) {
            TreeNode partner;
            con = this.conMgmt.getConnectionForNode((TreeNode)tn);
            if (con == null || !tn.networkDiffers(partner = con.getTreeB(), (ConnectionManager)this.conMgmt, con)) continue;
            this.conMgmt.dropConnection((TreeNode)tn);
        }
        for (DocumentNode tn : this.docA.getNodesByTag("modifierSpeciesReference")) {
            con = this.conMgmt.getConnectionForNode((TreeNode)tn);
            if (con == null) continue;
            DocumentNode a = (DocumentNode)con.getTreeA();
            DocumentNode b = (DocumentNode)con.getTreeB();
            if (this.cmpSBO(this.sbmlDocA.getModel().getFromNode((TreeNode)a).getSBOTerm(), this.sbmlDocB.getModel().getFromNode((TreeNode)b).getSBOTerm())) continue;
            this.conMgmt.dropConnection(con);
        }
    }

    private boolean cmpSBO(SBOTerm a, SBOTerm b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.resolveModifier().equals(b.resolveModifier());
    }
}

