/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.algorithm;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.Interpreter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.markup.MarkupSection;
import de.unirostock.sems.bives.sbml.parser.SBMLCompartment;
import de.unirostock.sems.bives.sbml.parser.SBMLCompartmentType;
import de.unirostock.sems.bives.sbml.parser.SBMLConstraint;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.bives.sbml.parser.SBMLEvent;
import de.unirostock.sems.bives.sbml.parser.SBMLFunctionDefinition;
import de.unirostock.sems.bives.sbml.parser.SBMLInitialAssignment;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLParameter;
import de.unirostock.sems.bives.sbml.parser.SBMLReaction;
import de.unirostock.sems.bives.sbml.parser.SBMLRule;
import de.unirostock.sems.bives.sbml.parser.SBMLSpecies;
import de.unirostock.sems.bives.sbml.parser.SBMLSpeciesType;
import de.unirostock.sems.bives.sbml.parser.SBMLUnitDefinition;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.HashMap;
import java.util.List;

public class SBMLDiffInterpreter
extends Interpreter {
    private MarkupDocument markupDocument = new MarkupDocument("SBML Differences");
    private SBMLDocument sbmlDocA;
    private SBMLDocument sbmlDocB;

    public SBMLDiffInterpreter(SimpleConnectionManager conMgmt, SBMLDocument sbmlDocA, SBMLDocument sbmlDocB) {
        super(conMgmt, sbmlDocA.getTreeDocument(), sbmlDocB.getTreeDocument());
        this.sbmlDocA = sbmlDocA;
        this.sbmlDocB = sbmlDocB;
    }

    public MarkupDocument getReport() {
        return this.markupDocument;
    }

    public void interprete() {
        String lvB;
        SBMLModel modelA = this.sbmlDocA.getModel();
        SBMLModel modelB = this.sbmlDocB.getModel();
        String lvA = "L" + this.sbmlDocA.getLevel() + "V" + this.sbmlDocA.getVersion();
        if (lvA.equals(lvB = "L" + this.sbmlDocB.getLevel() + "V" + this.sbmlDocB.getVersion())) {
            this.markupDocument.addHeader("Both documents have same Level/Version: " + MarkupDocument.highlight((String)lvA));
        } else {
            this.markupDocument.addHeader("Level/Version has changed: from " + MarkupDocument.delete((String)lvA) + " to " + MarkupDocument.delete((String)lvB));
        }
        this.checkUnits(modelA, modelB);
        this.checkParameters(modelA, modelB);
        this.checkCompartments(modelA, modelB);
        this.checkCompartmentTypes(modelA, modelB);
        this.checkSpecies(modelA, modelB);
        this.checkSpeciesTypes(modelA, modelB);
        this.checkReactions(modelA, modelB);
        this.checkRules(modelA, modelB);
        this.checkConstraints(modelA, modelB);
        this.checkInitialAssignments(modelA, modelB);
        this.checkFunctions(modelA, modelB);
        this.checkEvents(modelA, modelB);
    }

    private void checkRules(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Rules");
        LOGGER.info((Object[])new Object[]{"searching for rules in A"});
        List<SBMLRule> rules = modelA.getRules();
        for (SBMLRule rule : rules) {
            dn = rule.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"rule: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(rule.reportDelete());
                continue;
            }
            MarkupElement me = rule.reportModification(this.conMgmt, rule, (SBMLRule)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for rules in B"});
        rules = modelB.getRules();
        for (SBMLRule rule : rules) {
            dn = rule.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"rule: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(rule.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkCompartments(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Compartments");
        LOGGER.info((Object[])new Object[]{"searching for compartments in A"});
        HashMap<String, SBMLCompartment> compartments = modelA.getCompartments();
        for (SBMLCompartment compartment : compartments.values()) {
            dn = compartment.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"compartment: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(compartment.reportDelete());
                continue;
            }
            MarkupElement me = compartment.reportModification(this.conMgmt, compartment, (SBMLCompartment)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for compartments in B"});
        compartments = modelB.getCompartments();
        for (SBMLCompartment compartment : compartments.values()) {
            dn = compartment.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"compartment: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(compartment.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkCompartmentTypes(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Compartment Types");
        LOGGER.info((Object[])new Object[]{"searching for compartmenttypes in A"});
        HashMap<String, SBMLCompartmentType> compartmenttypes = modelA.getCompartmentTypes();
        for (SBMLCompartmentType compartment : compartmenttypes.values()) {
            dn = compartment.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"compartmenttype: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(compartment.reportDelete());
                continue;
            }
            MarkupElement me = compartment.reportModification(this.conMgmt, compartment, (SBMLCompartmentType)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for compartmenttypes in B"});
        compartmenttypes = modelB.getCompartmentTypes();
        for (SBMLCompartmentType compartment : compartmenttypes.values()) {
            dn = compartment.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"compartmenttype: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(compartment.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkParameters(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Parameters");
        LOGGER.info((Object[])new Object[]{"searching for parameters in A"});
        HashMap<String, SBMLParameter> parameters = modelA.getParameters();
        for (SBMLParameter parameter : parameters.values()) {
            dn = parameter.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"parameter: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(parameter.reportDelete());
                continue;
            }
            MarkupElement me = parameter.reportModification(this.conMgmt, parameter, (SBMLParameter)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for parameters in B"});
        parameters = modelB.getParameters();
        for (SBMLParameter parameter : parameters.values()) {
            dn = parameter.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"parameter: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(parameter.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkEvents(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Events");
        LOGGER.info((Object[])new Object[]{"searching for events in A"});
        List<SBMLEvent> events = modelA.getEvents();
        for (SBMLEvent event : events) {
            dn = event.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"event: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(event.reportDelete());
                continue;
            }
            MarkupElement me = event.reportModification(this.conMgmt, event, (SBMLEvent)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for events in B"});
        events = modelB.getEvents();
        for (SBMLEvent event : events) {
            dn = event.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"event: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(event.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkSpecies(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Species");
        LOGGER.info((Object[])new Object[]{"searching for species in A"});
        HashMap<String, SBMLSpecies> species = modelA.getSpecies();
        for (SBMLSpecies spec : species.values()) {
            dn = spec.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"species: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(spec.reportDelete());
                continue;
            }
            MarkupElement me = spec.reportModification(this.conMgmt, spec, (SBMLSpecies)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for species in B"});
        species = modelB.getSpecies();
        for (SBMLSpecies spec : species.values()) {
            dn = spec.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"species: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(spec.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkSpeciesTypes(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Species Types");
        LOGGER.info((Object[])new Object[]{"searching for speciestypes in A"});
        HashMap<String, SBMLSpeciesType> speciestypes = modelA.getSpeciesTypes();
        for (SBMLSpeciesType spec : speciestypes.values()) {
            dn = spec.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"speciestype: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(spec.reportDelete());
                continue;
            }
            MarkupElement me = spec.reportModification(this.conMgmt, spec, (SBMLSpeciesType)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for speciestypes in B"});
        speciestypes = modelB.getSpeciesTypes();
        for (SBMLSpeciesType spec : speciestypes.values()) {
            dn = spec.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"speciestype: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(spec.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkReactions(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Reactions");
        LOGGER.info((Object[])new Object[]{"searching for reactions in A"});
        HashMap<String, SBMLReaction> reactions = modelA.getReactions();
        for (SBMLReaction reaction : reactions.values()) {
            dn = reaction.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"reaction: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(reaction.reportDelete());
                continue;
            }
            MarkupElement me = reaction.reportModification(this.conMgmt, reaction, (SBMLReaction)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for reactions in B"});
        reactions = modelB.getReactions();
        for (SBMLReaction reaction : reactions.values()) {
            dn = reaction.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"reaction: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(reaction.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkFunctions(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Functions");
        LOGGER.info((Object[])new Object[]{"searching for functions in A"});
        HashMap<String, SBMLFunctionDefinition> functions = modelA.getFunctionDefinitions();
        for (SBMLFunctionDefinition function : functions.values()) {
            dn = function.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"function: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(function.reportDelete());
                continue;
            }
            MarkupElement me = function.reportModification(this.conMgmt, function, (SBMLFunctionDefinition)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for functions in B"});
        functions = modelB.getFunctionDefinitions();
        for (SBMLFunctionDefinition function : functions.values()) {
            dn = function.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"function: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(function.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkUnits(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Units");
        LOGGER.info((Object[])new Object[]{"searching for units in A"});
        HashMap<String, SBMLUnitDefinition> units = modelA.getUnitDefinitions();
        for (SBMLUnitDefinition unit : units.values()) {
            if (unit.isBaseUnit()) continue;
            dn = unit.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"unit: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(unit.reportDelete());
                continue;
            }
            MarkupElement me = unit.reportModification(this.conMgmt, unit, (SBMLUnitDefinition)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for units in B"});
        units = modelB.getUnitDefinitions();
        for (SBMLUnitDefinition unit : units.values()) {
            if (unit.isBaseUnit()) continue;
            dn = unit.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"unit: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(unit.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkInitialAssignments(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Initial Assignments");
        LOGGER.info((Object[])new Object[]{"searching for initial assignments in A"});
        List<SBMLInitialAssignment> initAss = modelA.getInitialAssignments();
        for (SBMLInitialAssignment ia : initAss) {
            dn = ia.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"init. ass.: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(ia.reportDelete());
                continue;
            }
            MarkupElement me = ia.reportModification(this.conMgmt, ia, (SBMLInitialAssignment)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for initial assignments in B"});
        initAss = modelB.getInitialAssignments();
        for (SBMLInitialAssignment ia : initAss) {
            dn = ia.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"init. ass.: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(ia.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }

    private void checkConstraints(SBMLModel modelA, SBMLModel modelB) {
        Connection con;
        DocumentNode dn;
        MarkupSection msec = new MarkupSection("Constraints");
        LOGGER.info((Object[])new Object[]{"searching for constraints in A"});
        List<SBMLConstraint> constraints = modelA.getConstraints();
        for (SBMLConstraint constraint : constraints) {
            dn = constraint.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"constraint: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con == null) {
                msec.addValue(constraint.reportDelete());
                continue;
            }
            MarkupElement me = constraint.reportModification(this.conMgmt, constraint, (SBMLConstraint)modelB.getFromNode(con.getPartnerOf((TreeNode)dn)));
            if (me == null || me.getValues().size() <= 0) continue;
            msec.addValue(me);
        }
        LOGGER.info((Object[])new Object[]{"searching for constraints in B"});
        constraints = modelB.getConstraints();
        for (SBMLConstraint constraint : constraints) {
            dn = constraint.getDocumentNode();
            LOGGER.info((Object[])new Object[]{"constraint: ", dn.getXPath()});
            con = this.conMgmt.getConnectionForNode((TreeNode)dn);
            if (con != null) continue;
            msec.addValue(constraint.reportInsert());
        }
        if (msec.getValues().size() > 0) {
            this.markupDocument.addSection(msec);
        }
    }
}

