/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLCompartmentType;
import de.unirostock.sems.bives.sbml.parser.SBMLGenericIdNameObject;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLUnitDefinition;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;

public class SBMLCompartment
extends SBMLGenericIdNameObject
implements DiffReporter {
    private double spatialDimensions;
    private double size;
    private SBMLUnitDefinition units;
    private boolean constant;
    private SBMLCompartmentType compartmentType;

    public SBMLCompartment(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        String tmp = documentNode.getAttributeValue("compartmentType");
        if (tmp != null) {
            this.compartmentType = sbmlModel.getCompartmentType(tmp);
            if (this.compartmentType == null) {
                throw new BivesSBMLParseException("no valid compartmentType for species " + this.id + " defined: " + tmp);
            }
        }
        if (documentNode.getAttributeValue("spatialDimensions") != null) {
            try {
                this.spatialDimensions = Double.parseDouble(documentNode.getAttributeValue("spatialDimensions"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("spatialDimensions in compartment " + this.id + " of unexpected format: " + documentNode.getAttributeValue("spatialDimensions"));
            }
        }
        if (documentNode.getAttributeValue("size") != null) {
            try {
                this.size = Double.parseDouble(documentNode.getAttributeValue("size"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("size in compartment " + this.id + " of unexpected format: " + documentNode.getAttributeValue("size"));
            }
        }
        if (documentNode.getAttributeValue("units") != null) {
            String unitStr = documentNode.getAttributeValue("units");
            this.units = sbmlModel.getUnitDefinition(unitStr);
            if (this.units == null) {
                throw new BivesSBMLParseException("Unit attribute in compartment " + this.id + " not defined: " + unitStr);
            }
        }
        if (documentNode.getAttributeValue("constant") != null) {
            try {
                this.constant = Boolean.parseBoolean(documentNode.getAttributeValue("constant"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("constant attr in compartment " + this.id + " of unexpected format: " + documentNode.getAttributeValue("constant"));
            }
        } else {
            this.constant = true;
        }
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        SBMLCompartment a = (SBMLCompartment)docA;
        SBMLCompartment b = (SBMLCompartment)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = a.getNameAndId();
        String idB = b.getNameAndId();
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement(idA) : new MarkupElement(MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)this.getNameAndId()));
        me.addValue(MarkupDocument.insert((String)"inserted"));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)this.getNameAndId()));
        me.addValue(MarkupDocument.delete((String)"deleted"));
        return me;
    }
}

