/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLEventAssignment;
import de.unirostock.sems.bives.sbml.parser.SBMLEventDelay;
import de.unirostock.sems.bives.sbml.parser.SBMLEventPriority;
import de.unirostock.sems.bives.sbml.parser.SBMLEventTrigger;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.List;

public class SBMLEvent
extends SBMLSBase
implements DiffReporter {
    private String id;
    private String name;
    private boolean useValuesFromTriggerTime;
    private SBMLEventTrigger trigger;
    private SBMLEventPriority priority;
    private SBMLEventDelay delay;
    private List<SBMLEventAssignment> listOfEventAssignments;

    public SBMLEvent(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        this.id = documentNode.getAttributeValue("id");
        this.name = documentNode.getAttributeValue("name");
        if (documentNode.getAttributeValue("useValuesFromTriggerTime") != null) {
            try {
                this.useValuesFromTriggerTime = Boolean.parseBoolean(documentNode.getAttributeValue("useValuesFromTriggerTime"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("useValuesFromTriggerTime of event " + this.id + " of unexpected format: " + documentNode.getAttributeValue("useValuesFromTriggerTime"));
            }
        } else {
            this.useValuesFromTriggerTime = true;
        }
        List nodes = documentNode.getChildrenWithTag("trigger");
        if (nodes.size() == 1) {
            this.trigger = new SBMLEventTrigger((DocumentNode)nodes.get(0), sbmlModel);
        }
        if ((nodes = documentNode.getChildrenWithTag("delay")).size() > 1) {
            throw new BivesSBMLParseException("event has " + nodes.size() + " delay elements. (expected not more than one element)");
        }
        if (nodes.size() == 1) {
            this.delay = new SBMLEventDelay((DocumentNode)nodes.get(0), sbmlModel);
        }
        if ((nodes = documentNode.getChildrenWithTag("priority")).size() > 1) {
            throw new BivesSBMLParseException("event has " + nodes.size() + " priority elements. (expected not more than one element)");
        }
        if (nodes.size() == 1) {
            this.priority = new SBMLEventPriority((DocumentNode)nodes.get(0), sbmlModel);
        }
        this.listOfEventAssignments = new ArrayList<SBMLEventAssignment>();
        nodes = documentNode.getChildrenWithTag("listOfEventAssignments");
        if (nodes.size() < 1) {
            throw new BivesSBMLParseException("event has " + nodes.size() + " event assignment list elements. (expected at least one element)");
        }
        for (int i = 0; i < nodes.size(); ++i) {
            List ass = ((DocumentNode)nodes.get(i)).getChildrenWithTag("eventAssignment");
            if (ass.size() < 1) {
                throw new BivesSBMLParseException("event assignment list has " + ass.size() + " event assignment elements. (expected at least one element)");
            }
            for (int j = 0; j < ass.size(); ++j) {
                SBMLEventAssignment ea = new SBMLEventAssignment((DocumentNode)ass.get(j), sbmlModel);
                this.listOfEventAssignments.add(ea);
            }
        }
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        SBMLEvent a = (SBMLEvent)docA;
        SBMLEvent b = (SBMLEvent)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = a.getNameAndId();
        String idB = b.getNameAndId();
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement(idA) : new MarkupElement(MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        MarkupElement me2 = new MarkupElement("Trigger");
        if (a.trigger != null && b.trigger != null) {
            a.trigger.reportModification(conMgmt, a.trigger, b.trigger, me2);
            me.addSubElements(me2);
        } else if (a.trigger != null) {
            a.trigger.reportDelete(me2);
            me.addSubElements(me2);
        } else if (b.trigger != null) {
            b.trigger.reportInsert(me2);
            me.addSubElements(me2);
        }
        me2 = new MarkupElement("Priority");
        if (a.priority != null && b.priority != null) {
            a.priority.reportModification(conMgmt, a.priority, b.priority, me2);
            me.addSubElements(me2);
        } else if (a.priority != null) {
            a.priority.reportDelete(me2);
            me.addSubElements(me2);
        } else if (b.priority != null) {
            b.priority.reportInsert(me2);
            me.addSubElements(me2);
        }
        me2 = new MarkupElement("Delay");
        if (a.delay != null && b.delay != null) {
            a.delay.reportModification(conMgmt, a.delay, b.delay, me2);
            me.addSubElements(me2);
        } else if (a.priority != null) {
            a.delay.reportDelete(me2);
            me.addSubElements(me2);
        } else if (b.priority != null) {
            b.delay.reportInsert(me2);
            me.addSubElements(me2);
        }
        List<SBMLEventAssignment> assA = a.listOfEventAssignments;
        List<SBMLEventAssignment> assB = b.listOfEventAssignments;
        if (assA.size() > 0 || assB.size() > 0) {
            me2 = new MarkupElement("Assignments");
            for (SBMLEventAssignment ass : assA) {
                if (conMgmt.getConnectionForNode((TreeNode)ass.documentNode) == null) {
                    ass.reportDelete(me2);
                    continue;
                }
                Connection con = conMgmt.getConnectionForNode((TreeNode)ass.documentNode);
                SBMLEventAssignment partner = (SBMLEventAssignment)b.sbmlModel.getFromNode(con.getPartnerOf((TreeNode)ass.documentNode));
                ass.reportModification(conMgmt, ass, partner, me2);
            }
            for (SBMLEventAssignment ass : assB) {
                if (conMgmt.getConnectionForNode((TreeNode)ass.documentNode) != null) continue;
                ass.reportInsert(me2);
            }
        }
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)this.getNameAndId()));
        me.addValue(MarkupDocument.insert((String)"inserted"));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)this.getNameAndId()));
        me.addValue(MarkupDocument.delete((String)"deleted"));
        return me;
    }

    private String getNameAndId() {
        if (this.name != null && this.id != null) {
            return this.id + " (" + this.name + ")";
        }
        if (this.name != null) {
            return this.name;
        }
        if (this.id != null) {
            return this.id;
        }
        return "-";
    }
}

