/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.List;

public class SBMLEventPriority
extends SBMLSBase {
    private MathML math;

    public SBMLEventPriority(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        List maths = documentNode.getChildrenWithTag("math");
        if (maths.size() != 1) {
            throw new BivesSBMLParseException("event priority has " + maths.size() + " math elements. (expected exactly one element)");
        }
        this.math = new MathML((DocumentNode)maths.get(0));
    }

    public MathML getMath() {
        return this.math;
    }

    public void reportModification(SimpleConnectionManager conMgmt, SBMLEventPriority a, SBMLEventPriority b, MarkupElement me) {
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return;
        }
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        if (a.math != null && b.math != null) {
            BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        } else if (a.math != null) {
            BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), null, (MarkupElement)me);
        } else if (b.math != null) {
            BivesTools.genMathMarkupStats(null, (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        }
    }

    public void reportInsert(MarkupElement me) {
        BivesTools.genMathMarkupStats(null, (DocumentNode)this.math.getDocumentNode(), (MarkupElement)me);
    }

    public void reportDelete(MarkupElement me) {
        BivesTools.genMathMarkupStats((DocumentNode)this.math.getDocumentNode(), null, (MarkupElement)me);
    }
}

