/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLParameter;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.HashMap;
import java.util.List;

public class SBMLKineticLaw
extends SBMLSBase {
    private MathML math;
    private HashMap<String, SBMLParameter> listOfLocalParameters;

    public SBMLKineticLaw(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        SBMLParameter p;
        int j;
        List paras;
        int i;
        List nodes = documentNode.getChildrenWithTag("math");
        if (nodes.size() != 1) {
            throw new BivesSBMLParseException("kinetic law has " + nodes.size() + " math elements. (expected exactly one element)");
        }
        this.math = new MathML((DocumentNode)nodes.get(0));
        this.listOfLocalParameters = new HashMap();
        nodes = documentNode.getChildrenWithTag("listOfLocalParameters");
        for (i = 0; i < nodes.size(); ++i) {
            paras = ((DocumentNode)nodes.get(i)).getChildrenWithTag("localParameter");
            for (j = 0; j < paras.size(); ++j) {
                p = new SBMLParameter((DocumentNode)paras.get(j), sbmlModel);
                this.listOfLocalParameters.put(p.getID(), p);
            }
        }
        nodes = documentNode.getChildrenWithTag("listOfParameters");
        for (i = 0; i < nodes.size(); ++i) {
            paras = ((DocumentNode)nodes.get(i)).getChildrenWithTag("parameter");
            for (j = 0; j < paras.size(); ++j) {
                p = new SBMLParameter((DocumentNode)paras.get(j), sbmlModel);
                this.listOfLocalParameters.put(p.getID(), p);
            }
        }
    }

    public MathML getMath() {
        return this.math;
    }

    public void reportModification(SimpleConnectionManager conMgmt, SBMLKineticLaw a, SBMLKineticLaw b, MarkupElement me) {
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return;
        }
        HashMap<String, SBMLParameter> locParA = a.listOfLocalParameters;
        HashMap<String, SBMLParameter> locParB = b.listOfLocalParameters;
        for (String key : locParA.keySet()) {
            String bS;
            if (locParB.get(key) == null) {
                me.addValue("local parameter: " + MarkupDocument.delete((String)locParA.get(key).markup()));
                continue;
            }
            SBMLParameter parA = locParA.get(key);
            String aS = parA.markup();
            if (aS.equals(bS = locParB.get(key).markup())) continue;
            me.addValue("local parameter: " + parA.getNameAndId() + " modified from " + MarkupDocument.delete((String)aS) + " to " + MarkupDocument.insert((String)bS));
        }
        for (String key : locParB.keySet()) {
            if (locParA.get(key) != null) continue;
            me.addValue("local parameter: " + MarkupDocument.insert((String)locParB.get(key).markup()));
        }
        if (a.math != null && b.math != null) {
            BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        } else if (a.math != null) {
            BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), null, (MarkupElement)me);
        } else if (b.math != null) {
            BivesTools.genMathMarkupStats(null, (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        }
    }

    public void reportInsert(MarkupElement me) {
        for (SBMLParameter locPar : this.listOfLocalParameters.values()) {
            me.addValue("local parameter: " + MarkupDocument.insert((String)locPar.markup()));
        }
        if (this.math != null) {
            BivesTools.genAttributeMarkupStats(null, (DocumentNode)this.math.getDocumentNode(), (MarkupElement)me);
        }
    }

    public void reportDelete(MarkupElement me) {
        for (SBMLParameter locPar : this.listOfLocalParameters.values()) {
            me.addValue("local parameter: " + MarkupDocument.delete((String)locPar.markup()));
        }
        if (this.math != null) {
            BivesTools.genAttributeMarkupStats((DocumentNode)this.math.getDocumentNode(), null, (MarkupElement)me);
        }
    }
}

