/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.List;

public abstract class SBMLRule
extends SBMLSBase
implements DiffReporter {
    public static final int ASSIGNMENT_RULE = 1;
    public static final int ALGEBRAIC_RULE = 2;
    public static final int RATE_RULE = 3;
    protected MathML math;
    protected int type;

    public SBMLRule(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        List maths = documentNode.getChildrenWithTag("math");
        if (maths.size() != 1) {
            throw new BivesSBMLParseException("initial assignment has " + maths.size() + " math elements. (expected exactly one element)");
        }
        this.math = new MathML((DocumentNode)maths.get(0));
    }

    public MathML getMath() {
        return this.math;
    }

    protected final SBMLSBase resolveVariable(String ref) throws BivesSBMLParseException {
        SBMLSBase var = this.sbmlModel.resolveSymbole(ref);
        if (var == null) {
            throw new BivesSBMLParseException("variable " + ref + " of rule unmappable.");
        }
        return var;
    }

    public int getRuleType() {
        return this.type;
    }
}

