/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.ds.Xhtml;
import de.unirostock.sems.bives.ds.ontology.SBOTerm;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLGenericObject;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class SBMLSBase
extends SBMLGenericObject {
    private String metaid;
    private SBOTerm sboTerm;
    private Xhtml notes;
    private DocumentNode annotation;
    private HashMap<String, List<String>> ontologyLinks;

    public SBMLSBase(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        if (documentNode != null) {
            this.metaid = documentNode.getAttributeValue("metaid");
        }
        if (sbmlModel == null && documentNode.getTagName().equals("model") && documentNode.getLevel() == 1) {
            sbmlModel = (SBMLModel)this;
        }
        if (sbmlModel != null) {
            sbmlModel.mapNode(documentNode, this);
        }
        if (documentNode != null) {
            List nodeList;
            if (documentNode.getAttributeValue("sboTerm") != null) {
                this.sboTerm = new SBOTerm(documentNode.getAttributeValue("sboTerm"));
            }
            if ((nodeList = documentNode.getChildrenWithTag("notes")).size() > 1) {
                throw new BivesSBMLParseException("SBase with " + nodeList.size() + " notes. (expected max one notes)");
            }
            if (nodeList.size() == 1) {
                this.notes = new Xhtml();
                DocumentNode root = (DocumentNode)nodeList.get(0);
                this.notes.setXhtml(root);
            }
            this.ontologyLinks = new HashMap();
            nodeList = documentNode.getChildrenWithTag("annotation");
            if (nodeList.size() > 1) {
                throw new BivesSBMLParseException("SBase with " + nodeList.size() + " annotations. (expected max one annotation)");
            }
            if (nodeList.size() == 1) {
                this.annotation = (DocumentNode)nodeList.get(0);
            }
        }
    }

    public boolean flagMetaModifcations(MarkupElement me) {
        if (this.notes != null && this.notes.getDocumentNode().getModification() != 0) {
            me.flagInvisibleModification();
            return true;
        }
        if (this.annotation != null && this.annotation.getModification() != 0) {
            me.flagInvisibleModification();
            return true;
        }
        return false;
    }

    public HashMap<String, List<String>> getOntologyLinks() {
        return this.ontologyLinks;
    }

    public void addOntologyLink(String qualifier, String link) {
        List<String> linklist = this.ontologyLinks.get(qualifier);
        if (linklist == null) {
            linklist = new ArrayList<String>();
            this.ontologyLinks.put(qualifier, linklist);
        }
        linklist.add(link);
    }

    public SBOTerm getSBOTerm() {
        return this.sboTerm;
    }

    public String getMetaId() {
        return this.metaid;
    }

    public Xhtml getNotes() {
        return this.notes;
    }

    public DocumentNode getAnnotation() {
        return this.annotation;
    }
}

