/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.ontology.SBOTerm;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.sbml.parser.SBMLSpecies;
import de.unirostock.sems.xmlutils.ds.DocumentNode;

public class SBMLSimpleSpeciesReference
extends SBMLSBase {
    protected String id;
    protected String name;
    protected SBMLSpecies species;

    public SBMLSimpleSpeciesReference(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        this.id = documentNode.getAttributeValue("id");
        this.name = documentNode.getAttributeValue("name");
        if (this.id != null) {
            sbmlModel.registerSpeciesReference(this.id, this);
        }
        String tmp = documentNode.getAttributeValue("species");
        this.species = sbmlModel.getSpecies(tmp);
        if (this.species == null) {
            throw new BivesSBMLParseException("species reference " + tmp + " is not a valid species.");
        }
    }

    public SBMLSpecies getSpecies() {
        return this.species;
    }

    public String reportModification(SimpleConnectionManager conMgmt, SBMLSimpleSpeciesReference a, SBMLSimpleSpeciesReference b) {
        String retB;
        SBOTerm sboA = a.getSBOTerm();
        SBOTerm sboB = b.getSBOTerm();
        String retA = a.species.getID() + (sboA == null ? "(" + SBOTerm.resolveModifier((String)"unknown") + ")" : "(" + sboA.resolveModifier() + ")");
        if (retA.equals(retB = b.species.getID() + (sboB == null ? "(" + SBOTerm.resolveModifier((String)"unknown") + ")" : "(" + sboB.resolveModifier() + ")"))) {
            return retA;
        }
        return MarkupDocument.delete((String)retA) + " + " + MarkupDocument.insert((String)retB);
    }

    public String reportInsert() {
        SBOTerm sbo = this.getSBOTerm();
        return MarkupDocument.insert((String)(this.species.getID() + (sbo == null ? "(" + SBOTerm.resolveModifier((String)"unknown") + ")" : "(" + sbo.resolveModifier() + ")")));
    }

    public String reportDelete() {
        SBOTerm sbo = this.getSBOTerm();
        return MarkupDocument.delete((String)(this.species.getID() + (sbo == null ? "(" + SBOTerm.resolveModifier((String)"unknown") + ")" : "(" + sbo.resolveModifier() + ")")));
    }

    public String report() {
        SBOTerm sbo = this.getSBOTerm();
        return this.species.getID() + (sbo == null ? "(" + SBOTerm.resolveModifier((String)"unknown") + ")" : "(" + sbo.resolveModifier() + ")");
    }
}

