/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.algorithm;

import de.unirostock.sems.bives.algorithm.general.DefaultDiffAnnotator;
import de.unirostock.sems.comodi.Change;
import de.unirostock.sems.comodi.ChangeFactory;
import de.unirostock.sems.comodi.branches.ComodiReason;
import de.unirostock.sems.comodi.branches.ComodiTarget;
import de.unirostock.sems.comodi.branches.ComodiXmlEntity;
import de.unirostock.sems.xmlutils.ds.TextNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class SBMLDiffAnnotator
extends DefaultDiffAnnotator {
    public static final Pattern functionPath = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\]/listOfFunctionDefinitions\\[\\d+\\]/functionDefinition\\[\\d+\\]");
    public static final Pattern eventPath = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\]/listOfEvents\\[\\d+\\]/event\\[\\d+\\]");
    public static final Pattern rulePath = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\]/listOfRules\\[\\d+\\]/[^/]*Rule\\[\\d+\\]");
    public static final Pattern annotationPath = Pattern.compile("^/sbml\\[\\d+\\]/(.*/)*annotation\\[\\d+\\]");
    public static final Pattern descriptionPath = Pattern.compile("^/sbml\\[\\d+\\]/(.*/)*notes\\[\\d+\\]");
    public static final Pattern speciesPath = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\]/listOfSpecies\\[\\d+\\]/species\\[\\d+\\]$");
    public static final Pattern reactionsPath = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\]/listOfReactions\\[\\d+\\]/reaction\\[\\d+\\]");
    public static final Pattern kineticsPath = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\]/listOfReactions\\[\\d+\\]/reaction\\[\\d+\\]/kineticLaw\\[\\d+\\]");
    public static final Pattern unitsPath = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\]/listOfUnitDefinitions\\[\\d+\\]/unitDefinition\\[\\d+\\]");
    public static final Pattern parameterPath = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\](/listOfReactions\\[\\d+\\]/reaction\\[\\d+\\]/kineticLaw\\[\\d+\\])?/listOf(Local)?Parameters\\[\\d+\\]/(localP|p)arameter\\[\\d+\\]");
    public static final Pattern creationDatePath = Pattern.compile("^/sbml\\[\\d+\\]/(.*/)*annotation\\[\\d+\\]/(.*/)*created\\[\\d+\\]");
    public static final Pattern modificationDatePath = Pattern.compile("^/sbml\\[\\d+\\]/(.*/)*annotation\\[\\d+\\]/(.*/)*modified\\[\\d+\\]");
    public static final Pattern contributorPath = Pattern.compile("^/sbml\\[\\d+\\]/(.*/)*annotation\\[\\d+\\]/(.*/)*contributor\\[\\d+\\]");
    public static final Pattern creatorPath = Pattern.compile("^/sbml\\[\\d+\\]/(.*/)*annotation\\[\\d+\\]/(.*/)*creator\\[\\d+\\]");
    public static final Pattern reactionsSpeciesReference = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\]/listOfReactions\\[\\d+\\]/reaction\\[\\d+\\]/(.*/)*speciesReference\\[\\d+\\]");
    public static final Pattern reactionsModifierSpeciesReference = Pattern.compile("^/sbml\\[\\d+\\]/model\\[\\d+\\]/listOfReactions\\[\\d+\\]/reaction\\[\\d+\\]/(.*/)*modifierSpeciesReference\\[\\d+\\]");
    public static final Pattern ontologyLink = Pattern.compile("^/sbml\\[\\d+\\]/(.*/)*RDF\\[\\d+\\]/(.*/)*Description\\[\\d+\\]/(.*/)*Bag\\[\\d+\\]/li\\[\\d+\\]");

    public Change annotateDeletion(TreeNode node, Element diffNode, ChangeFactory changeFac) {
        Change change = super.annotateDeletion(node, diffNode, changeFac);
        this.annotateTarget(change, node, null, diffNode, false);
        return change;
    }

    public Change annotateInsertion(TreeNode node, Element diffNode, ChangeFactory changeFac) {
        Change change = super.annotateInsertion(node, diffNode, changeFac);
        this.annotateTarget(change, null, node, diffNode, false);
        return change;
    }

    public Change annotateMove(TreeNode nodeA, TreeNode nodeB, Element diffNode, ChangeFactory changeFac, boolean permutation) {
        Change change = super.annotateMove(nodeA, nodeB, diffNode, changeFac, permutation);
        this.annotateTarget(change, nodeA, nodeB, diffNode, permutation);
        return change;
    }

    public Change annotateUpdateAttribute(TreeNode nodeA, TreeNode nodeB, String attributeName, Element diffNode, ChangeFactory changeFac) {
        Change change = super.annotateUpdateAttribute(nodeA, nodeB, attributeName, diffNode, changeFac);
        this.annotateTarget(change, nodeA, nodeB, diffNode, false);
        return change;
    }

    public Change annotateUpdateText(TextNode nodeA, TextNode nodeB, Element diffNode, ChangeFactory changeFac) {
        Change change = super.annotateUpdateText(nodeA, nodeB, diffNode, changeFac);
        this.annotateTarget(change, (TreeNode)nodeA, (TreeNode)nodeB, diffNode, false);
        return change;
    }

    public void annotatePatch(String rootId, ChangeFactory changeFac) {
        super.annotatePatch(rootId, changeFac);
    }

    private Change annotateTarget(Change change, TreeNode nodeA, TreeNode nodeB, Element diffNode, boolean permutation) {
        boolean isAnnotation;
        String attr;
        String xPath;
        TreeNode defNode = nodeA == null ? nodeB : nodeA;
        String string = xPath = diffNode.getAttributeValue("newPath") == null ? diffNode.getAttributeValue("oldPath") : diffNode.getAttributeValue("newPath");
        if (defNode.getParent() == null && diffNode.getName().equals("attribute") && ((attr = diffNode.getAttributeValue("name")).equals("level") || attr.equals("version"))) {
            change.hasReason(ComodiReason.getChangedSpecification());
        }
        if (defNode.getXPath().equals("/sbml[1]/model[1]") && diffNode.getName().equals("attribute")) {
            attr = diffNode.getAttributeValue("name");
            if (attr.equals("id") || attr.equals("metaid")) {
                change.appliesTo(ComodiXmlEntity.getModelId());
            } else if (attr.equals("name")) {
                change.appliesTo(ComodiXmlEntity.getModelName());
            }
        }
        boolean bl = isAnnotation = annotationPath.matcher(xPath).find() || descriptionPath.matcher(xPath).find();
        if (parameterPath.matcher(xPath).find() && !isAnnotation) {
            if (diffNode.getName().equals("attribute")) {
                String attr2 = diffNode.getAttributeValue("name");
                if (attr2.equals("id") || attr2.equals("metaid")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                } else if (attr2.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityName());
                } else {
                    change.affects(ComodiTarget.getParameterSetup());
                }
            } else if (!permutation) {
                change.affects(ComodiTarget.getParameterSetup());
            }
        } else if (speciesPath.matcher(xPath).find() && !isAnnotation) {
            if (diffNode.getName().equals("attribute")) {
                String attr3 = diffNode.getAttributeValue("name");
                if (attr3.equals("id") || attr3.equals("metaid")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                } else if (attr3.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityName());
                } else if (attr3.equals("initialConcentration") || attr3.equals("initialAmount") || attr3.equals("substanceUnits") || attr3.equals("constant") || attr3.equals("hasOnlySubstanceUnits")) {
                    change.affects(ComodiTarget.getSpeciesSetup());
                } else if (attr3.equals("sboTerm")) {
                    change.affects(ComodiTarget.getReactionNetworkDefinition());
                }
            } else if (!permutation) {
                change.affects(ComodiTarget.getSpeciesSetup());
            }
        } else if (eventPath.matcher(xPath).find() && !isAnnotation) {
            if (diffNode.getName().equals("attribute")) {
                String attr4 = diffNode.getAttributeValue("name");
                if (attr4.equals("id") || attr4.equals("metaid")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                } else if (attr4.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityName());
                } else {
                    change.affects(ComodiTarget.getEventDefinition());
                }
            } else {
                change.affects(ComodiTarget.getEventDefinition());
            }
        } else if (functionPath.matcher(xPath).find() && !isAnnotation) {
            if (diffNode.getName().equals("attribute")) {
                String attr5 = diffNode.getAttributeValue("name");
                if (attr5.equals("id") || attr5.equals("metaid")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                } else if (attr5.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityName());
                } else {
                    change.affects(ComodiTarget.getFunctionDefinition());
                }
            } else {
                change.affects(ComodiTarget.getFunctionDefinition());
            }
        } else if (rulePath.matcher(xPath).find() && !isAnnotation) {
            if (diffNode.getName().equals("attribute")) {
                String attr6 = diffNode.getAttributeValue("name");
                if (attr6.equals("id") || attr6.equals("metaid")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                } else if (attr6.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityName());
                } else {
                    change.affects(ComodiTarget.getRuleDefinition());
                }
            } else {
                change.affects(ComodiTarget.getRuleDefinition());
            }
        } else if (unitsPath.matcher(xPath).find() && !isAnnotation) {
            if (diffNode.getName().equals("attribute")) {
                String attr7 = diffNode.getAttributeValue("name");
                if (attr7.equals("id") || attr7.equals("metaid")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                } else if (attr7.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityName());
                } else {
                    change.affects(ComodiTarget.getUnitDefinition());
                }
            } else {
                change.affects(ComodiTarget.getUnitDefinition());
            }
        } else if (functionPath.matcher(xPath).find() && !isAnnotation) {
            if (diffNode.getName().equals("attribute")) {
                String attr8 = diffNode.getAttributeValue("name");
                if (attr8.equals("id") || attr8.equals("metaid")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                } else if (attr8.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityName());
                } else {
                    change.affects(ComodiTarget.getFunctionDefinition());
                }
            } else {
                change.affects(ComodiTarget.getFunctionDefinition());
            }
        } else if (reactionsPath.matcher(xPath).find() && !isAnnotation) {
            boolean go = true;
            if (diffNode.getName().equals("attribute")) {
                String attr9 = diffNode.getAttributeValue("name");
                if (attr9.equals("id") || attr9.equals("metaid")) {
                    change.appliesTo(ComodiXmlEntity.getEntityIdentifier());
                    go = false;
                } else if (attr9.equals("name")) {
                    change.appliesTo(ComodiXmlEntity.getEntityName());
                    go = false;
                } else if (attr9.equals("reversible")) {
                    change.affects(ComodiTarget.getReversibilityDefinition());
                    go = false;
                } else if ((reactionsSpeciesReference.matcher(xPath).find() || reactionsModifierSpeciesReference.matcher(xPath).find()) && attr9.equals("sboTerm")) {
                    change.affects(ComodiTarget.getParticipantDefinition());
                    go = false;
                } else if (attr9.equals("sboTerm")) {
                    change.affects(ComodiTarget.getReactionDefinition());
                    go = false;
                }
            }
            if (go) {
                if (kineticsPath.matcher(xPath).find()) {
                    change.affects(ComodiTarget.getKineticsDefinition());
                } else if (defNode.getTagName().equals("reaction") && defNode.getParent().getTagName().equals("listOfReactions")) {
                    change.affects(ComodiTarget.getReactionDefinition());
                } else if (reactionsSpeciesReference.matcher(xPath).find() || reactionsModifierSpeciesReference.matcher(xPath).find()) {
                    change.affects(ComodiTarget.getParticipantDefinition());
                } else {
                    change.affects(ComodiTarget.getReactionNetworkDefinition());
                }
            }
        }
        if (diffNode.getName().equals("attribute") && !isAnnotation && nodeA != null && nodeB != null && diffNode.getAttributeValue("name").equals("metaid")) {
            String oldValue = diffNode.getAttributeValue("oldValue");
            String newValue = diffNode.getAttributeValue("newValue");
            boolean go = true;
            int countA = oldValue.length() - oldValue.replace("_", "").length();
            int countB = newValue.length() - oldValue.replace("_", "").length();
            if (go && countA != countB) {
                change.affects(ComodiTarget.getMetaIdEncoding());
                go = false;
            }
            countA = oldValue.length() - oldValue.replace("#", "").length();
            countB = newValue.length() - oldValue.replace("#", "").length();
            if (go && countA != countB) {
                change.affects(ComodiTarget.getMetaIdEncoding());
                go = false;
            }
            countA = oldValue.startsWith("_") ? 1 : 0;
            int n = countB = newValue.startsWith("_") ? 1 : 0;
            if (go && countA != countB) {
                change.affects(ComodiTarget.getMetaIdEncoding());
                go = false;
            }
            countA = oldValue.startsWith("#") ? 1 : 0;
            int n2 = countB = newValue.startsWith("#") ? 1 : 0;
            if (go && countA != countB) {
                change.affects(ComodiTarget.getMetaIdEncoding());
                go = false;
            }
            countA = oldValue.startsWith("metaid") ? 1 : 0;
            int n3 = countB = newValue.startsWith("metaid") ? 1 : 0;
            if (go && countA != countB) {
                change.affects(ComodiTarget.getMetaIdEncoding());
                go = false;
            }
        }
        if (isAnnotation) {
            if (annotationPath.matcher(xPath).find()) {
                if (creatorPath.matcher(xPath).find()) {
                    change.affects(ComodiTarget.getCreator());
                } else if (contributorPath.matcher(xPath).find()) {
                    change.affects(ComodiTarget.getContributor());
                } else if (creationDatePath.matcher(xPath).find()) {
                    change.affects(ComodiTarget.getCreationDate());
                } else if (modificationDatePath.matcher(xPath).find()) {
                    change.affects(ComodiTarget.getModificationDate());
                } else if (ontologyLink.matcher(xPath).find() && diffNode.getName().equals("attribute")) {
                    String attr10 = diffNode.getAttributeValue("name");
                    if (attr10.equals("resource") && nodeA != null && nodeB != null) {
                        change.affects(ComodiTarget.getOntologyReference());
                        String oldValue = diffNode.getAttributeValue("oldValue");
                        String newValue = diffNode.getAttributeValue("newValue");
                        if (oldValue != null && newValue != null) {
                            if (oldValue.startsWith("urn:") && !newValue.startsWith("urn:") || !oldValue.startsWith("urn:") && newValue.startsWith("urn:")) {
                                change.affects(ComodiTarget.getIdentifierEncoding());
                            }
                            if (oldValue.startsWith("http:") && !newValue.startsWith("http:") || !oldValue.startsWith("http:") && newValue.startsWith("http:")) {
                                change.affects(ComodiTarget.getIdentifierEncoding());
                            }
                            if (oldValue.contains("identifiers.org") && !newValue.contains("identifiers.org") || !oldValue.contains("identifiers.org") && newValue.contains("identifiers.org")) {
                                change.affects(ComodiTarget.getIdentifierEncoding());
                            }
                        }
                    } else {
                        change.affects(ComodiTarget.getModelAnnotation());
                    }
                } else {
                    change.affects(ComodiTarget.getModelAnnotation());
                }
            } else if (descriptionPath.matcher(xPath).find()) {
                change.affects(ComodiTarget.getTextualDescription());
            }
        }
        return change;
    }
}

