/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.algorithm;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.GraphProducer;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkCompartment;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkReaction;
import de.unirostock.sems.bives.ds.rn.ReactionNetworkSubstance;
import de.unirostock.sems.bives.exception.BivesUnsupportedException;
import de.unirostock.sems.bives.sbml.parser.SBMLCompartment;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLReaction;
import de.unirostock.sems.bives.sbml.parser.SBMLSimpleSpeciesReference;
import de.unirostock.sems.bives.sbml.parser.SBMLSpecies;
import de.unirostock.sems.bives.sbml.parser.SBMLSpeciesReference;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.HashMap;
import java.util.List;

public class SBMLGraphProducer
extends GraphProducer {
    private SBMLDocument sbmlDocA;
    private SBMLDocument sbmlDocB;
    private SimpleConnectionManager conMgmt;

    public SBMLGraphProducer(SimpleConnectionManager conMgmt, SBMLDocument sbmlDocA, SBMLDocument sbmlDocB) {
        super(false);
        this.sbmlDocA = sbmlDocA;
        this.sbmlDocB = sbmlDocB;
        this.conMgmt = conMgmt;
    }

    public SBMLGraphProducer(SBMLDocument sbmlDoc) {
        super(true);
        this.sbmlDocA = sbmlDoc;
    }

    protected void produceReactionNetwork() {
        try {
            this.processRnA();
            if (this.single) {
                this.rn.setSingleDocument();
            } else {
                this.processRnB();
            }
        }
        catch (BivesUnsupportedException e) {
            LOGGER.error((Exception)((Object)e), (Object[])new Object[]{"something bad happened"});
        }
        if (this.rn.getSubstances().size() < 1) {
            this.rn = null;
        }
    }

    protected void produceHierarchyGraph() {
        this.hn = null;
    }

    protected void processRnA() throws BivesUnsupportedException {
        SBMLModel modelA = this.sbmlDocA.getModel();
        LOGGER.info((Object[])new Object[]{"searching for compartments in A"});
        HashMap<String, SBMLCompartment> compartments = modelA.getCompartments();
        for (SBMLCompartment sBMLCompartment : compartments.values()) {
            this.rn.setCompartment((TreeNode)sBMLCompartment.getDocumentNode(), new ReactionNetworkCompartment(this.rn, sBMLCompartment.getNameOrId(), null, sBMLCompartment.getDocumentNode(), null));
        }
        LOGGER.info((Object[])new Object[]{"searching for species in A"});
        HashMap<String, SBMLSpecies> species = modelA.getSpecies();
        for (SBMLSpecies s : species.values()) {
            this.rn.setSubstance((TreeNode)s.getDocumentNode(), new ReactionNetworkSubstance(this.rn, s.getNameOrId(), null, s.getDocumentNode(), null, this.rn.getCompartment((TreeNode)s.getCompartment().getDocumentNode()), null));
        }
        LOGGER.info((Object[])new Object[]{"searching for reactions in A"});
        HashMap<String, SBMLReaction> hashMap = modelA.getReactions();
        for (SBMLReaction r : hashMap.values()) {
            ReactionNetworkReaction reaction = new ReactionNetworkReaction(this.rn, r.getNameOrId(), null, r.getDocumentNode(), null, null, null, r.isReversible());
            if (r.getCompartment() != null) {
                reaction.setCompartmentA(this.rn.getCompartment((TreeNode)r.getCompartment().getDocumentNode()));
            }
            this.rn.setReaction((TreeNode)r.getDocumentNode(), reaction);
            List<SBMLSpeciesReference> sRefs = r.getReactants();
            for (SBMLSpeciesReference sRef : sRefs) {
                reaction.addInputA(this.rn.getSubstance((TreeNode)sRef.getSpecies().getDocumentNode()), sRef.getSBOTerm());
            }
            sRefs = r.getProducts();
            for (SBMLSpeciesReference sRef : sRefs) {
                reaction.addOutputA(this.rn.getSubstance((TreeNode)sRef.getSpecies().getDocumentNode()), sRef.getSBOTerm());
            }
            List<SBMLSimpleSpeciesReference> ssRefs = r.getModifiers();
            for (SBMLSimpleSpeciesReference sRef : ssRefs) {
                SBMLSpecies spec = sRef.getSpecies();
                reaction.addModA(this.rn.getSubstance((TreeNode)spec.getDocumentNode()), sRef.getSBOTerm());
            }
        }
    }

    protected void processRnB() throws BivesUnsupportedException {
        SBMLModel modelB = this.sbmlDocB.getModel();
        LOGGER.info((Object[])new Object[]{"searching for compartments in B"});
        HashMap<String, SBMLCompartment> compartments = modelB.getCompartments();
        for (SBMLCompartment sBMLCompartment : compartments.values()) {
            DocumentNode cDoc = sBMLCompartment.getDocumentNode();
            Connection con = this.conMgmt.getConnectionForNode((TreeNode)cDoc);
            if (con == null) {
                this.rn.setCompartment((TreeNode)sBMLCompartment.getDocumentNode(), new ReactionNetworkCompartment(this.rn, sBMLCompartment.getNameOrId(), null, sBMLCompartment.getDocumentNode(), null));
                continue;
            }
            ReactionNetworkCompartment comp = this.rn.getCompartment(con.getPartnerOf((TreeNode)cDoc));
            comp.setDocB(cDoc);
            comp.setLabelB(sBMLCompartment.getNameOrId());
            this.rn.setCompartment((TreeNode)cDoc, comp);
        }
        LOGGER.info((Object[])new Object[]{"searching for species in B"});
        HashMap<String, SBMLSpecies> species = modelB.getSpecies();
        for (SBMLSpecies s : species.values()) {
            DocumentNode sDoc = s.getDocumentNode();
            Connection c = this.conMgmt.getConnectionForNode((TreeNode)sDoc);
            if (c == null) {
                this.rn.setSubstance((TreeNode)sDoc, new ReactionNetworkSubstance(this.rn, null, s.getNameOrId(), null, sDoc, null, this.rn.getCompartment((TreeNode)s.getCompartment().getDocumentNode())));
                continue;
            }
            ReactionNetworkSubstance subst = this.rn.getSubstance(c.getPartnerOf((TreeNode)sDoc));
            subst.setDocB(sDoc);
            subst.setLabelB(s.getNameOrId());
            subst.setCompartmentB(this.rn.getCompartment((TreeNode)s.getCompartment().getDocumentNode()));
            this.rn.setSubstance((TreeNode)sDoc, subst);
        }
        LOGGER.info((Object[])new Object[]{"searching for reactions in B"});
        HashMap<String, SBMLReaction> hashMap = modelB.getReactions();
        for (SBMLReaction r : hashMap.values()) {
            DocumentNode rNode = r.getDocumentNode();
            Connection c = this.conMgmt.getConnectionForNode((TreeNode)rNode);
            ReactionNetworkReaction reaction = null;
            if (c == null) {
                reaction = new ReactionNetworkReaction(this.rn, null, r.getNameOrId(), null, r.getDocumentNode(), null, null, r.isReversible());
                this.rn.setReaction((TreeNode)rNode, reaction);
            } else {
                reaction = this.rn.getReaction(c.getPartnerOf((TreeNode)rNode));
                reaction.setDocB(rNode);
                reaction.setLabelB(r.getNameOrId());
                this.rn.setReaction((TreeNode)rNode, reaction);
            }
            if (r.getCompartment() != null) {
                reaction.setCompartmentB(this.rn.getCompartment((TreeNode)r.getCompartment().getDocumentNode()));
            }
            List<SBMLSpeciesReference> sRefs = r.getReactants();
            for (SBMLSpeciesReference sRef : sRefs) {
                reaction.addInputB(this.rn.getSubstance((TreeNode)sRef.getSpecies().getDocumentNode()), sRef.getSBOTerm());
            }
            sRefs = r.getProducts();
            for (SBMLSpeciesReference sRef : sRefs) {
                reaction.addOutputB(this.rn.getSubstance((TreeNode)sRef.getSpecies().getDocumentNode()), sRef.getSBOTerm());
            }
            List<SBMLSimpleSpeciesReference> ssRefs = r.getModifiers();
            for (SBMLSimpleSpeciesReference sRef : ssRefs) {
                SBMLSpecies spec = sRef.getSpecies();
                reaction.addModB(this.rn.getSubstance((TreeNode)spec.getDocumentNode()), sRef.getSBOTerm());
            }
        }
    }
}

