/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.List;

public class SBMLEventTrigger
extends SBMLSBase {
    private MathML math;
    private Boolean initialValue;
    private Boolean persistent;

    public SBMLEventTrigger(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        List maths = documentNode.getChildrenWithTag("math");
        if (maths.size() != 1) {
            throw new BivesSBMLParseException("event trigger has " + maths.size() + " math elements. (expected exactly one element)");
        }
        this.math = new MathML((DocumentNode)maths.get(0));
        if (documentNode.getAttributeValue("initialValue") != null) {
            try {
                this.initialValue = Boolean.parseBoolean(documentNode.getAttributeValue("initialValue"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("initialValue of event trigger of unexpected format: " + documentNode.getAttributeValue("initialValue"));
            }
        } else {
            this.initialValue = null;
        }
        if (documentNode.getAttributeValue("persistent") != null) {
            try {
                this.persistent = Boolean.parseBoolean(documentNode.getAttributeValue("persistent"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("persistent of event trigger of unexpected format: " + documentNode.getAttributeValue("persistent"));
            }
        } else {
            this.persistent = null;
        }
    }

    public MathML getMath() {
        return this.math;
    }

    public void reportModification(SimpleConnectionManager conMgmt, SBMLEventTrigger a, SBMLEventTrigger b, MarkupElement me) {
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return;
        }
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        if (a.math != null && b.math != null) {
            BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        } else if (a.math != null) {
            BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), null, (MarkupElement)me);
        } else if (b.math != null) {
            BivesTools.genMathMarkupStats(null, (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        }
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
    }

    public void reportInsert(MarkupElement me) {
        BivesTools.genMathMarkupStats(null, (DocumentNode)this.math.getDocumentNode(), (MarkupElement)me);
    }

    public void reportDelete(MarkupElement me) {
        BivesTools.genMathMarkupStats((DocumentNode)this.math.getDocumentNode(), null, (MarkupElement)me);
    }
}

