/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.api;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.algorithm.DiffAnnotator;
import de.unirostock.sems.bives.api.Diff;
import de.unirostock.sems.bives.ds.graph.GraphTranslator;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorDot;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorGraphML;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorJson;
import de.unirostock.sems.bives.ds.graph.GraphTranslatorSbgnJson;
import de.unirostock.sems.bives.exception.BivesConnectionException;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.markup.Typesetting;
import de.unirostock.sems.bives.markup.TypesettingHTML;
import de.unirostock.sems.bives.markup.TypesettingMarkDown;
import de.unirostock.sems.bives.markup.TypesettingReStructuredText;
import de.unirostock.sems.bives.sbml.algorithm.SBMLConnector;
import de.unirostock.sems.bives.sbml.algorithm.SBMLDiffAnnotator;
import de.unirostock.sems.bives.sbml.algorithm.SBMLDiffInterpreter;
import de.unirostock.sems.bives.sbml.algorithm.SBMLGraphProducer;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.xmlutils.comparison.ConnectionManager;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.exception.XmlDocumentParseException;
import java.io.File;
import java.io.IOException;
import org.jdom2.JDOMException;

public class SBMLDiff
extends Diff {
    protected SBMLDocument doc1;
    protected SBMLDocument doc2;
    protected SBMLGraphProducer graphProducer;
    protected SBMLDiffInterpreter interpreter;

    public SBMLDiff(File a, File b, DiffAnnotator diffAnnotator) throws BivesSBMLParseException, BivesDocumentConsistencyException, XmlDocumentParseException, IOException, JDOMException {
        super(a, b, diffAnnotator);
        this.doc1 = new SBMLDocument(this.treeA);
        this.doc2 = new SBMLDocument(this.treeB);
    }

    public SBMLDiff(String a, String b, DiffAnnotator diffAnnotator) throws XmlDocumentParseException, IOException, JDOMException, BivesSBMLParseException, BivesDocumentConsistencyException {
        super(a, b, diffAnnotator);
        this.doc1 = new SBMLDocument(this.treeA);
        this.doc2 = new SBMLDocument(this.treeB);
    }

    public SBMLDiff(TreeDocument a, TreeDocument b, DiffAnnotator diffAnnotator) throws BivesSBMLParseException, BivesDocumentConsistencyException {
        super(a, b, diffAnnotator);
        this.doc1 = new SBMLDocument(this.treeA);
        this.doc2 = new SBMLDocument(this.treeB);
    }

    public SBMLDiff(SBMLDocument a, SBMLDocument b, DiffAnnotator diffAnnotator) {
        super(a.getTreeDocument(), b.getTreeDocument(), diffAnnotator);
        this.doc1 = a;
        this.doc2 = b;
    }

    public SBMLDiff(File a, File b) throws BivesSBMLParseException, BivesDocumentConsistencyException, XmlDocumentParseException, IOException, JDOMException {
        super(a, b, (DiffAnnotator)new SBMLDiffAnnotator());
        this.doc1 = new SBMLDocument(this.treeA);
        this.doc2 = new SBMLDocument(this.treeB);
    }

    public SBMLDiff(String a, String b) throws XmlDocumentParseException, IOException, JDOMException, BivesSBMLParseException, BivesDocumentConsistencyException {
        super(a, b, (DiffAnnotator)new SBMLDiffAnnotator());
        this.doc1 = new SBMLDocument(this.treeA);
        this.doc2 = new SBMLDocument(this.treeB);
    }

    public SBMLDiff(TreeDocument a, TreeDocument b) throws BivesSBMLParseException, BivesDocumentConsistencyException {
        super(a, b, (DiffAnnotator)new SBMLDiffAnnotator());
        this.doc1 = new SBMLDocument(this.treeA);
        this.doc2 = new SBMLDocument(this.treeB);
    }

    public SBMLDiff(SBMLDocument a, SBMLDocument b) {
        super(a.getTreeDocument(), b.getTreeDocument(), (DiffAnnotator)new SBMLDiffAnnotator());
        this.doc1 = a;
        this.doc2 = b;
    }

    public boolean mapTrees(boolean allowDifferentIds, boolean careAboutNames, boolean stricterNames) throws BivesConnectionException {
        SBMLConnector con = new SBMLConnector(this.doc1, this.doc2, allowDifferentIds, careAboutNames, stricterNames);
        con.findConnections();
        this.connections = con.getConnections();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object[])new Object[]{"sbml mapping done."});
            LOGGER.debug((Object[])new Object[]{this.connections.toString()});
            LOGGER.debug((Object[])new Object[]{"evaluating trees."});
        }
        this.treeA.getRoot().resetModifications();
        this.treeA.getRoot().evaluate((ConnectionManager)this.connections);
        this.treeB.getRoot().resetModifications();
        this.treeB.getRoot().evaluate((ConnectionManager)this.connections);
        return true;
    }

    public String getReactionsGraphML() {
        if (this.graphProducer == null) {
            this.graphProducer = new SBMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorGraphML().translate(this.graphProducer.getReactionNetwork());
    }

    public String getReport(Typesetting ts) {
        if (this.interpreter == null) {
            this.interpreter = new SBMLDiffInterpreter(this.connections, this.doc1, this.doc2);
            this.interpreter.interprete();
        }
        return ts.typeset(this.interpreter.getReport());
    }

    public String getMarkDownReport() {
        if (this.interpreter == null) {
            this.interpreter = new SBMLDiffInterpreter(this.connections, this.doc1, this.doc2);
            this.interpreter.interprete();
        }
        return new TypesettingMarkDown().typeset(this.interpreter.getReport());
    }

    public String getReStructuredTextReport() {
        if (this.interpreter == null) {
            this.interpreter = new SBMLDiffInterpreter(this.connections, this.doc1, this.doc2);
            this.interpreter.interprete();
        }
        return new TypesettingReStructuredText().typeset(this.interpreter.getReport());
    }

    public String getHTMLReport() {
        if (this.interpreter == null) {
            this.interpreter = new SBMLDiffInterpreter(this.connections, this.doc1, this.doc2);
            this.interpreter.interprete();
        }
        return new TypesettingHTML().typeset(this.interpreter.getReport());
    }

    public Object getReactionsGraph(GraphTranslator gt) throws Exception {
        if (this.graphProducer == null) {
            this.graphProducer = new SBMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return gt.translate(this.graphProducer.getReactionNetwork());
    }

    public String getReactionsDotGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new SBMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorDot().translate(this.graphProducer.getReactionNetwork());
    }

    public String getReactionsJsonGraph() {
        if (this.graphProducer == null) {
            this.graphProducer = new SBMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorJson().translate(this.graphProducer.getReactionNetwork());
    }

    public Object getHierarchyGraph(GraphTranslator gt) {
        return null;
    }

    public String getHierarchyGraphML() {
        return null;
    }

    public String getHierarchyDotGraph() {
        return null;
    }

    public String getHierarchyJsonGraph() {
        return null;
    }

    public String getReactionsSbgnJsonGraph() throws Exception {
        if (this.graphProducer == null) {
            this.graphProducer = new SBMLGraphProducer(this.connections, this.doc1, this.doc2);
        }
        return new GraphTranslatorSbgnJson().translate(this.graphProducer.getReactionNetwork());
    }
}

