/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.ds.Xhtml;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.List;

public class SBMLConstraint
extends SBMLSBase
implements DiffReporter {
    private MathML math;
    private Xhtml message;

    public SBMLConstraint(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        List nodes = documentNode.getChildrenWithTag("math");
        if (nodes.size() != 1) {
            throw new BivesSBMLParseException("constraint has " + nodes.size() + " math elements. (expected exactly one element)");
        }
        this.math = new MathML((DocumentNode)nodes.get(0));
        nodes = documentNode.getChildrenWithTag("message");
        if (nodes.size() > 1) {
            throw new BivesSBMLParseException("constraint has " + nodes.size() + " message elements. (expected not more than one element)");
        }
        if (nodes.size() == 1) {
            this.message = new Xhtml();
            DocumentNode root = (DocumentNode)nodes.get(0);
            this.message.setXhtml(root);
        }
    }

    public MathML getMath() {
        return this.math;
    }

    public Xhtml getMessage() {
        return this.message;
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        SBMLConstraint a = (SBMLConstraint)docA;
        SBMLConstraint b = (SBMLConstraint)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        MarkupElement me = new MarkupElement("-");
        BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        if (a.message != null && b.message != null) {
            String msgB;
            String msgA = a.message.toString();
            if (!msgA.equals(msgB = b.message.toString())) {
                me.addValue("message changed from: " + MarkupDocument.delete((String)msgA) + " to " + MarkupDocument.insert((String)msgB));
            }
        } else if (a.message != null) {
            me.addValue("message deleted: " + MarkupDocument.delete((String)a.message.toString()));
        } else if (b.message != null) {
            me.addValue("message inserted: " + MarkupDocument.insert((String)b.message.toString()));
        }
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)"-"));
        me.addValue(MarkupDocument.insert((String)"inserted"));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)"-"));
        me.addValue(MarkupDocument.delete((String)"deleted"));
        return me;
    }
}

