/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLRule;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;

public class SBMLRateRule
extends SBMLRule {
    private SBMLSBase variable;

    public SBMLRateRule(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        this.type = 3;
        if (documentNode.getAttributeValue("variable") == null) {
            throw new BivesSBMLParseException("rate rule doesn't define variable");
        }
        this.variable = this.resolveVariable(documentNode.getAttributeValue("variable"));
        if (this.variable == null) {
            throw new BivesSBMLParseException("cannot map varibale in rate rule: " + documentNode.getAttributeValue("variable"));
        }
    }

    public SBMLSBase getVariable() {
        return this.variable;
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        SBMLRateRule a = (SBMLRateRule)docA;
        SBMLRateRule b = (SBMLRateRule)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = SBMLModel.getSidName(a.variable);
        String idB = SBMLModel.getSidName(b.variable);
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement("RateRule for " + idA) : new MarkupElement("RateRule for " + MarkupDocument.delete((String)idA) + " &rarr; " + MarkupDocument.insert((String)idB));
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        BivesTools.genMathMarkupStats((DocumentNode)a.math.getDocumentNode(), (DocumentNode)b.math.getDocumentNode(), (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)("inserted RateRule for " + SBMLModel.getSidName(this.variable))));
        BivesTools.genMathMarkupStats(null, (DocumentNode)this.math.getDocumentNode(), (MarkupElement)me);
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)("deleted RateRule for " + SBMLModel.getSidName(this.variable))));
        BivesTools.genMathMarkupStats((DocumentNode)this.math.getDocumentNode(), null, (MarkupElement)me);
        return me;
    }
}

