/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLCompartment;
import de.unirostock.sems.bives.sbml.parser.SBMLGenericIdNameObject;
import de.unirostock.sems.bives.sbml.parser.SBMLKineticLaw;
import de.unirostock.sems.bives.sbml.parser.SBMLListOf;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSimpleSpeciesReference;
import de.unirostock.sems.bives.sbml.parser.SBMLSpeciesReference;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.comparison.Connection;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeNode;
import java.util.ArrayList;
import java.util.List;

public class SBMLReaction
extends SBMLGenericIdNameObject
implements DiffReporter {
    private boolean reversible;
    private boolean fast;
    private SBMLCompartment compartment;
    private SBMLListOf listOfReactantsNode;
    private SBMLListOf listOfProductsNode;
    private SBMLListOf listOfModifiersNode;
    private List<SBMLSpeciesReference> listOfReactants;
    private List<SBMLSpeciesReference> listOfProducts;
    private List<SBMLSimpleSpeciesReference> listOfModifiers;
    private SBMLKineticLaw kineticLaw;

    public SBMLReaction(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        SBMLSimpleSpeciesReference sr;
        int j;
        List subnodes;
        int i;
        if (documentNode.getAttributeValue("reversible") != null) {
            try {
                this.reversible = Boolean.parseBoolean(documentNode.getAttributeValue("reversible"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("reversible attr of reaction " + this.id + " of unexpected format: " + documentNode.getAttributeValue("reversible"));
            }
        } else {
            this.reversible = true;
        }
        if (documentNode.getAttributeValue("fast") != null) {
            try {
                this.fast = Boolean.parseBoolean(documentNode.getAttributeValue("fast"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("fast attr of reaction " + this.id + " of unexpected format: " + documentNode.getAttributeValue("fast"));
            }
        } else {
            this.fast = false;
        }
        String tmp = documentNode.getAttributeValue("compartment");
        if (tmp != null) {
            this.compartment = sbmlModel.getCompartment(tmp);
            if (this.compartment == null) {
                throw new BivesSBMLParseException("no valid compartment for species " + this.id + " defined: " + tmp);
            }
        }
        this.listOfReactants = new ArrayList<SBMLSpeciesReference>();
        this.listOfProducts = new ArrayList<SBMLSpeciesReference>();
        this.listOfModifiers = new ArrayList<SBMLSimpleSpeciesReference>();
        List nodes = documentNode.getChildrenWithTag("listOfReactants");
        for (i = 0; i < nodes.size(); ++i) {
            this.listOfReactantsNode = new SBMLListOf((DocumentNode)nodes.get(i), sbmlModel);
            subnodes = ((DocumentNode)nodes.get(i)).getChildrenWithTag("speciesReference");
            for (j = 0; j < subnodes.size(); ++j) {
                sr = new SBMLSpeciesReference((DocumentNode)subnodes.get(j), sbmlModel);
                this.listOfReactants.add((SBMLSpeciesReference)sr);
            }
        }
        nodes = documentNode.getChildrenWithTag("listOfProducts");
        for (i = 0; i < nodes.size(); ++i) {
            this.listOfProductsNode = new SBMLListOf((DocumentNode)nodes.get(i), sbmlModel);
            subnodes = ((DocumentNode)nodes.get(i)).getChildrenWithTag("speciesReference");
            for (j = 0; j < subnodes.size(); ++j) {
                sr = new SBMLSpeciesReference((DocumentNode)subnodes.get(j), sbmlModel);
                this.listOfProducts.add((SBMLSpeciesReference)sr);
            }
        }
        nodes = documentNode.getChildrenWithTag("listOfModifiers");
        for (i = 0; i < nodes.size(); ++i) {
            this.listOfModifiersNode = new SBMLListOf((DocumentNode)nodes.get(i), sbmlModel);
            subnodes = ((DocumentNode)nodes.get(i)).getChildrenWithTag("modifierSpeciesReference");
            for (j = 0; j < subnodes.size(); ++j) {
                sr = new SBMLSimpleSpeciesReference((DocumentNode)subnodes.get(j), sbmlModel);
                this.listOfModifiers.add(sr);
            }
        }
        nodes = documentNode.getChildrenWithTag("kineticLaw");
        if (nodes.size() > 1) {
            throw new BivesSBMLParseException("reaction " + this.id + " has " + nodes.size() + " kinetic law elements. (expected not more tha one element)");
        }
        if (nodes.size() == 1) {
            this.kineticLaw = new SBMLKineticLaw((DocumentNode)nodes.get(0), sbmlModel);
        }
    }

    public SBMLCompartment getCompartment() {
        return this.compartment;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public boolean isFast() {
        return this.fast;
    }

    public SBMLKineticLaw getKineticLaw() {
        return this.kineticLaw;
    }

    public SBMLListOf getListOfReactantsNode() {
        return this.listOfReactantsNode;
    }

    public SBMLListOf getListOfProductsNode() {
        return this.listOfProductsNode;
    }

    public SBMLListOf getListOfModifiersNode() {
        return this.listOfModifiersNode;
    }

    public List<SBMLSpeciesReference> getReactants() {
        return this.listOfReactants;
    }

    public List<SBMLSpeciesReference> getProducts() {
        return this.listOfProducts;
    }

    public List<SBMLSimpleSpeciesReference> getModifiers() {
        return this.listOfModifiers;
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        SBMLSpeciesReference partner;
        Object c;
        SBMLReaction a = (SBMLReaction)docA;
        SBMLReaction b = (SBMLReaction)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        if (a.getDocumentNode().getModification() == 128 && b.getDocumentNode().getModification() == 128) {
            return null;
        }
        String idA = a.getNameAndId();
        String idB = b.getNameAndId();
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement(idA) : new MarkupElement(MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        List<SBMLSpeciesReference> aS = a.listOfReactants;
        List<SBMLSpeciesReference> bS = b.listOfReactants;
        String sub = "";
        String ret = "";
        for (SBMLSpeciesReference sr : aS) {
            if (sub.length() > 0) {
                sub = sub + " + ";
            }
            if (conMgmt.getConnectionForNode((TreeNode)sr.getDocumentNode()) == null) {
                sub = sub + sr.reportDelete();
                continue;
            }
            c = conMgmt.getConnectionForNode((TreeNode)sr.getDocumentNode());
            partner = (SBMLSpeciesReference)b.sbmlModel.getFromNode(c.getPartnerOf((TreeNode)sr.getDocumentNode()));
            sub = sub + sr.reportModification(conMgmt, sr, partner);
        }
        for (SBMLSpeciesReference sr : bS) {
            if (conMgmt.getConnectionForNode((TreeNode)sr.getDocumentNode()) != null) continue;
            if (sub.length() > 0) {
                sub = sub + " + ";
            }
            sub = sub + sr.reportInsert();
        }
        ret = sub.length() > 0 ? ret + sub + " " + MarkupDocument.rightArrow() + " " : ret + "&Oslash; " + MarkupDocument.rightArrow() + " ";
        aS = a.listOfProducts;
        bS = b.listOfProducts;
        sub = "";
        for (SBMLSpeciesReference sr : aS) {
            if (sub.length() > 0) {
                sub = sub + " + ";
            }
            if (conMgmt.getConnectionForNode((TreeNode)sr.getDocumentNode()) == null) {
                sub = sub + sr.reportDelete();
                continue;
            }
            c = conMgmt.getConnectionForNode((TreeNode)sr.getDocumentNode());
            partner = (SBMLSpeciesReference)b.sbmlModel.getFromNode(c.getPartnerOf((TreeNode)sr.getDocumentNode()));
            sub = sub + sr.reportModification(conMgmt, sr, partner);
        }
        for (SBMLSpeciesReference sr : bS) {
            if (conMgmt.getConnectionForNode((TreeNode)sr.getDocumentNode()) != null) continue;
            if (sub.length() > 0) {
                sub = sub + " + ";
            }
            sub = sub + sr.reportInsert();
        }
        ret = sub.length() > 0 ? ret + sub : ret + "&Oslash;";
        me.addValue(ret);
        List<SBMLSimpleSpeciesReference> aM = a.listOfModifiers;
        List<SBMLSimpleSpeciesReference> bM = b.listOfModifiers;
        sub = "";
        for (SBMLSimpleSpeciesReference sr : aM) {
            if (sub.length() > 0) {
                sub = sub + "; ";
            }
            if (conMgmt.getConnectionForNode((TreeNode)sr.getDocumentNode()) == null) {
                sub = sub + sr.reportDelete();
                continue;
            }
            Connection c2 = conMgmt.getConnectionForNode((TreeNode)sr.getDocumentNode());
            SBMLSimpleSpeciesReference partner2 = (SBMLSimpleSpeciesReference)b.sbmlModel.getFromNode(c2.getPartnerOf((TreeNode)sr.getDocumentNode()));
            sub = sub + sr.reportModification(conMgmt, sr, partner2);
        }
        for (SBMLSimpleSpeciesReference sr : bM) {
            if (sub.length() > 0) {
                sub = sub + "; ";
            }
            if (conMgmt.getConnectionForNode((TreeNode)sr.getDocumentNode()) != null) continue;
            sub = sub + sr.reportInsert();
        }
        if (sub.length() > 0) {
            me.addValue("Modifiers: " + sub);
        }
        MarkupElement me2 = new MarkupElement("Kinetic Law");
        if (a.kineticLaw != null && b.kineticLaw != null) {
            a.kineticLaw.reportModification(conMgmt, a.kineticLaw, b.kineticLaw, me2);
            if (me2.getValues().size() > 0) {
                me.addSubElements(me2);
            }
        } else if (a.kineticLaw != null) {
            a.kineticLaw.reportDelete(me2);
            me.addSubElements(me2);
        } else if (b.kineticLaw != null) {
            b.kineticLaw.reportInsert(me2);
            me.addSubElements(me2);
        }
        MarkupElement me3 = new MarkupElement("notes");
        if (a.getNotes() != null && b.getNotes() != null) {
            a.getNotes().reportModification(conMgmt, a.getNotes(), b.getNotes(), me3);
            if (me3.getValues().size() > 0) {
                me.addSubElements(me3);
            }
        } else if (a.getNotes() != null) {
            a.getNotes().reportDelete(me3);
            me.addSubElements(me3);
        } else if (b.getNotes() != null) {
            b.getNotes().reportInsert(me3);
            me.addSubElements(me3);
        }
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)this.getNameAndId()));
        this.report(me, true);
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)this.getNameAndId()));
        this.report(me, false);
        return me;
    }

    public void report(MarkupElement me, boolean insert) {
        if (insert) {
            me.addValue(MarkupDocument.insert((String)"inserted"));
        } else {
            me.addValue(MarkupDocument.delete((String)"deleted"));
        }
        StringBuilder ret = new StringBuilder();
        StringBuilder sub = new StringBuilder();
        for (SBMLSpeciesReference sBMLSpeciesReference : this.listOfReactants) {
            if (sub.length() > 0) {
                sub.append(" + ");
            }
            sub.append(sBMLSpeciesReference.report());
        }
        if (sub.length() > 0) {
            ret.append((CharSequence)sub).append(" ");
        } else {
            ret.append("&Oslash; ");
        }
        ret.append(MarkupDocument.rightArrow()).append(" ");
        sub = new StringBuilder();
        for (SBMLSpeciesReference sBMLSpeciesReference : this.listOfProducts) {
            if (sub.length() > 0) {
                sub.append(" + ");
            }
            sub.append(sBMLSpeciesReference.report());
        }
        if (sub.length() > 0) {
            ret.append((CharSequence)sub);
        } else {
            ret.append("&Oslash;");
        }
        if (insert) {
            me.addValue(MarkupDocument.insert((String)ret.toString()));
        } else {
            me.addValue(MarkupDocument.delete((String)ret.toString()));
        }
        sub = new StringBuilder();
        for (SBMLSimpleSpeciesReference sBMLSimpleSpeciesReference : this.listOfModifiers) {
            if (sub.length() > 0) {
                sub.append("; ");
            }
            sub.append(sBMLSimpleSpeciesReference.report());
        }
        if (sub.length() > 0) {
            if (insert) {
                me.addValue(MarkupDocument.insert((String)("Modifiers: " + sub.toString())));
            } else {
                me.addValue(MarkupDocument.delete((String)("Modifiers: " + sub.toString())));
            }
        }
    }
}

