/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.markup.Markup;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSBase;
import de.unirostock.sems.bives.sbml.parser.SBMLUnitDefinition;
import de.unirostock.sems.xmlutils.ds.DocumentNode;

public class SBMLUnit
extends SBMLSBase
implements Markup {
    public static final String[] BASE_UNITS = new String[]{"ampere", "farad", "joule", "lux", "radian", "volt", "avogadro", "gram", "katal", "metre", "second", "watt", "becquerel", "gray", "kelvin", "mole", "siemens", "weber", "candela", "henry", "kilogram", "newton", "sievert", "coulomb", "hertz", "litre", "ohm", "steradian", "dimensionless", "item", "lumen", "pascal", "tesla"};
    public static final String[] PREDEFINED_UNITS = new String[]{"substance", "volume", "area", "length", "time"};
    private SBMLUnitDefinition kind;
    private double exponent;
    private int scale;
    private double multiplier;

    public SBMLUnit(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException, BivesDocumentConsistencyException {
        super(documentNode, sbmlModel);
        String kindStr = documentNode.getAttributeValue("kind");
        this.kind = sbmlModel.getUnitDefinition(kindStr);
        if (this.kind == null || !this.kind.isBaseUnit()) {
            throw new BivesDocumentConsistencyException("Unit kind attribute not defined or not base unit: " + kindStr);
        }
        if (documentNode.getAttributeValue("multiplier") != null) {
            try {
                this.multiplier = Double.parseDouble(documentNode.getAttributeValue("multiplier"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("multiplier of unexpected format: " + documentNode.getAttributeValue("multiplier"));
            }
        } else {
            this.multiplier = 1.0;
        }
        if (documentNode.getAttributeValue("scale") != null) {
            try {
                this.scale = Integer.parseInt(documentNode.getAttributeValue("scale"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("scale of unexpected format: " + documentNode.getAttributeValue("scale"));
            }
        } else {
            this.scale = 0;
        }
        if (documentNode.getAttributeValue("exponent") != null) {
            try {
                this.exponent = Double.parseDouble(documentNode.getAttributeValue("exponent"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("exponent of unexpected format: " + documentNode.getAttributeValue("exponent"));
            }
        } else {
            this.exponent = 1.0;
        }
    }

    public String markup() {
        StringBuilder ret = new StringBuilder("(").append(GeneralTools.prettyDouble((Double)this.multiplier, (Integer)1, (String)"", (String)MarkupDocument.multiply()));
        if (this.scale != 0) {
            ret.append("10^").append(this.scale).append(MarkupDocument.multiply());
        }
        ret.append("[").append(this.kind.name).append("]").append(GeneralTools.prettyDouble((Double)this.exponent, (Integer)1, (String)"^", (String)""));
        return ret.append(")").toString();
    }
}

