/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.markup.Markup;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLGenericIdNameObject;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLUnit;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.ArrayList;
import java.util.List;

public class SBMLUnitDefinition
extends SBMLGenericIdNameObject
implements DiffReporter,
Markup {
    private boolean baseUnit;
    private List<SBMLUnit> listOfUnits;

    public SBMLUnitDefinition(String name, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(null, sbmlModel);
        this.id = name;
        this.name = name;
        this.baseUnit = true;
    }

    public SBMLUnitDefinition(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException, BivesDocumentConsistencyException {
        super(documentNode, sbmlModel);
        this.baseUnit = false;
        this.listOfUnits = new ArrayList<SBMLUnit>();
        List lounits = documentNode.getChildrenWithTag("listOfUnits");
        for (int i = 0; i < lounits.size(); ++i) {
            DocumentNode lounit = (DocumentNode)lounits.get(i);
            List unit = lounit.getChildrenWithTag("unit");
            for (int j = 0; j < unit.size(); ++j) {
                SBMLUnit u = new SBMLUnit((DocumentNode)unit.get(j), sbmlModel);
                this.listOfUnits.add(u);
            }
        }
        if (this.listOfUnits.size() < 1) {
            throw new BivesSBMLParseException("UnitDefinition " + this.id + " has " + this.listOfUnits.size() + " units. (expected at least one unit)");
        }
    }

    public boolean isBaseUnit() {
        return this.baseUnit;
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        String newDef;
        SBMLUnitDefinition a = (SBMLUnitDefinition)docA;
        SBMLUnitDefinition b = (SBMLUnitDefinition)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = a.getNameAndId();
        String idB = b.getNameAndId();
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement(idA) : new MarkupElement(MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        String oldDef = a.markup();
        if (oldDef.equals(newDef = a.markup())) {
            me.addValue("Defined by: " + oldDef);
        } else {
            me.addValue("Definition changed from " + MarkupDocument.delete((String)oldDef) + " to " + MarkupDocument.insert((String)newDef));
        }
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)this.getNameAndId()));
        me.addValue(MarkupDocument.insert((String)"inserted"));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)this.getNameAndId()));
        me.addValue(MarkupDocument.delete((String)"deleted"));
        return me;
    }

    public String markup() {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.listOfUnits.size(); ++i) {
            ret.append(this.listOfUnits.get(i).markup());
            if (i + 1 >= this.listOfUnits.size()) continue;
            ret.append(" ").append(MarkupDocument.multiply()).append(" ");
        }
        return ret.toString();
    }
}

