/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import java.util.ArrayList;
import java.util.List;

public class SBMLDiffReport {
    private String header = "";
    private List<String> modifiedSpecies = new ArrayList<String>();
    private List<String> modifiedSpeciesTypes = new ArrayList<String>();
    private List<String> modifiedParameter = new ArrayList<String>();
    private List<String> modifiedReactions = new ArrayList<String>();
    private List<String> modifiedCompartments = new ArrayList<String>();
    private List<String> modifiedCompartmentTypes = new ArrayList<String>();
    private List<String> modifiedRules = new ArrayList<String>();
    private List<String> modifiedFunctions = new ArrayList<String>();
    private List<String> modifiedConstraints = new ArrayList<String>();
    private List<String> modifiedEvents = new ArrayList<String>();
    private List<String> modifiedInitialAssignments = new ArrayList<String>();
    private List<String> modifiedUnits = new ArrayList<String>();

    public String generateHTMLReport() {
        String report = "<h2>Diff Report</h2><p>Please keep in mind that these modifications are choosen by what we think is important!</p><p>" + this.header + "</p>";
        report = report + this.generateTable(this.modifiedSpecies, "Following Species were modified", "species");
        report = report + this.generateTable(this.modifiedSpeciesTypes, "Following SpeciesTypes were modified", "speciestypes");
        report = report + this.generateTable(this.modifiedParameter, "Following Parameter were modified", "parameter");
        report = report + this.generateTable(this.modifiedReactions, "Following Reactions were modified", "reaction");
        report = report + this.generateTable(this.modifiedCompartments, "Following Compartments were modified", "compartment");
        report = report + this.generateTable(this.modifiedCompartmentTypes, "Following CompartmentTypes were modified", "compartmenttype");
        report = report + this.generateTable(this.modifiedUnits, "Following Units were modified", "unit");
        report = report + this.generateTable(this.modifiedRules, "Following Rules were modified", "rule");
        report = report + this.generateTable(this.modifiedFunctions, "Following Functions were modified", "function");
        report = report + this.generateTable(this.modifiedConstraints, "Following Constraints were modified", "constraint");
        report = report + this.generateTable(this.modifiedEvents, "Following Events were modified", "event");
        report = report + this.generateTable(this.modifiedInitialAssignments, "Following InitialAssignments were modified", "initialssignment");
        return report;
    }

    private String generateTable(List<String> mods, String headline, String cssclass) {
        if (mods.size() < 1) {
            return "";
        }
        String rep = "";
        for (String mod : mods) {
            rep = rep + mod;
        }
        if (rep.length() < 1) {
            return "";
        }
        return "<h3 class='" + cssclass + "'>" + headline + "</h3><table class='" + cssclass + "'><thead><th>ID (name)</th><th>Modification</th></thead>" + rep + "</table>";
    }

    public void addHeader(String header) {
        this.header = this.header + header;
    }

    public void modifySpecies(String rep) {
        this.modifiedSpecies.add(rep);
    }

    public void modifySpeciesTypes(String rep) {
        this.modifiedSpeciesTypes.add(rep);
    }

    public void modifyParameter(String rep) {
        this.modifiedParameter.add(rep);
    }

    public void modifyReaction(String rep) {
        this.modifiedReactions.add(rep);
    }

    public void modifyCompartments(String rep) {
        this.modifiedCompartments.add(rep);
    }

    public void modifyCompartmentTypes(String rep) {
        this.modifiedCompartmentTypes.add(rep);
    }

    public void modifyRules(String rep) {
        this.modifiedRules.add(rep);
    }

    public void modifyFunctions(String rep) {
        this.modifiedFunctions.add(rep);
    }

    public void modifyContraints(String rep) {
        this.modifiedConstraints.add(rep);
    }

    public void modifyEvents(String rep) {
        this.modifiedEvents.add(rep);
    }

    public void modifyInitialAssignments(String rep) {
        this.modifiedInitialAssignments.add(rep);
    }

    public void modifyUnits(String rep) {
        this.modifiedUnits.add(rep);
    }
}

