/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.ds.ModelDocument;
import de.unirostock.sems.bives.exception.BivesDocumentConsistencyException;
import de.unirostock.sems.bives.exception.BivesFlattenException;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import java.util.List;

public class SBMLDocument
extends ModelDocument {
    private int level;
    private int version;
    private SBMLModel model;

    public SBMLDocument(TreeDocument doc) throws BivesSBMLParseException, BivesDocumentConsistencyException {
        super(doc);
        DocumentNode root = doc.getRoot();
        this.parseRoot(root);
        List nodes = root.getChildrenWithTag("model");
        if (nodes.size() != 1) {
            throw new BivesSBMLParseException("sbml document has " + nodes.size() + " model elements. (expected exactly one element)");
        }
        this.model = new SBMLModel((DocumentNode)nodes.get(0), this);
    }

    public int getLevel() {
        return this.level;
    }

    public int getVersion() {
        return this.version;
    }

    public SBMLModel getModel() {
        return this.model;
    }

    private void parseRoot(DocumentNode root) throws BivesSBMLParseException {
        if (!root.getTagName().equals("sbml")) {
            throw new BivesSBMLParseException("sbml document doesn't start with sbml tag.");
        }
        try {
            this.level = Integer.parseInt(root.getAttributeValue("level"));
        }
        catch (Exception e) {
            throw new BivesSBMLParseException("unexpected format of SBML level definition: " + root.getAttributeValue("level"));
        }
        try {
            this.version = Integer.parseInt(root.getAttributeValue("version"));
        }
        catch (Exception e) {
            throw new BivesSBMLParseException("unexpected format of SBML version definition: " + root.getAttributeValue("version"));
        }
    }

    public void flatten() throws Exception {
        throw new BivesFlattenException("not supported yet.");
    }
}

