/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.unirostock.sems.bives.algorithm.DiffReporter;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.markup.Markup;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.markup.MarkupElement;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLGenericIdNameObject;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLUnitDefinition;
import de.unirostock.sems.bives.tools.BivesTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;

public class SBMLParameter
extends SBMLGenericIdNameObject
implements DiffReporter,
Markup {
    private Double value;
    private SBMLUnitDefinition units;
    private boolean constant;

    public SBMLParameter(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        if (documentNode.getAttributeValue("value") != null) {
            try {
                this.value = Double.parseDouble(documentNode.getAttributeValue("value"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("value of parameter " + this.id + " of unexpected format: " + documentNode.getAttributeValue("value"));
            }
        }
        if (documentNode.getAttributeValue("units") != null) {
            String tmp = documentNode.getAttributeValue("units");
            this.units = sbmlModel.getUnitDefinition(tmp);
            if (this.units == null) {
                throw new BivesSBMLParseException("units attribute in parameter " + this.id + " not defined: " + tmp);
            }
        }
        if (documentNode.getAttributeValue("constant") != null) {
            try {
                this.constant = Boolean.parseBoolean(documentNode.getAttributeValue("constant"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("constant of parameter " + this.id + " of unexpected format: " + documentNode.getAttributeValue("constant"));
            }
        } else {
            this.constant = true;
        }
    }

    public double getValue() {
        return this.value;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public String markup() {
        String u = "[no units]";
        if (this.units != null) {
            u = this.units.getName();
        }
        return this.getNameAndId() + "=" + this.value + " " + u + (this.constant ? " [const]" : "");
    }

    public MarkupElement reportModification(SimpleConnectionManager conMgmt, DiffReporter docA, DiffReporter docB) {
        SBMLParameter a = (SBMLParameter)docA;
        SBMLParameter b = (SBMLParameter)docB;
        if (a.getDocumentNode().getModification() == 0 && b.getDocumentNode().getModification() == 0) {
            return null;
        }
        String idA = a.getNameAndId();
        String idB = b.getNameAndId();
        MarkupElement me = null;
        me = idA.equals(idB) ? new MarkupElement(idA) : new MarkupElement(MarkupDocument.delete((String)idA) + " " + MarkupDocument.rightArrow() + " " + MarkupDocument.insert((String)idB));
        BivesTools.genAttributeMarkupStats((DocumentNode)a.documentNode, (DocumentNode)b.documentNode, (MarkupElement)me);
        if (!a.flagMetaModifcations(me)) {
            b.flagMetaModifcations(me);
        }
        return me;
    }

    public MarkupElement reportInsert() {
        MarkupElement me = new MarkupElement(MarkupDocument.insert((String)this.getNameAndId()));
        me.addValue(MarkupDocument.insert((String)"inserted"));
        return me;
    }

    public MarkupElement reportDelete() {
        MarkupElement me = new MarkupElement(MarkupDocument.delete((String)this.getNameAndId()));
        me.addValue(MarkupDocument.delete((String)"deleted"));
        return me;
    }
}

