/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.sbml.parser;

import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.bives.algorithm.SimpleConnectionManager;
import de.unirostock.sems.bives.ds.MathML;
import de.unirostock.sems.bives.markup.MarkupDocument;
import de.unirostock.sems.bives.sbml.exception.BivesSBMLParseException;
import de.unirostock.sems.bives.sbml.parser.SBMLModel;
import de.unirostock.sems.bives.sbml.parser.SBMLSimpleSpeciesReference;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.util.List;

public class SBMLSpeciesReference
extends SBMLSimpleSpeciesReference {
    private Double stoichiometry;
    private MathML stoichiometryMath;
    private boolean constant;

    public SBMLSpeciesReference(DocumentNode documentNode, SBMLModel sbmlModel) throws BivesSBMLParseException {
        super(documentNode, sbmlModel);
        if (documentNode.getAttributeValue("stoichiometry") != null) {
            try {
                this.stoichiometry = Double.parseDouble(documentNode.getAttributeValue("stoichiometry"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("stoichiometry of species reference " + this.id + " of unexpected format: " + documentNode.getAttributeValue("stoichiometry"));
            }
        } else {
            List maths = documentNode.getChildrenWithTag("stoichiometryMath");
            if (maths.size() > 1) {
                throw new BivesSBMLParseException("SpeciesReference has " + maths.size() + " stoichiometryMath elements. (expected not more than one element)");
            }
            if (maths.size() == 1) {
                if ((maths = ((DocumentNode)maths.get(0)).getChildrenWithTag("math")).size() != 1) {
                    throw new BivesSBMLParseException("stoichiometryMath in SpeciesReference has " + maths.size() + " math elements. (expected exactly one element)");
                }
                this.stoichiometryMath = new MathML((DocumentNode)maths.get(0));
            } else {
                this.stoichiometry = 1.0;
            }
        }
        if (documentNode.getAttributeValue("constant") != null) {
            try {
                this.constant = Boolean.parseBoolean(documentNode.getAttributeValue("constant"));
            }
            catch (Exception e) {
                throw new BivesSBMLParseException("constant of species reference " + this.id + " of unexpected format: " + documentNode.getAttributeValue("constant"));
            }
        } else {
            this.constant = false;
        }
    }

    public String reportModification(SimpleConnectionManager conMgmt, SBMLSpeciesReference a, SBMLSpeciesReference b) {
        String retB;
        String retA = GeneralTools.prettyDouble((Double)a.stoichiometry, (Integer)1) + a.species.getID();
        if (retA.equals(retB = GeneralTools.prettyDouble((Double)b.stoichiometry, (Integer)1) + b.species.getID())) {
            return retA;
        }
        return MarkupDocument.delete((String)retA) + " + " + MarkupDocument.insert((String)retB);
    }

    @Override
    public String reportInsert() {
        return MarkupDocument.insert((String)(GeneralTools.prettyDouble((Double)this.stoichiometry, (Integer)1) + this.species.getID()));
    }

    @Override
    public String reportDelete() {
        return MarkupDocument.delete((String)(GeneralTools.prettyDouble((Double)this.stoichiometry, (Integer)1) + this.species.getID()));
    }

    @Override
    public String report() {
        return GeneralTools.prettyDouble((Double)this.stoichiometry, (Integer)1) + this.species.getID();
    }
}

