/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.webservice.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.unirostock.sems.bives.webservice.client.BivesComparisonRequest;
import de.unirostock.sems.bives.webservice.client.BivesComparisonResponse;
import de.unirostock.sems.bives.webservice.client.BivesRequest;
import de.unirostock.sems.bives.webservice.client.BivesResponse;
import de.unirostock.sems.bives.webservice.client.BivesSingleFileRequest;
import de.unirostock.sems.bives.webservice.client.BivesSingleFileResponse;
import de.unirostock.sems.bives.webservice.client.BivesWs;
import de.unirostock.sems.bives.webservice.client.exception.BivesClientException;
import de.unirostock.sems.bives.webservice.client.exception.BivesException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpBivesClient
implements BivesWs {
    private static final String REQUEST_FIELD_FILES = "files";
    private static final String REQUEST_FIELD_COMMANDS = "commands";
    protected String baseUrl;

    public HttpBivesClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected void performRequest(BivesRequest request, BivesResponse result) throws BivesClientException {
        if (request == null || !request.isReady()) {
            throw new IllegalArgumentException("The request isn't valid.");
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        Gson gson = new Gson();
        HashMap<String, JsonElement> requestJson = new HashMap<String, JsonElement>();
        requestJson.put(REQUEST_FIELD_FILES, gson.toJsonTree(request.getModels()));
        requestJson.put(REQUEST_FIELD_COMMANDS, gson.toJsonTree(request.getCommands()));
        String json = gson.toJson(requestJson);
        HttpPost httpRequest = new HttpPost(this.baseUrl);
        httpRequest.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
        String stringResult = null;
        HttpResponse response = null;
        try {
            response = httpClient.execute(httpRequest);
            StringBuilder stringResultBuilder = new StringBuilder();
            BufferedReader resultReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            response.getStatusLine().getStatusCode();
            String line = "";
            while ((line = resultReader.readLine()) != null) {
                stringResultBuilder.append(line);
            }
            stringResult = stringResultBuilder.toString();
        }
        catch (ClientProtocolException e) {
            throw new BivesClientException("Protocol Exception while fetching content from the server.", e);
        }
        catch (IOException e) {
            throw new BivesClientException("IO Exception while fetching content from the server.", e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new BivesClientException(MessageFormat.format("Unexpected HttpStatus while connecting to BiVeS-WS: {0}: {1}", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        if (stringResult == null || stringResult.isEmpty()) {
            throw new BivesClientException("The result returned from the BiVeS Webservice is empty or null!");
        }
        JsonObject obj = null;
        try {
            JsonParser parser = new JsonParser();
            obj = parser.parse(stringResult).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            throw new BivesClientException("Error while parsing the json result!", e);
        }
        if (obj == null) {
            throw new BivesClientException("Can not parse the json result!");
        }
        for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
            String key = entry.getKey();
            if (key.equals("error")) {
                JsonArray array = entry.getValue().getAsJsonArray();
                for (JsonElement arrayElement : array) {
                    result.addError(arrayElement.getAsString());
                }
                continue;
            }
            result.setResult(key, entry.getValue().getAsString());
        }
    }

    @Override
    public BivesSingleFileResponse performRequest(BivesSingleFileRequest request) throws BivesClientException, BivesException {
        BivesSingleFileResponse response = new BivesSingleFileResponse();
        this.performRequest(request, response);
        response.postProcess();
        return response;
    }

    @Override
    public BivesComparisonResponse performRequest(BivesComparisonRequest request) throws BivesClientException, BivesException {
        BivesComparisonResponse response = new BivesComparisonResponse();
        this.performRequest(request, response);
        response.postProcess();
        return response;
    }
}

