/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.webservice.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.unirostock.sems.bives.webservice.client.BivesComparisonRequest;
import de.unirostock.sems.bives.webservice.client.BivesComparisonResponse;
import de.unirostock.sems.bives.webservice.client.BivesRequest;
import de.unirostock.sems.bives.webservice.client.BivesResponse;
import de.unirostock.sems.bives.webservice.client.BivesSingleFileRequest;
import de.unirostock.sems.bives.webservice.client.BivesSingleFileResponse;
import de.unirostock.sems.bives.webservice.client.BivesWs;
import de.unirostock.sems.bives.webservice.client.exception.BivesClientException;
import de.unirostock.sems.bives.webservice.client.exception.BivesException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpBivesClient
implements BivesWs {
    private static final String REQUEST_FIELD_FILES = "files";
    private static final String REQUEST_FIELD_COMMANDS = "commands";
    protected String baseUrl;

    public HttpBivesClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected void performRequest(BivesRequest request, BivesResponse result) throws BivesClientException {
        if (request == null || !request.isReady()) {
            throw new IllegalArgumentException("The request isn't valid.");
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        Gson gson = new Gson();
        HashMap<String, JsonElement> requestJson = new HashMap<String, JsonElement>();
        requestJson.put(REQUEST_FIELD_FILES, gson.toJsonTree(request.getModels()));
        requestJson.put(REQUEST_FIELD_COMMANDS, gson.toJsonTree(request.getCommands()));
        String json = gson.toJson(requestJson);
        HttpPost httpRequest = new HttpPost(this.baseUrl);
        httpRequest.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        String stringResult = null;
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpRequest);
            StringBuilder stringResultBuilder = new StringBuilder();
            BufferedReader resultReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new BivesClientException(MessageFormat.format("Unexpected HttpStatus while connecting to BiVeS-WS: {0}: {1}", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            }
            String line = "";
            while ((line = resultReader.readLine()) != null) {
                stringResultBuilder.append(line);
            }
            stringResult = stringResultBuilder.toString();
        }
        catch (ClientProtocolException e) {
            throw new BivesClientException("Protocol Exception while fetching content from the server.", e);
        }
        catch (IOException e) {
            throw new BivesClientException("IO Exception while fetching content from the server.", e);
        }
        if (stringResult == null || stringResult.isEmpty()) {
            throw new BivesClientException("The result returned from the BiVeS Webservice is empty or null!");
        }
        JsonObject obj = null;
        try {
            obj = new JsonParser().parse(stringResult).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            throw new BivesClientException("Error while parsing the json result!", e);
        }
        if (obj == null) {
            throw new BivesClientException("Can not parse the json result!");
        }
        for (Map.Entry entry : obj.entrySet()) {
            JsonArray array;
            String key = (String)entry.getKey();
            if (key.equals("error")) {
                array = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (JsonElement arrayElement : array) {
                    result.addError(arrayElement.getAsString());
                }
                continue;
            }
            if (key.equals("meta") && result instanceof BivesSingleFileResponse) {
                BivesSingleFileResponse bsfr = (BivesSingleFileResponse)result;
                for (Map.Entry item : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                    if (((String)item.getKey()).equals("nodestats")) {
                        for (Map.Entry ns : ((JsonElement)item.getValue()).getAsJsonObject().entrySet()) {
                            bsfr.setNodeStats((String)ns.getKey(), ((JsonElement)ns.getValue()).getAsInt());
                        }
                        continue;
                    }
                    if (((JsonElement)item.getValue()).isJsonNull()) continue;
                    bsfr.setMeta((String)item.getKey(), ((JsonElement)item.getValue()).getAsString());
                }
                continue;
            }
            if (key.equals("documentType") && result instanceof BivesSingleFileResponse) {
                array = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (JsonElement arrayElement : array) {
                    ((BivesSingleFileResponse)result).addDocumentType(arrayElement.getAsString());
                }
                continue;
            }
            result.setResult(key, ((JsonElement)entry.getValue()).getAsString());
        }
    }

    @Override
    public BivesSingleFileResponse performRequest(BivesSingleFileRequest request) throws BivesClientException, BivesException {
        BivesSingleFileResponse response = new BivesSingleFileResponse();
        this.performRequest(request, response);
        response.postProcess();
        return response;
    }

    @Override
    public BivesComparisonResponse performRequest(BivesComparisonRequest request) throws BivesClientException, BivesException {
        BivesComparisonResponse response = new BivesComparisonResponse();
        this.performRequest(request, response);
        response.postProcess();
        return response;
    }
}

