/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.statsgenerator.algorithm;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.imageio.ImageIO;

public class BivesAuswertungImager {
    public static void main(String[] args) throws IOException {
        String STORAGE = "/srv/modelcrawler/storage";
        new File(STORAGE + "/stats/figs").mkdirs();
        BivesAuswertungImager.run(new File(STORAGE + "/stats/diffstats"), new File(STORAGE + "/stats/figs"));
    }

    public static void run(File statsFile, File outputDir) {
        int[] scalers = new int[]{30, 50, 100, 150, 200};
        int[] minOps = new int[]{30, 50, 100, 200};
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(new Filter());
        filters.add(new SbmlFilter());
        filters.add(new CellMlFilter());
        for (Filter f : filters) {
            for (int s : scalers) {
                for (int m : minOps) {
                    try {
                        BivesAuswertungImager.createImageBivesHorizontally(statsFile, f, new File(outputDir.getAbsolutePath() + "/bives-" + f + "-diffimg-scale-" + s + "-ops-" + m + ".png"), new Scale(s), m);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        BivesAuswertungImager.createImageBivesHorizontally(statsFile, f, new File(outputDir.getAbsolutePath() + "/bives-" + f + "-diffimg-log-scale-" + s + "-ops-" + m + ".png"), new LogScale(s), m);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void createImageBivesHorizontally(File in, Filter filter, File out, Scale scale, int minOps) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(in));
        Vector<double[]> nums = new Vector<double[]>();
        Vector<Object> lines = new Vector<Object>();
        double maxBives = 0.0;
        int rownum = 0;
        while (br.ready()) {
            String l = br.readLine();
            if (rownum++ == 0) continue;
            lines.add(l);
        }
        Collections.shuffle(lines);
        for (String string : lines) {
            String[] i;
            if (!filter.lineOk(string, i = string.split("\t"))) continue;
            double[] row = new double[5];
            for (int r = 0; r < 5; ++r) {
                row[r] = Integer.parseInt(i[r + 3]);
            }
            if (!(row[0] > (double)minOps)) continue;
            if (row[0] > maxBives) {
                maxBives = row[0];
            }
            nums.add(row);
        }
        br.close();
        maxBives = scale.scale(maxBives);
        System.out.println(nums.size());
        System.out.println(maxBives);
        BufferedImage img = new BufferedImage(nums.size() + 90, (int)(maxBives + 20.0), 1);
        Color color = Color.GREEN;
        Color update = Color.YELLOW;
        Color delete = Color.RED;
        Color move = Color.BLUE;
        int startBives = (int)(5.0 + maxBives);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, nums.size() + 10, (int)(maxBives + 10.0));
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHints(rh);
        g.setColor(Color.WHITE);
        g.fillRect(nums.size() + 10, 0, nums.size() + 100, (int)(maxBives + 10.0));
        g.fillRect(0, (int)(maxBives + 10.0), nums.size() + 100, (int)(maxBives + 100.0));
        g.setColor(Color.BLACK);
        g.setFont(new Font("Arial", 1, 16));
        for (int i : new int[]{1, 5, 10, 50, 100, 500, 1000, 5000, 10000, 50000}) {
            if ((double)scale.scale(i) > maxBives) break;
            int y = scale.scale(i);
            int x = nums.size() + 15;
            if (i < 1000 && scale instanceof LogScale) {
                g.drawString(i + "", x, startBives - y);
            }
            if (i == 1000) {
                g.drawString("1.000", x, startBives - y);
            }
            if (i == 5000) {
                g.drawString("5.000", x, startBives - y);
            }
            if (i == 10000) {
                g.drawString("10.000", x, startBives - y);
            }
            if (i != 50000) continue;
            g.drawString("50.000", x, startBives - y);
        }
        g.setColor(Color.WHITE);
        for (int i = 0; i < nums.size(); ++i) {
            double[] n = (double[])nums.elementAt(i);
            double width = scale.scale(n[0]);
            double inserts = width * n[1] / n[0];
            double deletes = width * n[2] / n[0];
            double moves = width * n[3] / n[0];
            double updates = width * n[4] / n[0];
            int cur = startBives;
            int next = startBives;
            int x = i + 5;
            g.setColor(update);
            g.drawLine(x, cur, x, next -= (int)updates);
            cur = next;
            g.setColor(move);
            g.drawLine(x, cur, x, next -= (int)moves);
            cur = next;
            g.setColor(color);
            g.drawLine(x, cur, x, next -= (int)inserts);
            cur = next;
            g.setColor(delete);
            g.drawLine(x, cur, x, next -= (int)deletes);
            cur = next;
        }
        g.dispose();
        ImageIO.write((RenderedImage)img, "PNG", out);
    }

    public static double sum(int a, int b, double[] n) {
        int s = 0;
        for (int i = a; i <= b; ++i) {
            s = (int)((double)s + n[i]);
        }
        return s;
    }

    static class LogScale
    extends Scale {
        public LogScale(double scaler) {
            super(scaler);
        }

        @Override
        public int scale(double s) {
            if (s < 1.0) {
                return (int)Math.round(s);
            }
            return (int)Math.round(Math.log(s) * this.scaler);
        }
    }

    static class Scale {
        double scaler;

        public Scale(double scaler) {
            this.scaler = scaler;
        }

        public int scale(double s) {
            return (int)Math.round(s / this.scaler);
        }
    }

    static class CellMlFilter
    extends Filter {
        CellMlFilter() {
        }

        @Override
        public String toString() {
            return "cellml-only";
        }

        @Override
        public boolean lineOk(String line, String[] i) {
            return line.contains("\"CellML\"");
        }
    }

    static class SbmlFilter
    extends Filter {
        SbmlFilter() {
        }

        @Override
        public String toString() {
            return "sbml-only";
        }

        @Override
        public boolean lineOk(String line, String[] i) {
            return line.contains("\"SBML\"");
        }
    }

    static class Filter {
        Filter() {
        }

        public String toString() {
            return "no-filter";
        }

        public boolean lineOk(String line, String[] i) {
            return true;
        }
    }
}

