/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.statsgenerator.algorithm;

import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.exception.XmlDocumentParseException;
import de.unirostock.sems.xmlutils.tools.DocumentTools;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public class ColorizeComodi {
    static final int TYPE_CHANGE = 0;
    static final int TYPE_ENTITY = 1;
    static final int TYPE_TARGET = 2;
    double[] maxOverall;
    double[] maxSbml;
    double[] maxCellml;
    double[] minOverall;
    double[] minSbml;
    double[] minCellml;

    public static void main(String[] args) throws IOException, XmlDocumentParseException, JDOMException {
        File out = new File("/tmp/colorized-comodi-figure.svg");
        if (out.exists()) {
            throw new IOException(out + " exists. will not overwrite it..");
        }
        ColorizeComodi coloCom = new ColorizeComodi();
        coloCom.run(coloCom.getClass().getResourceAsStream("/data/comodi-terms"), coloCom.getClass().getResourceAsStream("/comodi-fig.svg"), out);
    }

    public void run(InputStream comodiTerms, InputStream comodiFigTemplate, File comodiColorizedFigure) throws IOException, XmlDocumentParseException, JDOMException {
        this.maxOverall = new double[3];
        this.maxSbml = new double[3];
        this.maxCellml = new double[3];
        this.minOverall = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        this.minSbml = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        this.minCellml = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        HashMap<Object, ComodiCoverage> coverage = new HashMap<Object, ComodiCoverage>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(comodiTerms));
        while (reader.ready()) {
            Object[] line = reader.readLine().split("\t");
            if (line.length != 4) {
                throw new IOException("do not understand line " + Arrays.toString(line));
            }
            int p = line[0].indexOf("#");
            if (p > 0) {
                line[0] = ((String)line[0]).substring(p + 1);
            }
            if (((String)line[0]).equals("ChangedSpecification")) continue;
            coverage.put(line[0], new ComodiCoverage(ColorizeComodi.getType((String)line[0]), (String)line[1], (String)line[2], (String)line[3]));
        }
        reader.close();
        TreeDocument svg = new TreeDocument(XmlTools.readDocument((InputStream)comodiFigTemplate), null);
        for (String term : coverage.keySet()) {
            DocumentNode dn = svg.getNodeById(term);
            if (dn != null) {
                String style = dn.getAttributeValue("style");
                double val = (((ComodiCoverage)coverage.get((Object)term)).overall - this.minOverall[((ComodiCoverage)coverage.get((Object)term)).type] + 1.0) / (this.maxOverall[((ComodiCoverage)coverage.get((Object)term)).type] - this.minOverall[((ComodiCoverage)coverage.get((Object)term)).type] + 1.0);
                style = style.replace(";fill-opacity:0;", ";fill-opacity:" + val + ";");
                dn.setAttribute("style", style);
                continue;
            }
            System.err.println("did not find " + term);
        }
        GeneralTools.stringToFile((String)XmlTools.prettyPrintDocument((Document)DocumentTools.getDoc((TreeDocument)svg)), (File)comodiColorizedFigure);
    }

    private static final int getType(String term) throws IOException {
        if (term.equals("PermutationOfEntities")) {
            return 0;
        }
        if (term.equals("Deletion")) {
            return 0;
        }
        if (term.equals("Update")) {
            return 0;
        }
        if (term.equals("Move")) {
            return 0;
        }
        if (term.equals("Insertion")) {
            return 0;
        }
        if (term.equals("XmlNode")) {
            return 1;
        }
        if (term.equals("ModelId")) {
            return 1;
        }
        if (term.equals("EntityIdentifier")) {
            return 1;
        }
        if (term.equals("XmlAttribute")) {
            return 1;
        }
        if (term.equals("ModelName")) {
            return 1;
        }
        if (term.equals("EntityName")) {
            return 1;
        }
        if (term.equals("XmlText")) {
            return 1;
        }
        if (term.equals("ModelAnnotation")) {
            return 2;
        }
        if (term.equals("CreationDate")) {
            return 2;
        }
        if (term.equals("Date")) {
            return 2;
        }
        if (term.equals("ModificationDate")) {
            return 2;
        }
        if (term.equals("TextualDescription")) {
            return 2;
        }
        if (term.equals("OntologyReference")) {
            return 2;
        }
        if (term.equals("Person")) {
            return 2;
        }
        if (term.equals("Contributor")) {
            return 2;
        }
        if (term.equals("Creator")) {
            return 2;
        }
        if (term.equals("Attribution")) {
            return 2;
        }
        if (term.equals("ModelDefinition")) {
            return 2;
        }
        if (term.equals("MathematicalModelDefinition")) {
            return 2;
        }
        if (term.equals("ComponentDefinition")) {
            return 2;
        }
        if (term.equals("EventDefinition")) {
            return 2;
        }
        if (term.equals("FunctionDefinition")) {
            return 2;
        }
        if (term.equals("KineticsDefinition")) {
            return 2;
        }
        if (term.equals("RuleDefinition")) {
            return 2;
        }
        if (term.equals("UnitDefinition")) {
            return 2;
        }
        if (term.equals("NetworkDefinition")) {
            return 2;
        }
        if (term.equals("HierarchyDefinition")) {
            return 2;
        }
        if (term.equals("VariableConnectionDefinition")) {
            return 2;
        }
        if (term.equals("PortDefinition")) {
            return 2;
        }
        if (term.equals("ReactionNetworkDefinition")) {
            return 2;
        }
        if (term.equals("ParticipantDefinition")) {
            return 2;
        }
        if (term.equals("ReversibilityDefinition")) {
            return 2;
        }
        if (term.equals("ReactionDefinition")) {
            return 2;
        }
        if (term.equals("ModelEncoding")) {
            return 2;
        }
        if (term.equals("IdentifierEncoding")) {
            return 2;
        }
        if (term.equals("MetaIdEncoding")) {
            return 2;
        }
        if (term.equals("ModelSetup")) {
            return 2;
        }
        if (term.equals("ParameterSetup")) {
            return 2;
        }
        if (term.equals("SpeciesSetup")) {
            return 2;
        }
        if (term.equals("VariableSetup")) {
            return 2;
        }
        throw new IOException("cannot determine type: " + term);
    }

    class ComodiCoverage {
        double overall;
        double sbml;
        double cellml;
        int type;

        public ComodiCoverage(int type, String overall, String sbml, String cellml) {
            this.overall = Math.log(Integer.parseInt(overall));
            this.sbml = Math.log(Integer.parseInt(sbml));
            this.cellml = Math.log(Integer.parseInt(cellml));
            this.type = type;
            if (this.overall > ColorizeComodi.this.maxOverall[type]) {
                ColorizeComodi.this.maxOverall[type] = this.overall;
            }
            if (this.sbml > ColorizeComodi.this.maxSbml[type]) {
                ColorizeComodi.this.maxSbml[type] = this.sbml;
            }
            if (this.cellml > ColorizeComodi.this.maxCellml[type]) {
                ColorizeComodi.this.maxCellml[type] = this.cellml;
            }
            if (this.overall < ColorizeComodi.this.minOverall[type]) {
                ColorizeComodi.this.minOverall[type] = this.overall;
            }
            if (this.sbml < ColorizeComodi.this.minSbml[type]) {
                ColorizeComodi.this.minSbml[type] = this.sbml;
            }
            if (this.cellml < ColorizeComodi.this.minCellml[type]) {
                ColorizeComodi.this.minCellml[type] = this.cellml;
            }
        }
    }
}

