/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.statsgenerator.algorithm;

import de.binfalse.bflog.LOGGER;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class MeanNumNodesCalculator {
    public static final int REPO_BIOMODELS = 1;
    public static final int REPO_PMR = 2;

    public static void run(String in, String out) throws IOException {
        HashMap<String, File> files = new HashMap<String, File>();
        TreeSet<Object> dates = new TreeSet<Object>();
        BufferedReader br = new BufferedReader(new FileReader(in));
        boolean header = true;
        while (br.ready()) {
            Object[] line = br.readLine().split("\t");
            if (header) {
                header = false;
                continue;
            }
            if (line.length != 18) {
                br.close();
                throw new IOException("don't understand line: " + Arrays.toString(line));
            }
            if (files.get(line[15]) == null) {
                files.put(line[15], new File((String)line[15]));
            }
            ((File)files.get(line[15])).addLine(new Line(Integer.parseInt((String)line[0]), Integer.parseInt((String)line[1]), Integer.parseInt((String)line[2]), Integer.parseInt((String)line[3]), Integer.parseInt((String)line[4]), Integer.parseInt((String)line[5]), Integer.parseInt((String)line[6]), Integer.parseInt((String)line[7]), Integer.parseInt((String)line[8]), Integer.parseInt((String)line[9]), Integer.parseInt((String)line[10]), (String)line[12], (String)line[13], (String)line[17]));
            dates.add(line[13]);
        }
        br.close();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        bw.write("date\ttype\tnFiles\tnodes\tcomponents\tvariables\tunits\tspecies\treactions\tcompartments\tfunctions\tparameters\trules\tevents" + LOGGER.NEWLINE);
        SumLine prevSbml = null;
        for (String string : dates) {
            SumLine biomodels = new SumLine();
            SumLine pmr = new SumLine();
            SumLine all = new SumLine();
            for (File f : files.values()) {
                Line latest = f.getLatesBefore(string);
                if (latest == null) continue;
                all.add(latest);
                if (latest.repository == 1) {
                    biomodels.add(latest);
                    continue;
                }
                pmr.add(latest);
            }
            bw.write(string + "\tALL\t" + all + LOGGER.NEWLINE);
            bw.write(string + "\tPMR2\t" + pmr + LOGGER.NEWLINE);
            if (prevSbml == null || !prevSbml.equals(biomodels)) {
                bw.write(string + "\tBIOMODELS\t" + biomodels + LOGGER.NEWLINE);
            }
            prevSbml = biomodels;
        }
        bw.close();
    }

    public static void main(String[] args) throws IOException {
        String STORAGE = "/tmp/stats-storage";
        MeanNumNodesCalculator.run(STORAGE + "/stats/filestats", STORAGE + "/stats/repo-evolution");
    }

    public static class File {
        String name;
        List<Line> lines;

        public File(String name) {
            this.name = name;
            this.lines = new ArrayList<Line>();
        }

        public void addLine(Line l) {
            this.lines.add(l);
        }

        public Line getLatesBefore(String date) {
            Line line = null;
            for (Line l : this.lines) {
                if (l.date.compareTo(date) > 0 || line != null && l.date.compareTo(line.date) <= 0) continue;
                line = l;
            }
            return line;
        }
    }

    public static class Line {
        int nodes;
        int components;
        int variables;
        int units;
        int species;
        int reactions;
        int compartments;
        int functions;
        int parameters;
        int rules;
        int events;
        String date;
        String file;
        String type;
        String url;
        int repository;

        public Line(int nodes, int species, int reactions, int compartments, int functions, int parameters, int rules, int events, int units, int variables, int components, String type, String date, String url) {
            this.nodes = nodes;
            this.components = components;
            this.variables = variables;
            this.units = units;
            this.date = date;
            this.type = type;
            this.species = species;
            this.reactions = reactions;
            this.compartments = compartments;
            this.functions = functions;
            this.parameters = parameters;
            this.rules = rules;
            this.events = events;
            this.url = url;
            if (url.contains("d3d3LmViaS5hYy51ay9iaW9tb2RlbHMtbWFpbi8")) {
                this.repository = 1;
            } else if (url.contains("bW9kZWxzLmNlbGxtbC5vcmcv")) {
                this.repository = 2;
            } else {
                LOGGER.error((Object[])new Object[]{"don't know which repository: " + url});
                throw new RuntimeException("don't know which repository: " + url);
            }
        }
    }

    public static class SumLine {
        int nodes;
        int components;
        int variables;
        int units;
        int species;
        int reactions;
        int compartments;
        int functions;
        int parameters;
        int rules;
        int events;
        int nFiles;

        public void add(Line line) {
            ++this.nFiles;
            this.nodes += line.nodes;
            this.components += line.components;
            this.variables += line.variables;
            this.units += line.units;
            this.species += line.species;
            this.reactions += line.reactions;
            this.compartments += line.compartments;
            this.functions += line.functions;
            this.parameters += line.parameters;
            this.rules += line.rules;
            this.events += line.events;
        }

        public String toString() {
            return this.nFiles + "\t" + this.nodes + "\t" + this.components + "\t" + this.variables + "\t" + this.units + "\t" + this.species + "\t" + this.reactions + "\t" + this.compartments + "\t" + this.functions + "\t" + this.parameters + "\t" + this.rules + "\t" + this.events;
        }

        public boolean equals(SumLine line) {
            return this.nodes == line.nodes && this.components == line.components && this.variables == line.variables && this.units == line.units && this.species == line.species && this.reactions == line.reactions && this.compartments == line.compartments && this.functions == line.functions && this.parameters == line.parameters && this.rules == line.rules && this.events == line.events;
        }
    }
}

