/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.statsgenerator.algorithm;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.bives.cellml.algorithm.CellMLValidator;
import de.unirostock.sems.bives.cellml.api.CellMLDiff;
import de.unirostock.sems.bives.cellml.parser.CellMLComponent;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.cellml.parser.CellMLModel;
import de.unirostock.sems.bives.cellml.parser.CellMLUnitDictionary;
import de.unirostock.sems.bives.ds.ModelDocument;
import de.unirostock.sems.bives.ds.Patch;
import de.unirostock.sems.bives.sbml.algorithm.SBMLValidator;
import de.unirostock.sems.bives.sbml.api.SBMLDiff;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.bives.statsgenerator.ds.ComodiTermCounter;
import de.unirostock.sems.bives.statsgenerator.ds.DiffResult;
import de.unirostock.sems.bives.statsgenerator.ds.InfoJs;
import de.unirostock.sems.bives.statsgenerator.ds.Model;
import de.unirostock.sems.bives.statsgenerator.ds.ModelVersion;
import de.unirostock.sems.bives.statsgenerator.io.DiffStatsWriter;
import de.unirostock.sems.bives.statsgenerator.io.FileStatsWriter;
import de.unirostock.sems.comodi.Change;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Statement;
import org.jdom2.Element;
import org.json.simple.parser.ParseException;

public class RepositoryProcessor {
    private File storageDir;
    private File globalWorkingDir;
    private FileStatsWriter fsw;
    private DiffStatsWriter dsw;
    private InfoJs info;
    private List<Date> modelVersions;
    private Map<String, ComodiTermCounter> comodiTerms;

    public RepositoryProcessor(File storageDir, File workingDir, SBMLValidator valSBML, CellMLValidator valCellMl, FileStatsWriter fsw, DiffStatsWriter dsw, Map<String, ComodiTermCounter> comodiTerms) {
        this.info = new InfoJs(valSBML, valCellMl);
        this.storageDir = storageDir;
        this.globalWorkingDir = workingDir;
        this.fsw = fsw;
        this.dsw = dsw;
        this.modelVersions = new ArrayList<Date>();
        this.comodiTerms = comodiTerms;
    }

    public void process() {
        this.process(this.storageDir);
    }

    public void process(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.process(f);
            }
            if (!f.isFile() || !f.getName().equals("info.json")) continue;
            try {
                this.processWorkingDir(f);
            }
            catch (Exception e) {
                LOGGER.error((Exception)e, (Object[])new Object[]{"couldn't process working directory for ", f.getAbsolutePath()});
            }
        }
    }

    public void processWorkingDir(File f) throws FileNotFoundException, IOException, ParseException {
        if (!this.info.parseInfoJs(f)) {
            LOGGER.warn((Object[])new Object[]{"ignoring working directory for ", f.getAbsolutePath(), " bause parsing info told me so"});
            return;
        }
        Map<String, Model> models = this.info.getModels();
        for (String m : models.keySet()) {
            LOGGER.info((Object[])new Object[]{"processing ", m});
            this.processModel(models.get(m));
        }
        RepositoryProcessor.clean(models);
    }

    public static void clean(Map<String, Model> models) {
        for (Model m : models.values()) {
            m.clean();
        }
        Runtime.getRuntime().gc();
    }

    public void processModel(Model m) {
        System.out.println(m.getId());
        this.modelVersions.clear();
        this.modelVersions.addAll(m.getVersions());
        Collections.sort(this.modelVersions);
        for (int i = 0; i < this.modelVersions.size(); ++i) {
            ModelVersion modelVersion = m.getVersion(this.modelVersions.get(i));
            System.out.println("  -> " + this.modelVersions.get(i));
            this.generateFileStats(modelVersion, this.modelVersions.get(i), m);
            if (i <= 0) continue;
            ModelVersion originalVersion = m.getVersion(this.modelVersions.get(i - 1));
            File wd = new File(this.globalWorkingDir.getAbsolutePath() + File.separatorChar + this.fixFileName(m.getId()));
            this.compare(originalVersion, modelVersion, m, wd);
        }
    }

    private String fixFileName(String name) {
        return name.replaceAll("[^a-zA-Z0-9]", "_");
    }

    public boolean compare(ModelVersion originalVersion, ModelVersion modifiedVersion, Model m, File workingDir) {
        if (originalVersion.isSbml() != modifiedVersion.isSbml()) {
            LOGGER.error((Object[])new Object[]{"cannot compare different model types ", originalVersion, " (", originalVersion.isSbml(), ") and ", modifiedVersion, " (", modifiedVersion.isSbml(), ")"});
            return false;
        }
        DiffResult dr = new DiffResult();
        workingDir.mkdirs();
        String compareResult = workingDir.getAbsolutePath() + File.separatorChar + originalVersion.getVersionId() + "__" + modifiedVersion.getVersionId();
        LOGGER.debug((Object[])new Object[]{"  --> unix:"});
        try {
            String line;
            File diffUnix = new File(compareResult + "__unixdiff");
            ProcessBuilder pb = new ProcessBuilder("diff", originalVersion.getFile().getAbsolutePath(), modifiedVersion.getFile().getAbsolutePath());
            pb.directory(workingDir);
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedWriter bw = new BufferedWriter(new FileWriter(diffUnix));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("<") || line.startsWith("-")) {
                    dr.incrementUnixDeletes();
                } else if (line.startsWith(">") || line.startsWith("+")) {
                    dr.incrementUnixInserts();
                }
                bw.write(line);
                bw.newLine();
            }
            br.close();
            bw.close();
        }
        catch (Exception e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot unix-compare sbml models ", originalVersion, " and ", modifiedVersion});
            return false;
        }
        LOGGER.debug((Object[])new Object[]{"  -->     " + (dr.getUnixDeletes() + dr.getUnixInserts())});
        if (dr.getUnixDeletes() + dr.getUnixInserts() == 0) {
            return false;
        }
        LOGGER.debug((Object[])new Object[]{"  --> bives:"});
        try {
            SBMLDiff diff = originalVersion.isSbml() ? new SBMLDiff((SBMLDocument)originalVersion.getModelDocument(), (SBMLDocument)modifiedVersion.getModelDocument()) : new CellMLDiff((CellMLDocument)originalVersion.getModelDocument(), (CellMLDocument)modifiedVersion.getModelDocument());
            diff.mapTrees();
            GeneralTools.stringToFile((String)diff.getDiff(), (File)new File(compareResult + "__bivesdiff"));
            Patch patch = diff.getPatch();
            dr.setBivesInserts(patch.getNumInserts());
            dr.setBivesDeletes(patch.getNumDeletes());
            dr.setBivesMoves(patch.getNumMoves());
            dr.setBivesUpdates(patch.getNumUpdates());
            for (Change change : patch.getAnnotations().getChanges()) {
                for (Statement s : change.getStatements()) {
                    if (!s.getObject().toString().contains("comodi")) continue;
                    ComodiTermCounter ctc = this.comodiTerms.get(s.getObject().toString());
                    if (ctc == null) {
                        ctc = new ComodiTermCounter(s.getObject().toString());
                        this.comodiTerms.put(s.getObject().toString(), ctc);
                    }
                    if (originalVersion.isSbml()) {
                        ++ctc.nSBML;
                    }
                    if (!originalVersion.isCellml()) continue;
                    ++ctc.nCellMl;
                }
            }
            Element e = patch.getDeletes();
            for (Element el : e.getChildren()) {
                if (el.getAttribute("triggeredBy") == null) continue;
                dr.incrementTriggeredDeletes();
            }
            e = patch.getInserts();
            for (Element el : e.getChildren()) {
                if (el.getAttribute("triggeredBy") == null) continue;
                dr.incrementTriggeredInserts();
            }
            e = patch.getMoves();
            for (Element el : e.getChildren()) {
                if (el.getAttribute("triggeredBy") == null) continue;
                dr.incrementTriggeredMoves();
            }
            e = patch.getUpdates();
            for (Element el : e.getChildren()) {
                if (el.getAttribute("triggeredBy") == null) continue;
                dr.incrementTriggeredUpdates();
            }
            dr.setXmlNodes(patch.getNumNodeChanges());
            dr.setXmlAttributes(patch.getNumAttributeChanges());
            dr.setXmlTexts(patch.getNumTextChanges());
            LOGGER.debug((Object[])new Object[]{"  -->     " + (patch.getNumInserts() + patch.getNumDeletes() + patch.getNumMoves() + patch.getNumUpdates())});
        }
        catch (Exception e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot bives-compare sbml models ", originalVersion, " and ", modifiedVersion});
            return false;
        }
        String modelType = originalVersion.isSbml() ? "SBML" : "CellML";
        try {
            this.dsw.write(dr, modelType, m.getName(), originalVersion.getVersionId(), modifiedVersion.getVersionId());
        }
        catch (Exception e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot write comparison of ", originalVersion, " and ", modifiedVersion});
            return false;
        }
        return true;
    }

    public void generateFileStats(ModelVersion modelVersion, Date date, Model m) {
        HashMap docstats = modelVersion.getModelDocument().getTreeDocument().getNodeStats();
        ModelDocument doc = modelVersion.getModelDocument();
        int nUnits = RepositoryProcessor.getNumber((Integer)docstats.get("unitDefinition"));
        int nVariables = 0;
        int nComponents = 0;
        int nReactions = RepositoryProcessor.getNumber((Integer)docstats.get("reaction"));
        String fileType = "SBML";
        if (modelVersion.isCellml()) {
            fileType = "CellML";
            CellMLModel model = ((CellMLDocument)doc).getModel();
            nReactions = 0;
            nUnits = model.getUnits().getModelUnits().size();
            HashMap components = model.getComponents();
            CellMLUnitDictionary unitDict = model.getUnits();
            for (String c : components.keySet()) {
                CellMLComponent comp = (CellMLComponent)components.get(c);
                ++nComponents;
                if (unitDict.getComponentUnits(comp) != null) {
                    nUnits += unitDict.getComponentUnits(comp).size();
                }
                nVariables += comp.getVariables().size();
                nReactions += comp.getReactions().size();
            }
        }
        try {
            this.fsw.writeLine(doc.getTreeDocument().getNumNodes(), RepositoryProcessor.getNumber((Integer)docstats.get("species")), nReactions, RepositoryProcessor.getNumber((Integer)docstats.get("compartment")), RepositoryProcessor.getNumber((Integer)docstats.get("functionDefinition")), RepositoryProcessor.getNumber((Integer)docstats.get("parameter")), RepositoryProcessor.getNumber((Integer)docstats.get("assignmentRule")) + RepositoryProcessor.getNumber((Integer)docstats.get("rateRule")) + RepositoryProcessor.getNumber((Integer)docstats.get("algebraicRule")), RepositoryProcessor.getNumber((Integer)docstats.get("event")), nUnits, nVariables, nComponents, modelVersion.getFile().getAbsolutePath().contains("BIOMD0000"), fileType, date, modelVersion.getVersionId(), m.getName(), modelVersion.getXmlModelName(), modelVersion.getUrl());
        }
        catch (Exception e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot write filestats of ", modelVersion.getFile()});
        }
    }

    private static final int getNumber(Integer i) {
        if (i == null) {
            return 0;
        }
        return i;
    }
}

