/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.statsgenerator.ds;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.cellml.algorithm.CellMLValidator;
import de.unirostock.sems.bives.ds.ModelDocument;
import de.unirostock.sems.bives.sbml.algorithm.SBMLValidator;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.bives.statsgenerator.App;
import de.unirostock.sems.bives.statsgenerator.ds.Model;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class InfoJs {
    private Map<String, Model> models;
    private JSONParser parser = new JSONParser();
    private SBMLValidator valSBML;
    private CellMLValidator valCellMl;

    public InfoJs(SBMLValidator valSBML, CellMLValidator valCellMl) {
        this.valCellMl = valCellMl;
        this.valSBML = valSBML;
        this.models = new HashMap<String, Model>();
    }

    public Map<String, Model> getModels() {
        return this.models;
    }

    public boolean parseInfoJs(File file) throws FileNotFoundException, IOException, ParseException {
        this.models.clear();
        this.parser.reset();
        Object obj = this.parser.parse((Reader)new FileReader(file));
        JSONObject jsonObject = (JSONObject)obj;
        JSONObject models = (JSONObject)jsonObject.get((Object)"models");
        for (Object model : models.keySet()) {
            String modelId = (String)model;
            String[] modelInfo = modelId.replaceAll(":", "/").split("!");
            Model m = new Model(modelId);
            JSONObject versions = (JSONObject)((JSONObject)models.get(model)).get((Object)"versions");
            for (Object v : versions.keySet()) {
                String dir = (String)v;
                long time = (Long)versions.get(v);
                if (time < 10000000000L) {
                    time *= 1000L;
                }
                File versionFile = new File(file.getParentFile().getAbsolutePath() + File.separatorChar + dir + File.separatorChar + modelInfo[1]);
                if (App.speed && versionFile.length() > App.tooLarge) {
                    return false;
                }
                SBMLDocument modelDoc = null;
                boolean isSbml = false;
                if (this.valSBML.validate(versionFile)) {
                    modelDoc = this.valSBML.getDocument();
                    isSbml = true;
                } else if (this.valCellMl.validate(versionFile)) {
                    modelDoc = this.valCellMl.getDocument();
                    isSbml = false;
                } else {
                    LOGGER.warn((Object[])new Object[]{"this is neither SBML nor CellML!?: ", versionFile});
                    continue;
                }
                m.addVersion(dir, new Date(time), versionFile, (ModelDocument)modelDoc, isSbml);
            }
            this.models.put(modelId, m);
        }
        return true;
    }
}

