/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.statsgenerator.ds;

import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.ds.ModelDocument;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.bives.statsgenerator.App;
import de.unirostock.sems.bives.statsgenerator.ds.Model;
import java.io.File;
import java.util.Date;

public class ModelVersion {
    private File versionFile;
    private boolean sbml;
    private ModelDocument modelDoc;
    private Date versionDate;
    private String versionId;
    private Model model;

    public ModelVersion(String versionId, Date versionDate, File file, ModelDocument modelDoc, Model model, boolean isSbml) {
        this.versionId = versionId;
        this.versionDate = versionDate;
        this.modelDoc = modelDoc;
        this.versionFile = file;
        this.sbml = isSbml;
        this.model = model;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public File getFile() {
        return this.versionFile;
    }

    public ModelDocument getModelDocument() {
        return this.modelDoc;
    }

    public boolean isSbml() {
        return this.sbml;
    }

    public boolean isCellml() {
        return !this.sbml;
    }

    public String toString() {
        return this.versionFile.getAbsolutePath() + " [" + this.versionId + " -- " + this.versionDate + "]";
    }

    public String getXmlModelName() {
        if (this.isSbml()) {
            SBMLDocument doc = (SBMLDocument)this.getModelDocument();
            return doc.getModel().getName();
        }
        if (this.isCellml()) {
            CellMLDocument doc = (CellMLDocument)this.getModelDocument();
            return doc.getModel().getName();
        }
        return "unknown";
    }

    public String getUrl() {
        if (this.model.getId().startsWith("urn:model:models.cellml.org")) {
            String m = this.model.getId().substring(10).replaceAll(":", "/");
            int excl = m.indexOf("!");
            String repo = m.substring(0, excl);
            String model = m.substring(excl + 1);
            return App.statsUrl + "resources/" + GeneralTools.encodeBase64((byte[])repo.getBytes()) + "/" + GeneralTools.encodeBase64((byte[])model.getBytes()) + "/" + GeneralTools.encodeBase64((byte[])this.getVersionId().getBytes());
        }
        if (this.model.getId().startsWith("urn:model:ftp.ebi.ac.uk")) {
            String n = this.model.getName();
            return App.statsUrl + "resources/" + GeneralTools.encodeBase64((byte[])"www.ebi.ac.uk/biomodels-main/".getBytes()) + "/" + GeneralTools.encodeBase64((byte[])n.substring(0, n.length() - 4).getBytes()) + "/" + GeneralTools.encodeBase64((byte[])this.getVersionId().getBytes());
        }
        return "unknown";
    }

    public void clean() {
        this.modelDoc = null;
    }
}

