/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.statsgenerator;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.GeneralTools;
import de.unirostock.sems.ModelCrawler.CrawlerAPI;
import de.unirostock.sems.bives.cellml.algorithm.CellMLValidator;
import de.unirostock.sems.bives.sbml.algorithm.SBMLValidator;
import de.unirostock.sems.bives.statsgenerator.algorithm.ColorizeComodi;
import de.unirostock.sems.bives.statsgenerator.algorithm.MeanNumNodesCalculator;
import de.unirostock.sems.bives.statsgenerator.algorithm.RepositoryProcessor;
import de.unirostock.sems.bives.statsgenerator.ds.ComodiTermCounter;
import de.unirostock.sems.bives.statsgenerator.io.DiffStatsWriter;
import de.unirostock.sems.bives.statsgenerator.io.FileStatsWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class App {
    public static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private FileStatsWriter fsw;
    private DiffStatsWriter dsw;
    public static long tooLarge = 0xA00000L;
    private static final SBMLValidator valSBML = new SBMLValidator();
    private static final CellMLValidator valCellMl = new CellMLValidator();
    public static boolean speed = false;
    public static String statsUrl = "http://most.sems.uni-rostock.de/";
    private Map<String, ComodiTermCounter> comodiTerms;
    private String date = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());

    public static void main(String[] args) throws IOException, org.json.simple.parser.ParseException {
        String STORAGE = "/srv/modelstats/storage";
        String WORKING = "/srv/modelstats/working";
        speed = false;
        Options options = new Options();
        options.addOption("f", "fast", false, "be quick and neglect files bigger than 10M");
        options.addOption("s", "storage", true, "set the storage location, defaults to " + STORAGE);
        options.addOption("w", "working", true, "set the working directory, defaults to " + WORKING);
        options.addOption("h", "help", false, "print this help message");
        try {
            CommandLine line = new DefaultParser().parse(options, args);
            if (line.hasOption("f")) {
                speed = true;
            }
            if (line.hasOption("s")) {
                STORAGE = line.getOptionValue("s");
            }
            if (line.hasOption("w")) {
                WORKING = line.getOptionValue("w");
            }
            if (line.hasOption("h")) {
                throw new ParseException("you need help");
            }
        }
        catch (ParseException exp) {
            System.out.println("Unexpected exception: " + exp.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.setOptionComparator((Comparator)new Comparator<Option>(){
                private static final String OPTS_ORDER = "hcrio";

                @Override
                public int compare(Option o1, Option o2) {
                    return OPTS_ORDER.indexOf(o1.getLongOpt()) - OPTS_ORDER.indexOf(o2.getLongOpt());
                }
            });
            formatter.printHelp("java -jar statsgenerator.jar", options, true);
            return;
        }
        new File(WORKING).mkdirs();
        LOGGER.setMinLevel((int)4);
        LOGGER.setLogFile((File)new File(WORKING + "/bflog-differ"));
        LOGGER.setLogToFile((boolean)true);
        LOGGER.setLogStackTrace((boolean)true);
        App app = new App(STORAGE, WORKING);
        app.goForIt(STORAGE, WORKING);
        LOGGER.closeLogger();
    }

    public App(String storageDir, String workingDir) throws IOException {
        new File(storageDir + "/stats/").mkdirs();
        this.fsw = new FileStatsWriter(storageDir + "/stats/filestats-" + this.date);
        this.fsw.create();
        this.dsw = new DiffStatsWriter(storageDir + "/stats/diffstats-" + this.date);
        this.dsw.create();
        this.comodiTerms = new HashMap<String, ComodiTermCounter>();
    }

    public void goForIt(String storageDir, String workingDir) throws IOException, org.json.simple.parser.ParseException {
        JSONObject json = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("modelcrawler.template")));
        json.put((Object)"workingDir", (Object)workingDir);
        ((JSONObject)json.get((Object)"storage")).put((Object)"baseDir", (Object)storageDir);
        File tmp = File.createTempFile("stats-generator-", ".bives");
        tmp.deleteOnExit();
        GeneralTools.stringToFile((String)json.toJSONString(), (File)tmp);
        String[] crawlerArgs = new String[]{"-c", tmp.getAbsolutePath(), "--no-morre"};
        new CrawlerAPI(crawlerArgs);
        this.fsw.writeHeader();
        this.dsw.writeHeader();
        String biomodelsSource = storageDir + "/ftp.ebi.ac.uk";
        String biomodelsWorking = workingDir + "/biomodels-differ";
        String cellmlSource = storageDir + "/models.cellml.org";
        String cellmlWorking = workingDir + "/cellml-differ";
        long startMillis = System.currentTimeMillis();
        new RepositoryProcessor(new File(biomodelsSource), new File(biomodelsWorking), valSBML, valCellMl, this.fsw, this.dsw, this.comodiTerms).process();
        long firstStop = System.currentTimeMillis();
        new RepositoryProcessor(new File(cellmlSource), new File(cellmlWorking), valSBML, valCellMl, this.fsw, this.dsw, this.comodiTerms).process();
        long secondStop = System.currentTimeMillis();
        this.fsw.close();
        this.dsw.close();
        MeanNumNodesCalculator.run(storageDir + "/stats/filestats-" + this.date, storageDir + "/stats/repo-evolution-" + this.date);
        File comodiTermsFile = new File(storageDir + "/stats/comodi-terms-" + this.date);
        BufferedWriter bw = new BufferedWriter(new FileWriter(comodiTermsFile));
        for (String term : this.comodiTerms.keySet()) {
            ComodiTermCounter ctc = this.comodiTerms.get(term);
            bw.write(ctc.term + "\t" + (ctc.nSBML + ctc.nCellMl) + "\t" + ctc.nSBML + "\t" + ctc.nCellMl);
            bw.newLine();
        }
        bw.close();
        File comodiTermsFileSvg = new File(storageDir + "/stats/comodi-terms-" + this.date + ".svg");
        ColorizeComodi coloCom = new ColorizeComodi();
        try {
            coloCom.run(new FileInputStream(comodiTermsFile), coloCom.getClass().getResourceAsStream("/comodi-fig.svg"), comodiTermsFileSvg);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Exception)e, (Object[])new Object[]{"could not colorize the COMODI map from ", comodiTermsFile, " to ", comodiTermsFileSvg});
        }
        System.out.println("done doing statistics");
        System.out.println("startMillis " + startMillis);
        System.out.println("firstStop " + firstStop);
        System.out.println("secondStop " + secondStop);
        long time = firstStop - startMillis;
        int seconds = (int)(time / 1000L) % 60;
        int minutes = (int)(time / 60000L % 60L);
        int hours = (int)(time / 3600000L % 24L);
        System.out.println("biomodels took: " + time + "ms => " + hours + "h " + minutes + "m " + seconds + "s");
        time = secondStop - firstStop;
        seconds = (int)(time / 1000L) % 60;
        minutes = (int)(time / 60000L % 60L);
        hours = (int)(time / 3600000L % 24L);
        System.out.println("cellml model repository took: " + time + "ms => " + hours + "h " + minutes + "m " + seconds + "s");
        time = secondStop - startMillis;
        seconds = (int)(time / 1000L) % 60;
        minutes = (int)(time / 60000L % 60L);
        hours = (int)(time / 3600000L % 24L);
        System.out.println("everything took: " + time + "ms => " + hours + "h " + minutes + "m " + seconds + "s");
    }
}

