/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.statsgenerator.ds;

import de.unirostock.sems.bives.ds.ModelDocument;
import de.unirostock.sems.bives.statsgenerator.ds.ModelVersion;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Model {
    private String id;
    private String name;
    private Map<Date, ModelVersion> versions;

    public Model(String id) {
        this.id = id;
        String[] modelInfo = id.split("!");
        this.name = modelInfo[1].replaceAll(":", "/");
        this.versions = new HashMap<Date, ModelVersion>();
    }

    public void clean() {
        for (ModelVersion v : this.versions.values()) {
            v.clean();
        }
        this.versions.clear();
    }

    public String getName() {
        return this.name;
    }

    public void addVersion(String versionId, Date date, File versionFile, ModelDocument model, boolean isSbml) {
        this.versions.put(date, new ModelVersion(versionId, date, versionFile, model, this, isSbml));
    }

    public ModelVersion getVersion(Date date) {
        return this.versions.get(date);
    }

    public String getId() {
        return this.id;
    }

    public Set<Date> getVersions() {
        return this.versions.keySet();
    }
}

