/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives;

import de.unirostock.sems.bives.Main;
import de.unirostock.sems.bives.api.Diff;
import de.unirostock.sems.bives.api.RegularDiff;
import de.unirostock.sems.bives.cellml.api.CellMLDiff;
import de.unirostock.sems.bives.cellml.api.CellMLSingle;
import de.unirostock.sems.bives.markup.Typesetting;
import de.unirostock.sems.bives.merge.algorithm.ModelMerger;
import de.unirostock.sems.bives.sbml.api.SBMLDiff;
import de.unirostock.sems.bives.sbml.api.SBMLSingle;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.bives.tools.DocumentClassifier;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.jdom2.Document;
import org.json.simple.JSONObject;

public class Executer {
    public static final Pattern XML_PATTERN = Pattern.compile("^\\s*<.*", 32);
    public static final String REQ_FILES = "files";
    public static final String REQ_WANT = "get";
    public static final String REQ_WANT_META = "meta";
    public static final String REQ_WANT_DOCUMENTTYPE = "documentType";
    public static final String REQ_WANT_DIFF = "xmlDiff";
    public static final String REQ_WANT_MATCHING_IDS = "ids-must-match";
    public static final String REQ_WANT_NEGLECT_NAMES = "neglect-names";
    public static final String REQ_WANT_STRICT_NAMES = "strict-names";
    public static final String REQ_WANT_MERGE = "merge";
    public static final String REQ_WANT_REPORT_MD = "reportMd";
    public static final String REQ_WANT_REPORT_RST = "reportRST";
    public static final String REQ_WANT_REPORT_HTML = "reportHtml";
    public static final String REQ_WANT_REPORT_HTML_FP = "reportHtmlFp";
    public static final String REQ_WANT_REACTIONS_GRAPHML = "reactionsGraphml";
    public static final String REQ_WANT_REACTIONS_GRAPHML2 = "crnGraphml";
    public static final String REQ_WANT_REACTIONS_DOT = "reactionsDot";
    public static final String REQ_WANT_REACTIONS_DOT2 = "crnDot";
    public static final String REQ_WANT_REACTIONS_SBGN_JSON = "reactionsSbgnJson";
    public static final String REQ_WANT_REACTIONS_JSON = "reactionsJson";
    public static final String REQ_WANT_REACTIONS_JSON2 = "crnJson";
    public static final String REQ_WANT_COMP_HIERARCHY_GRAPHML = "compHierarchyGraphml";
    public static final String REQ_WANT_COMP_HIERARCHY_DOT = "compHierarchyDot";
    public static final String REQ_WANT_COMP_HIERARCHY_JSON = "compHierarchyJson";
    public static final String REQ_WANT_SBML = "SBML";
    public static final String REQ_WANT_CELLML = "CellML";
    public static final String REQ_WANT_REGULAR = "regular";
    public static final String REQ_WANT_SINGLE_REACTIONS_GRAPHML = "singleReactionsGraphml";
    public static final String REQ_WANT_SINGLE_REACTIONS_GRAPHML2 = "singleCrnGraphml";
    public static final String REQ_WANT_SINGLE_REACTIONS_DOT = "singleReactionsDot";
    public static final String REQ_WANT_SINGLE_REACTIONS_DOT2 = "singleCrnDot";
    public static final String REQ_WANT_SINGLE_REACTIONS_JSON = "singleReactionsJson";
    public static final String REQ_WANT_SINGLE_REACTIONS_JSON2 = "singleCrnJson";
    public static final String REQ_WANT_SINGLE_COMP_HIERARCHY_GRAPHML = "singleCompHierarchyGraphml";
    public static final String REQ_WANT_SINGLE_COMP_HIERARCHY_DOT = "singleCompHierarchyDot";
    public static final String REQ_WANT_SINGLE_COMP_HIERARCHY_JSON = "singleCompHierarchyJson";
    public static final String REQ_WANT_SINGLE_FLATTEN = "singleFlatten";
    public static final String REQ_DEBUG = "debug";
    public static final String REQ_DEBUGG = "debugg";
    public static final String REQ_XML = "xml";
    public static final String REQ_INC_ANNO = "inclAnnotations";
    public static final String REQ_SEP_ANNO = "separateAnnotations";
    public static final String REQ_JSON = "json";
    public static final String REQ_CA = "combinearchive";
    public static final String REQ_OUT = "out";
    public static final String REQ_HELP = "help";
    private List<String> comparisonOptions;
    private List<String> singleOptions;
    private List<String> commonOptions;
    private Options options;

    public Options getOptions() {
        return this.options;
    }

    public Executer() {
        this.fillOptions();
    }

    private void fillOptions() {
        this.options = new Options();
        this.options.addOption(Option.builder((String)"v").longOpt(REQ_DEBUG).desc("enable verbose mode").build());
        this.options.addOption(Option.builder().longOpt(REQ_DEBUGG).desc("enable even more verbose mode").build());
        this.options.addOptionGroup(new OptionGroup().addOption(Option.builder((String)"x").longOpt(REQ_XML).desc("encode results in XML").build()).addOption(Option.builder((String)"j").longOpt(REQ_JSON).desc("encode results in JSON").build()));
        this.options.addOption(Option.builder((String)"o").longOpt(REQ_OUT).hasArg().desc("write output to a file").build());
        this.options.addOption(Option.builder((String)"h").longOpt(REQ_HELP).desc(REQ_HELP).build());
        this.options.addOption(Option.builder().longOpt(REQ_INC_ANNO).desc("include annotations in the patch").build());
        this.options.addOption(Option.builder().longOpt(REQ_SEP_ANNO).desc("get annotations separated from the patch").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_DIFF).desc("get the diff encoded in XML format").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_MERGE).desc("merge the files").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REPORT_MD).desc("get the report of changes encoded in MarkDown").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REPORT_RST).desc("get the report of changes encoded in ReStructuredText").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REPORT_HTML).desc("get the report of changes encoded in HTML").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REPORT_HTML_FP).desc("get the report of changes embedded in full HTML page (incl. HTML skeleton)").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REACTIONS_GRAPHML).desc("get the highlighted reaction network encoded in GraphML").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REACTIONS_DOT).desc("get the highlighted reaction network encoded in DOT language").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REACTIONS_JSON).desc("get the highlighted reaction network encoded in JSON").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REACTIONS_SBGN_JSON).desc("get the highlighted reaction network encoded in an SBGN-JSON format").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REACTIONS_GRAPHML2).desc("get the highlighted reaction network encoded in GraphML (deprecated version)").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REACTIONS_DOT2).desc("get the highlighted reaction network encoded in DOT language (deprecated version)").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REACTIONS_JSON2).desc("get the highlighted reaction network encoded in JSON (deprecated version)").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_COMP_HIERARCHY_GRAPHML).desc("get the hierarchy of components in a CellML document encoded in GraphML").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_COMP_HIERARCHY_DOT).desc("get the hierarchy of components in a CellML document encoded in DOT language").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_COMP_HIERARCHY_JSON).desc("get the hierarchy of components in a CellML document encoded in JSON").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SBML).desc("force SBML comparison").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_CELLML).desc("force CellML comparison").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_REGULAR).desc("force regular XML comparison").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_MATCHING_IDS).desc("ids of mapped nodes MUST match").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_NEGLECT_NAMES).desc("treat names as usual attributes").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_STRICT_NAMES).desc("compare names more strictly").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_DOCUMENTTYPE).desc("get the documentType of an XML file").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_META).desc("get some meta information about an XML file").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_REACTIONS_JSON).desc("get the reaction network of a single file encoded in JSON").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_REACTIONS_GRAPHML).desc("get the reaction network of a single file encoded in GraphML").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_REACTIONS_DOT).desc("get the reaction network of a single file encoded in DOT language").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_REACTIONS_JSON2).desc("get the reaction network of a single file encoded in JSON (deprecated version)").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_REACTIONS_GRAPHML2).desc("get the reaction network of a single file encoded in GraphML (deprecated version)").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_REACTIONS_DOT2).desc("get the reaction network of a single file encoded in DOT language (deprecated version)").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_COMP_HIERARCHY_JSON).desc("get the hierarchy of components in a single CellML document encoded in JSON").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_COMP_HIERARCHY_GRAPHML).desc("get the hierarchy of components in a single CellML document encoded in GraphML").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_COMP_HIERARCHY_DOT).desc("get the hierarchy of components in a single CellML document encoded in DOT language").build());
        this.options.addOption(Option.builder().longOpt(REQ_WANT_SINGLE_FLATTEN).desc("flatten the model").build());
    }

    public void executeSingle(String document, JSONObject toReturn, CommandLine line, List<Exception> errors) throws Exception {
        int type;
        TreeDocument td = null;
        if (XML_PATTERN.matcher(document).find()) {
            td = new TreeDocument(XmlTools.readDocument((String)document), null);
        } else {
            URL url = new URL(document);
            td = new TreeDocument(XmlTools.readDocument((URL)url), url.toURI());
        }
        DocumentClassifier classifier = null;
        if (line.hasOption(REQ_WANT_META)) {
            SBMLDocument doc;
            classifier = new DocumentClassifier();
            type = classifier.classify(td);
            JSONObject json = new JSONObject();
            if ((type & 2) > 0) {
                doc = classifier.getSbmlDocument();
                json.put((Object)"sbmlVersion", (Object)doc.getVersion());
                json.put((Object)"sbmlLevel", (Object)doc.getLevel());
                json.put((Object)"modelId", (Object)doc.getModel().getID());
                json.put((Object)"modelName", (Object)doc.getModel().getName());
            }
            if ((type & 4) > 0) {
                doc = classifier.getCellMlDocument();
                json.put((Object)"containsImports", (Object)doc.containsImports());
                json.put((Object)"modelName", (Object)doc.getModel().getName());
            }
            if ((type & 1) > 0) {
                doc = classifier.getXmlDocument();
                json.put((Object)"nodestats", (Object)doc.getNodeStats());
            }
            toReturn.put((Object)REQ_WANT_META, (Object)json);
        }
        if (line.hasOption(REQ_WANT_DOCUMENTTYPE)) {
            classifier = new DocumentClassifier();
            type = classifier.classify(td);
            toReturn.put((Object)REQ_WANT_DOCUMENTTYPE, (Object)DocumentClassifier.asJson(type));
        }
        if (line.hasOption(REQ_WANT_SINGLE_FLATTEN) || line.hasOption(REQ_WANT_SINGLE_COMP_HIERARCHY_DOT) || line.hasOption(REQ_WANT_SINGLE_COMP_HIERARCHY_JSON) || line.hasOption(REQ_WANT_SINGLE_COMP_HIERARCHY_GRAPHML) || line.hasOption(REQ_WANT_SINGLE_REACTIONS_JSON) || line.hasOption(REQ_WANT_SINGLE_REACTIONS_GRAPHML) || line.hasOption(REQ_WANT_SINGLE_REACTIONS_DOT) || line.hasOption(REQ_WANT_SINGLE_REACTIONS_JSON2) || line.hasOption(REQ_WANT_SINGLE_REACTIONS_GRAPHML2) || line.hasOption(REQ_WANT_SINGLE_REACTIONS_DOT2)) {
            CellMLSingle single = null;
            if (line.hasOption(REQ_WANT_CELLML)) {
                single = new CellMLSingle(td);
            } else if (line.hasOption(REQ_WANT_SBML)) {
                single = new SBMLSingle(td);
            } else {
                classifier = new DocumentClassifier();
                int type2 = classifier.classify(td);
                if ((type2 & 2) != 0) {
                    single = new SBMLSingle(td);
                } else if ((type2 & 4) != 0) {
                    single = new CellMLSingle(td);
                } else {
                    throw new Main.ExecutionException("cannot process this file (type is: [" + DocumentClassifier.humanReadable(type2) + "])");
                }
            }
            if (line.hasOption(REQ_WANT_SINGLE_REACTIONS_JSON) || line.hasOption(REQ_WANT_SINGLE_REACTIONS_JSON2)) {
                try {
                    toReturn.put((Object)REQ_WANT_SINGLE_REACTIONS_JSON, (Object)Executer.result(single.getReactionsJsonGraph()));
                    if (line.hasOption(REQ_WANT_SINGLE_REACTIONS_JSON2)) {
                        toReturn.put((Object)REQ_WANT_SINGLE_REACTIONS_JSON2, (Object)Executer.result(single.getReactionsJsonGraph()));
                    }
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            if (line.hasOption(REQ_WANT_SINGLE_REACTIONS_GRAPHML) || line.hasOption(REQ_WANT_SINGLE_REACTIONS_GRAPHML2)) {
                try {
                    toReturn.put((Object)REQ_WANT_SINGLE_REACTIONS_GRAPHML, (Object)Executer.result(single.getReactionsGraphML()));
                    if (line.hasOption(REQ_WANT_SINGLE_REACTIONS_GRAPHML2)) {
                        toReturn.put((Object)REQ_WANT_SINGLE_REACTIONS_GRAPHML2, (Object)Executer.result(single.getReactionsGraphML()));
                    }
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            if (line.hasOption(REQ_WANT_SINGLE_REACTIONS_DOT) || line.hasOption(REQ_WANT_SINGLE_REACTIONS_DOT2)) {
                try {
                    toReturn.put((Object)REQ_WANT_SINGLE_REACTIONS_DOT, (Object)Executer.result(single.getReactionsDotGraph()));
                    if (line.hasOption(REQ_WANT_SINGLE_REACTIONS_DOT2)) {
                        toReturn.put((Object)REQ_WANT_SINGLE_REACTIONS_DOT2, (Object)Executer.result(single.getReactionsDotGraph()));
                    }
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            if (line.hasOption(REQ_WANT_SINGLE_COMP_HIERARCHY_JSON)) {
                try {
                    toReturn.put((Object)REQ_WANT_SINGLE_COMP_HIERARCHY_JSON, (Object)Executer.result(single.getHierarchyJsonGraph()));
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            if (line.hasOption(REQ_WANT_SINGLE_COMP_HIERARCHY_GRAPHML)) {
                try {
                    toReturn.put((Object)REQ_WANT_SINGLE_COMP_HIERARCHY_GRAPHML, (Object)Executer.result(single.getHierarchyGraphML()));
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            if (line.hasOption(REQ_WANT_SINGLE_COMP_HIERARCHY_DOT)) {
                try {
                    toReturn.put((Object)REQ_WANT_SINGLE_COMP_HIERARCHY_DOT, (Object)Executer.result(single.getHierarchyDotGraph()));
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            if (line.hasOption(REQ_WANT_SINGLE_FLATTEN)) {
                try {
                    toReturn.put((Object)REQ_WANT_SINGLE_FLATTEN, (Object)Executer.result(single.flatten()));
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
        }
    }

    public void executeCompare(String document1, String document2, JSONObject toReturn, CommandLine line, List<Exception> errors) throws Exception {
        URL url;
        Document doc1 = null;
        Document doc2 = null;
        TreeDocument td1 = null;
        TreeDocument td2 = null;
        if (XML_PATTERN.matcher(document1).find()) {
            doc1 = XmlTools.readDocument((String)document1);
            td1 = new TreeDocument(doc1, null);
        } else {
            url = new URL(document1);
            doc1 = XmlTools.readDocument((URL)url);
            td1 = new TreeDocument(doc1, url.toURI());
        }
        if (XML_PATTERN.matcher(document2).find()) {
            doc2 = XmlTools.readDocument((String)document2);
            td2 = new TreeDocument(doc2, null);
        } else {
            url = new URL(document2);
            doc2 = XmlTools.readDocument((URL)url);
            td2 = new TreeDocument(doc2, url.toURI());
        }
        CellMLDiff diff = null;
        DocumentClassifier classifier = null;
        if (line.hasOption(REQ_WANT_CELLML)) {
            diff = new CellMLDiff(td1, td2);
        } else if (line.hasOption(REQ_WANT_SBML)) {
            diff = new SBMLDiff(td1, td2);
        } else if (line.hasOption(REQ_WANT_REGULAR)) {
            diff = new RegularDiff(td1, td2);
        } else {
            int type2;
            classifier = new DocumentClassifier();
            int type1 = classifier.classify(td1);
            int type = type1 & (type2 = classifier.classify(td2));
            if ((type & 2) != 0) {
                diff = new SBMLDiff(td1, td2);
            } else if ((type & 4) != 0) {
                diff = new CellMLDiff(td1, td2);
            } else if ((type & 1) != 0) {
                diff = new RegularDiff(td1, td2);
            } else {
                throw new Main.ExecutionException("cannot compare these files ([" + DocumentClassifier.humanReadable(type1) + "] [" + DocumentClassifier.humanReadable(type2) + "])");
            }
        }
        diff.mapTrees(!line.hasOption(REQ_WANT_MATCHING_IDS), !line.hasOption(REQ_WANT_NEGLECT_NAMES), line.hasOption(REQ_WANT_STRICT_NAMES));
        boolean hasOption = false;
        if (line.hasOption(REQ_WANT_REACTIONS_GRAPHML) || line.hasOption(REQ_WANT_REACTIONS_GRAPHML2)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_REACTIONS_GRAPHML, (Object)Executer.result(diff.getReactionsGraphML()));
                if (line.hasOption(REQ_WANT_REACTIONS_GRAPHML2)) {
                    toReturn.put((Object)REQ_WANT_REACTIONS_GRAPHML2, (Object)Executer.result(diff.getReactionsGraphML()));
                }
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_REACTIONS_DOT) || line.hasOption(REQ_WANT_REACTIONS_DOT2)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_REACTIONS_DOT, (Object)Executer.result(diff.getReactionsDotGraph()));
                if (line.hasOption(REQ_WANT_REACTIONS_DOT2)) {
                    toReturn.put((Object)REQ_WANT_REACTIONS_DOT2, (Object)Executer.result(diff.getReactionsDotGraph()));
                }
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_REACTIONS_JSON) || line.hasOption(REQ_WANT_REACTIONS_JSON2)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_REACTIONS_JSON, (Object)Executer.result(diff.getReactionsJsonGraph()));
                if (line.hasOption(REQ_WANT_REACTIONS_JSON2)) {
                    toReturn.put((Object)REQ_WANT_REACTIONS_JSON2, (Object)Executer.result(diff.getReactionsJsonGraph()));
                }
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_REACTIONS_SBGN_JSON)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_REACTIONS_SBGN_JSON, (Object)Executer.result(diff.getReactionsSbgnJsonGraph()));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_COMP_HIERARCHY_DOT)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_COMP_HIERARCHY_DOT, (Object)Executer.result(diff.getHierarchyDotGraph()));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_COMP_HIERARCHY_JSON)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_COMP_HIERARCHY_JSON, (Object)Executer.result(diff.getHierarchyJsonGraph()));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_COMP_HIERARCHY_GRAPHML)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_COMP_HIERARCHY_GRAPHML, (Object)Executer.result(diff.getHierarchyGraphML()));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_REPORT_HTML) || line.hasOption(REQ_WANT_REPORT_HTML_FP)) {
            try {
                hasOption = true;
                String result = Executer.result(diff.getHTMLReport());
                if (line.hasOption(REQ_WANT_REPORT_HTML)) {
                    toReturn.put((Object)REQ_WANT_REPORT_HTML, (Object)result);
                }
                if (line.hasOption(REQ_WANT_REPORT_HTML_FP) && result != null) {
                    toReturn.put((Object)REQ_WANT_REPORT_HTML_FP, (Object)(Executer.htmlPageStart() + result + Executer.htmlPageEnd()));
                }
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_REPORT_MD)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_REPORT_MD, (Object)Executer.result(diff.getMarkDownReport()));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_REPORT_RST)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_REPORT_RST, (Object)Executer.result(diff.getReStructuredTextReport()));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_SEP_ANNO)) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_SEP_ANNO, (Object)Executer.result(diff.getPatch().getAnnotationDocumentXml()));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_MERGE)) {
            try {
                hasOption = true;
                ModelMerger merger = new ModelMerger(doc1, doc2, (Diff)diff);
                toReturn.put((Object)REQ_WANT_MERGE, (Object)Executer.result(merger.getMerge()));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (line.hasOption(REQ_WANT_DIFF) || !hasOption) {
            try {
                hasOption = true;
                toReturn.put((Object)REQ_WANT_DIFF, (Object)Executer.result(diff.getDiff(line.hasOption(REQ_INC_ANNO))));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
    }

    public static String result(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String htmlPageStart() {
        return "<!DOCTYPE html>" + Typesetting.NL_TXT + "<html><head><title>BiVeS differences</title><style type=\"text/css\">.bives-insert{color:#01DF01;}.bives-delete{color:#FF4000;}.bives-attr{font-weight: bold;font-style: italic;}.bives-suppl{color:#A4A4A4;}.bives-update{color:#DFA601;}.bives-move{color:#014ADF;}.bives-suppl{font-size:.8em;}</style></head><body>";
    }

    public static String htmlPageEnd() {
        return "</body></html>";
    }
}

