/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.bives.tools;

import de.unirostock.sems.bives.cellml.parser.CellMLDocument;
import de.unirostock.sems.bives.sbml.parser.SBMLDocument;
import de.unirostock.sems.xmlutils.ds.TreeDocument;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;

public class DocumentClassifier {
    public static final int UNKNOWN = 0;
    public static final int XML = 1;
    public static final int SBML = 2;
    public static final int CELLML = 4;
    private List<Exception> exceptions;
    private int type;
    private SBMLDocument sbml;
    private CellMLDocument cellml;
    private TreeDocument xml;

    private void clear() {
        this.sbml = null;
        this.cellml = null;
        this.xml = null;
    }

    public TreeDocument getXmlDocument() {
        return this.xml;
    }

    public CellMLDocument getCellMlDocument() {
        return this.cellml;
    }

    public SBMLDocument getSbmlDocument() {
        return this.sbml;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public int classify(InputStream model, URI baseUri) {
        this.exceptions = new ArrayList<Exception>();
        this.type = 0;
        this.clear();
        try {
            return this.classify(new TreeDocument(XmlTools.readDocument((InputStream)model), baseUri));
        }
        catch (Exception e) {
            this.exceptions.add(e);
            return this.type;
        }
    }

    public int classify(TreeDocument model) {
        this.type = 0;
        this.clear();
        this.xml = model;
        this.type |= 1;
        this.isSBML(model);
        this.isCellML(model);
        return this.type;
    }

    public int classify(String model) {
        this.exceptions = new ArrayList<Exception>();
        return this.classify(new ByteArrayInputStream(model.getBytes()), null);
    }

    public int classify(File model) {
        this.exceptions = new ArrayList<Exception>();
        try {
            return this.classify(new FileInputStream(model), model.toURI());
        }
        catch (FileNotFoundException e) {
            this.exceptions.add(e);
            return 0;
        }
    }

    private void isSBML(TreeDocument doc) {
        this.exceptions = new ArrayList<Exception>();
        try {
            this.sbml = new SBMLDocument(doc);
            this.type |= 2;
        }
        catch (Exception e) {
            this.exceptions.add(e);
        }
    }

    private void isCellML(TreeDocument doc) {
        try {
            this.cellml = new CellMLDocument(doc);
            this.type |= 4;
        }
        catch (Exception e) {
            this.exceptions.add(e);
        }
    }

    public static String humanReadable(int type) {
        String ret = "";
        if ((type & 1) != 0) {
            ret = ret + "XML,";
        }
        if ((type & 4) != 0) {
            ret = ret + "CellML,";
        }
        if ((type & 2) != 0) {
            ret = ret + "SBML,";
        }
        if (ret.length() > 0) {
            return ret.substring(0, ret.length() - 1);
        }
        return "unknown type";
    }

    public static JSONArray asJson(int type) {
        JSONArray json = new JSONArray();
        if ((type & 1) != 0) {
            json.add((Object)"XML");
        }
        if ((type & 4) != 0) {
            json.add((Object)"CellML");
        }
        if ((type & 2) != 0) {
            json.add((Object)"SBML");
        }
        if (json.size() > 0) {
            return json;
        }
        json.add((Object)"unknown type");
        return json;
    }
}

