/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.caro;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.caro.CaRoConverter;
import de.unirostock.sems.caro.CaRoNotification;
import de.unirostock.sems.caro.converters.CaToRo;
import de.unirostock.sems.caro.converters.RoToCa;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CaRo {
    public static boolean DIE = true;
    public static String CARO_VERSION = "unknown";

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption(new Option("h", "help", false, "print the help message"));
        options.addOption(Option.builder().longOpt("roca").desc("convert a research object into a combine archive").build());
        options.addOption(Option.builder().longOpt("caro").desc("convert a combine archive into a research object").build());
        options.addOption(Option.builder((String)"i").longOpt("in").required().argName("FILE").hasArg().desc("source container to be converted").build());
        options.addOption(Option.builder((String)"o").longOpt("out").required().argName("FILE").hasArg().desc("target container to be created").build());
        DefaultParser parser = new DefaultParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                CaRo.help(options, null);
                return;
            }
        }
        catch (ParseException e) {
            CaRo.help(options, "Parsing of command line options failed.  Reason: " + e.getMessage());
            return;
        }
        File in = new File(line.getOptionValue("in"));
        File out = new File(line.getOptionValue("out"));
        if (!in.exists()) {
            CaRo.help(options, "file " + in + " does not exist");
            return;
        }
        if (out.exists()) {
            CaRo.help(options, "file " + out + " already exist");
            return;
        }
        if (line.hasOption("caro") && line.hasOption("roca")) {
            CaRo.help(options, "only one of --roca and --caro is allowed");
            return;
        }
        CaRoConverter conv = null;
        if (line.hasOption("caro")) {
            conv = new CaToRo(in);
        } else if (line.hasOption("roca")) {
            conv = new RoToCa(in);
        } else {
            CaRo.help(options, "you need to either supply --roca or --caro");
            return;
        }
        conv.convertTo(out);
        if (conv.hasErrors()) {
            System.err.println("There were errors!");
        }
        if (conv.hasWarnings()) {
            System.err.println("There were warnings!");
        }
        List<CaRoNotification> notifications = conv.getNotifications();
        for (CaRoNotification note : notifications) {
            System.out.println(note);
        }
    }

    public static void help(Options options, String err) {
        if (err != null && err.length() > 0) {
            System.err.println(err);
        }
        System.out.println("this is CaRo version " + CARO_VERSION);
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((Comparator)new Comparator<Option>(){
            private static final String OPTS_ORDER = "hcrio";

            @Override
            public int compare(Option o1, Option o2) {
                return OPTS_ORDER.indexOf(o1.getLongOpt()) - OPTS_ORDER.indexOf(o2.getLongOpt());
            }
        });
        formatter.printHelp("java -jar CaRo.jar", options, true);
        if (DIE) {
            System.exit(1);
        }
    }

    static {
        InputStream in = CaRo.class.getResourceAsStream("/caro-version.properties");
        if (in != null) {
            Properties prop = new Properties();
            try {
                prop.load(in);
                String v = (String)prop.get("version");
                if (v != null && v.length() > 0) {
                    CARO_VERSION = v;
                }
                in.close();
            }
            catch (IOException e) {
                LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to open CaRo version file"});
            }
        }
    }
}

