/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.caro.converters;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.caro.CaRoConverter;
import de.unirostock.sems.caro.CaRoNotification;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.CombineArchiveException;
import de.unirostock.sems.cbarchive.meta.MetaDataObject;
import de.unirostock.sems.cbarchive.meta.OmexMetaDataObject;
import de.unirostock.sems.cbarchive.meta.omex.OmexDescription;
import de.unirostock.sems.cbarchive.meta.omex.VCard;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.taverna.robundle.Bundle;
import org.apache.taverna.robundle.Bundles;
import org.apache.taverna.robundle.manifest.Agent;
import org.apache.taverna.robundle.manifest.Manifest;
import org.apache.taverna.robundle.manifest.PathAnnotation;
import org.apache.taverna.robundle.manifest.PathMetadata;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CaToRo
extends CaRoConverter {
    public CaToRo(File combineArchive) {
        super(combineArchive);
    }

    @Override
    protected boolean openSourceContainer() {
        try {
            this.combineArchive = new CombineArchive(this.sourceFile);
            List errs = this.combineArchive.getErrors();
            for (String s : errs) {
                this.notifications.add(new CaRoNotification(4, "reading archive: " + s));
            }
            return true;
        }
        catch (CombineArchiveException | IOException | ParseException | JDOMException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to read the combine archive at ", this.sourceFile});
            this.notifications.add(new CaRoNotification(8, "wasn't able to read the combine archive at " + this.sourceFile + " : " + e.getMessage()));
            return false;
        }
    }

    @Override
    protected boolean closeSourceContainer() {
        if (this.combineArchive == null) {
            return true;
        }
        try {
            this.combineArchive.close();
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"wasn't able to close combine archive ", this.sourceFile});
            this.notifications.add(new CaRoNotification(4, "wasn't able to close the combine archive at " + this.sourceFile + " : " + e.getMessage()));
            return false;
        }
    }

    @Override
    protected boolean convert() {
        try {
            this.researchObject = Bundles.createBundle();
            Manifest roManifest = this.researchObject.getManifest();
            Path annotationsDir = this.researchObject.getRoot().resolve("/.ro/annotations");
            List annotations = roManifest.getAnnotations();
            this.tagConvertedContainer(annotations);
            List mainEntries = this.combineArchive.getMainEntries();
            int annotationNumber = 0;
            for (ArchiveEntry entry : this.combineArchive.getEntries()) {
                if ((entry.getFormat().equals(URI_RO_CONV_ANNOTATION) || entry.getFormat().equals(URI_RO_COPY_ANNOTATION)) && this.handleConvertedAnnotation(entry, annotations)) continue;
                File tmp = File.createTempFile("CaRoFromCa", "tmp");
                tmp.deleteOnExit();
                entry.extractFile(tmp);
                Path target = this.researchObject.getRoot().resolve(entry.getEntityPath());
                if (!this.includeFile(target, entry)) continue;
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(tmp.toPath(), target, new CopyOption[0]);
                if (target.startsWith("/.ro/evolution.ttl")) {
                    this.notifications.add(new CaRoNotification(2, "adding history /.ro/evolution.ttl"));
                    ArrayList<Path> hist = new ArrayList<Path>();
                    hist.add(target);
                    roManifest.setHistory(hist);
                    continue;
                }
                PathMetadata pmd = roManifest.getAggregation(target);
                pmd.setConformsTo(entry.getFormat());
                annotationNumber = this.handleMetaData(pmd, target, entry.getDescriptions(), annotationsDir, annotationNumber, annotations);
                if (!mainEntries.contains(entry)) continue;
                this.setMainEntry(target, annotations);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to convert combine archive at ", this.sourceFile, " into a research object"});
            this.notifications.add(new CaRoNotification(8, "wasn't able to convert combine archive at " + this.sourceFile + " into a research object : " + e.getMessage()));
            return false;
        }
    }

    private boolean handleConvertedAnnotation(ArchiveEntry entry, List<PathAnnotation> annotations) {
        if (entry.getFormat().equals(URI_RO_CONV_ANNOTATION)) {
            try {
                File tmp = File.createTempFile("CaRoFromCa", "ConvAnnotation");
                entry.extractFile(tmp);
                Properties properties = new Properties();
                FileInputStream in = new FileInputStream(tmp);
                properties.load(in);
                in.close();
                PathAnnotation pa = new PathAnnotation();
                pa.setAbout(new URI((String)properties.get("about")));
                pa.setContent(new URI((String)properties.get("body")));
                annotations.add(pa);
                return true;
            }
            catch (IOException | URISyntaxException e) {
                LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to reintegrate converted annotation ", entry.getEntityPath()});
                this.notifications.add(new CaRoNotification(4, "wasn't able to reintegrate converted annotation " + entry.getEntityPath() + " : " + e.getMessage()));
            }
        } else if (entry.getFormat().equals(URI_RO_COPY_ANNOTATION)) {
            try {
                File tmp = File.createTempFile("CaRoFromCa", "tmp");
                tmp.deleteOnExit();
                entry.extractFile(tmp);
                Path target = this.researchObject.getRoot().resolve(entry.getEntityPath());
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(tmp.toPath(), target, new CopyOption[0]);
                return true;
            }
            catch (IOException e) {
                LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to reintegrate converted annotation ", entry.getEntityPath()});
                this.notifications.add(new CaRoNotification(4, "wasn't able to reintegrate converted annotation " + entry.getEntityPath() + " : " + e.getMessage()));
            }
        }
        return false;
    }

    private void setMainEntry(Path target, List<PathAnnotation> annotations) {
        PathAnnotation tag = new PathAnnotation();
        tag.setAbout(target);
        tag.setContent(URI_MAIN_ENTRY);
        annotations.add(tag);
    }

    private int handleMetaData(PathMetadata pmd, Path target, List<MetaDataObject> meta, Path annotationsDir, int annotationNumber, List<PathAnnotation> annotations) {
        Agent agent;
        VCard creator;
        OmexDescription omex;
        ArrayList<Agent> authors = pmd.getAuthoredBy();
        boolean addAll = true;
        if (meta.size() == 1 && meta.get(0) instanceof OmexMetaDataObject && (omex = ((OmexMetaDataObject)meta.get(0)).getOmexDescription()).getCreators().size() == 1 && ((creator = (VCard)omex.getCreators().get(0)) != null && creator.getOrganization() == null || creator.getOrganization().length() == 0) && (agent = CaToRo.vcardToAgent(creator, this.notifications)) != null) {
            if (authors == null) {
                authors = new ArrayList<Agent>();
                pmd.setAuthoredBy(authors);
            }
            authors.add(agent);
            addAll = false;
        }
        if (addAll) {
            for (MetaDataObject m : meta) {
                if (m instanceof OmexMetaDataObject) {
                    OmexDescription omex2 = ((OmexMetaDataObject)m).getOmexDescription();
                    for (VCard creator2 : omex2.getCreators()) {
                        Agent agent2 = CaToRo.vcardToAgent(creator2, this.notifications);
                        if (agent2 == null) continue;
                        if (authors == null) {
                            authors = new ArrayList();
                            pmd.setAuthoredBy(authors);
                        }
                        authors.add(agent2);
                    }
                }
                Element rdf = new Element("RDF", RDF_NAMESPACE);
                rdf.addContent((Content)m.getXmlDescription().clone());
                try {
                    if (!Files.exists(annotationsDir, new LinkOption[0])) {
                        Files.createDirectories(annotationsDir, new FileAttribute[0]);
                    }
                    Path file = annotationsDir.resolve("omex-conversion-" + ++annotationNumber + ".rdf");
                    Bundles.setStringValue((Path)file, (String)XmlTools.prettyPrintDocument((Document)new Document(rdf)));
                    PathAnnotation pa = new PathAnnotation();
                    pa.setAbout(target);
                    pa.setContent(file);
                    pa.generateAnnotationId();
                    annotations.add(pa);
                    this.tagAnnotation(pa, annotations);
                }
                catch (IOException e) {
                    LOGGER.error((Exception)e, (Object[])new Object[]{"was not able to convert annotation for entry ", m.getAbout()});
                    this.notifications.add(new CaRoNotification(4, "skipping conversion of annotation for " + m.getAbout() + " -- reason: " + e.getMessage()));
                }
            }
        }
        if (authors != null && authors.size() == 1) {
            pmd.setCreatedBy((Agent)authors.get(0));
        }
        return annotationNumber;
    }

    private void tagAnnotation(PathAnnotation pa, List<PathAnnotation> annotations) {
        PathAnnotation tag = new PathAnnotation();
        tag.setAbout(pa.getUri());
        tag.setContent(URI_OMEX_META);
        annotations.add(tag);
    }

    private void tagConvertedContainer(List<PathAnnotation> annotations) {
        PathAnnotation tag = new PathAnnotation();
        tag.setAbout(this.researchObject.getRoot());
        tag.setContent(URI_CA_RO_CONV);
        annotations.add(tag);
    }

    private boolean includeFile(Path target, ArchiveEntry entry) {
        for (String path : RO_RESTRICTIONS) {
            if (!target.startsWith(path)) continue;
            this.notifications.add(new CaRoNotification(4, "dropping " + path + " as this is a special file in research objects!"));
            return false;
        }
        if (target.startsWith("/.ro/evolution.ttl") && !entry.getFormat().equals(URI_TURTLE_MIME)) {
            this.notifications.add(new CaRoNotification(4, "dropping /.ro/evolution.ttl as this is a special file in research objects!"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean write(File target) {
        if (this.researchObject == null) {
            return false;
        }
        try {
            Bundles.closeAndSaveBundle((Bundle)this.researchObject, (Path)target.toPath());
            return true;
        }
        catch (IOException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to save research object to ", target});
            this.notifications.add(new CaRoNotification(8, "wasn't able to save research object to " + target + " : " + e.getMessage()));
            return false;
        }
    }

    public Bundle getResearchObject() {
        return this.researchObject;
    }
}

