/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.caro.converters;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bfutils.AlphabetIterator;
import de.unirostock.sems.caro.CaRo;
import de.unirostock.sems.caro.CaRoConverter;
import de.unirostock.sems.caro.CaRoNotification;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.CombineArchiveException;
import de.unirostock.sems.cbarchive.meta.MetaDataFile;
import de.unirostock.sems.cbarchive.meta.MetaDataObject;
import de.unirostock.sems.cbarchive.meta.OmexMetaDataObject;
import de.unirostock.sems.cbarchive.meta.omex.OmexDescription;
import de.unirostock.sems.cbarchive.meta.omex.VCard;
import de.unirostock.sems.cbext.Formatizer;
import de.unirostock.sems.xmlutils.tools.XmlTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.taverna.robundle.Bundles;
import org.apache.taverna.robundle.manifest.Agent;
import org.apache.taverna.robundle.manifest.Manifest;
import org.apache.taverna.robundle.manifest.PathAnnotation;
import org.apache.taverna.robundle.manifest.PathMetadata;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public class RoToCa
extends CaRoConverter {
    private List<PathAnnotation> handledAnnotations;
    private File temporaryLocation;

    public RoToCa(File researchObject) {
        super(researchObject);
    }

    @Override
    protected boolean openSourceContainer() {
        try {
            String mime = Files.probeContentType(this.sourceFile.toPath());
            if (!mime.equals("application/vnd.wf4ever.robundle+zip")) {
                this.notifications.add(new CaRoNotification(8, "file at " + this.sourceFile + " does not seem to be a research object: wrong mime type : " + mime));
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"wasn't able to get mime type of ", this.sourceFile});
            this.notifications.add(new CaRoNotification(8, "wasn't able to get mime type of " + this.sourceFile + " : " + e.getMessage()));
        }
        try {
            this.researchObject = Bundles.openBundleReadOnly((Path)this.sourceFile.toPath());
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"wasn't able to read the research object at ", this.sourceFile});
            this.notifications.add(new CaRoNotification(8, "wasn't able to read the combine archive at " + this.sourceFile + " : " + e.getMessage()));
            return false;
        }
    }

    @Override
    protected boolean closeSourceContainer() {
        if (this.researchObject == null) {
            return true;
        }
        try {
            this.researchObject.close();
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"wasn't able to close research object ", this.sourceFile});
            this.notifications.add(new CaRoNotification(4, "wasn't able to close the research object at " + this.sourceFile + " : " + e.getMessage()));
            return false;
        }
    }

    @Override
    protected boolean convert() {
        this.handledAnnotations = new ArrayList<PathAnnotation>();
        try {
            ArchiveEntry entry;
            URI format;
            Object tmp;
            this.temporaryLocation = File.createTempFile("CaRoFromRo", "container");
            this.temporaryLocation.delete();
            this.combineArchive = new CombineArchive(this.temporaryLocation);
            HashMap<String, ArchiveEntry> archiveEntries = new HashMap<String, ArchiveEntry>();
            Manifest roManifest = this.researchObject.getManifest();
            List annotations = roManifest.getAnnotations();
            List aggregations = roManifest.getAggregates();
            for (PathMetadata pmd : aggregations) {
                if (pmd.getFile() != null && Files.isDirectory(pmd.getFile(), new LinkOption[0]) || pmd.getFile() == null && !this.handleRemoteFile(pmd)) continue;
                tmp = File.createTempFile("CaRoFromRo", pmd.getFile().getFileName().toString());
                ((File)tmp).delete();
                Files.copy(pmd.getFile(), ((File)tmp).toPath(), new CopyOption[0]);
                ((File)tmp).deleteOnExit();
                if (!this.includeFile(pmd.getFile())) continue;
                format = pmd.getConformsTo();
                if (format == null) {
                    format = Formatizer.guessFormat((File)tmp);
                }
                entry = this.combineArchive.addEntry((File)tmp, pmd.getFile().toString(), format);
                archiveEntries.put(entry.getFilePath(), entry);
                this.handleAnnotations(pmd.getFile(), pmd, annotations, entry, archiveEntries);
                this.handleCreators(entry, pmd);
            }
            if (roManifest.getHistory() != null) {
                for (Path hist : roManifest.getHistory()) {
                    tmp = File.createTempFile("CaRoFromRo", hist.getFileName().toString());
                    ((File)tmp).delete();
                    Files.copy(hist, ((File)tmp).toPath(), new CopyOption[0]);
                    ((File)tmp).deleteOnExit();
                    if (!this.includeFile(hist)) continue;
                    URI uRI = format = hist.toString().equals("evolution.ttl") ? URI_TURTLE_MIME : null;
                    if (format == null) {
                        format = Formatizer.guessFormat((File)tmp);
                    }
                    entry = this.combineArchive.addEntry((File)tmp, "/.ro/" + hist.toString(), format);
                    archiveEntries.put(entry.getFilePath(), entry);
                }
            }
            String annotationsDir = "/.ro/annotations/";
            AlphabetIterator alhpa = AlphabetIterator.getLowerCaseIterator();
            for (PathAnnotation annot : annotations) {
                if (this.handledAnnotations.contains(annot) || annot.getContent().equals(URI_CA_RO_CONV)) continue;
                try {
                    File newAnnotation = Files.createTempFile("CaRoFromRoConvertedAnnotation", ".fromRo", new FileAttribute[0]).toFile();
                    Properties properties = new Properties();
                    properties.put("about", annot.getAbout().toString());
                    properties.put("body", annot.getContent().toString());
                    if (annot.getUri() != null) {
                        properties.put("uri", annot.getUri().toString());
                    }
                    FileOutputStream out = new FileOutputStream(newAnnotation);
                    properties.store(out, "conversion from research object");
                    out.close();
                    String targetName = newAnnotation.getName().toString();
                    while (this.combineArchive.getEntry(annotationsDir + targetName) != null) {
                        targetName = targetName + alhpa.next();
                    }
                    this.combineArchive.addEntry(newAnnotation, annotationsDir + targetName, URI_RO_CONV_ANNOTATION);
                    if (!annot.getContent().toString().startsWith("/.ro/annotations/")) continue;
                    String annotation = annot.getContent().toString();
                    File tmp2 = File.createTempFile("CaRoFromRo", "annotation");
                    tmp2.delete();
                    Files.copy(this.researchObject.getRoot().resolve(annotation), tmp2.toPath(), new CopyOption[0]);
                    this.combineArchive.addEntry(tmp2, annotation, URI_RO_COPY_ANNOTATION);
                }
                catch (IOException e) {
                    LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to convert annotation about ", annot.getAbout()});
                    this.notifications.add(new CaRoNotification(4, "wasn't able to convert annotation about " + annot.getAbout()));
                }
            }
            OmexDescription omex = new OmexDescription(new VCard(null, "CaRo version " + CaRo.CARO_VERSION, null, "sems.uni-rostock.de"), new Date());
            omex.setDescription(URI_RO_CA_CONV.toString());
            this.combineArchive.addDescription((MetaDataObject)new OmexMetaDataObject(omex));
            return true;
        }
        catch (CombineArchiveException | IOException | ParseException | JDOMException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to convert research object at ", this.sourceFile, " into a combine archive"});
            this.notifications.add(new CaRoNotification(8, "wasn't able to convert research object at " + this.sourceFile + " into a combine archive : " + e.getMessage()));
            return false;
        }
    }

    private void handleCreator(Agent author, List<MetaDataObject> descriptions, List<VCard> creatorsToAdd) {
        if (author != null) {
            VCard toAdd = RoToCa.agentToVCard(author);
            System.out.println("trying to add " + toAdd.toJsonObject());
            boolean addVcard = true;
            block0: for (MetaDataObject meta : descriptions) {
                List vcards;
                if (!addVcard) break;
                if (!(meta instanceof OmexMetaDataObject) || (vcards = ((OmexMetaDataObject)meta).getOmexDescription().getCreators()) == null || vcards.size() <= 0) continue;
                for (VCard creator : vcards) {
                    if (!RoToCa.sameVcard(creator, toAdd)) continue;
                    System.out.println("vcards are equal?");
                    System.out.println(creator.toJsonObject());
                    System.out.println(toAdd.toJsonObject());
                    addVcard = false;
                    continue block0;
                }
            }
            if (addVcard) {
                for (VCard exists : creatorsToAdd) {
                    if (!RoToCa.sameVcard(exists, toAdd)) continue;
                    System.out.println("vcards are equal?");
                    System.out.println(exists.toJsonObject());
                    System.out.println(toAdd.toJsonObject());
                    return;
                }
                System.out.println("adding " + toAdd.toJsonObject());
                creatorsToAdd.add(toAdd);
            }
        }
    }

    private void handleCreators(ArchiveEntry entry, PathMetadata pmd) {
        System.out.println("handling creators of " + pmd.getFile());
        List descriptions = entry.getDescriptions();
        ArrayList<VCard> creatorsToAdd = new ArrayList<VCard>();
        System.out.println("getCreatedBy " + pmd.getCreatedBy());
        this.handleCreator(pmd.getCreatedBy(), descriptions, creatorsToAdd);
        System.out.println("getAuthoredBy " + pmd.getAuthoredBy());
        if (pmd.getAuthoredBy() != null) {
            for (Agent author : pmd.getAuthoredBy()) {
                System.out.println("author " + author);
                this.handleCreator(author, descriptions, creatorsToAdd);
            }
        }
        System.out.println("creatorsToAdd " + creatorsToAdd);
        if (creatorsToAdd.size() > 0) {
            OmexDescription descr = null;
            FileTime createdOn = pmd.getCreatedOn();
            descr = createdOn != null ? new OmexDescription(creatorsToAdd, new Date(createdOn.toMillis()), "converted from Research Object manifest") : new OmexDescription(creatorsToAdd, new Date(), "converted from Research Object manifest");
            System.out.println("descr " + descr.toJsonDescription());
            entry.addDescription((MetaDataObject)new OmexMetaDataObject(descr));
            for (MetaDataObject mdo : entry.getDescriptions()) {
                System.out.println(XmlTools.prettyPrintDocument((Document)new Document(mdo.getXmlDescription().clone())).toString());
            }
        }
    }

    private void handleAnnotations(Path file, PathMetadata pmd, List<PathAnnotation> annotations, ArchiveEntry entry, HashMap<String, ArchiveEntry> archiveEntries) {
        List<PathAnnotation> curAnnotations = this.getAnnotations(pmd, annotations);
        for (PathAnnotation annot : curAnnotations) {
            if (annot.getContent().equals(URI_MAIN_ENTRY) || annot.getContent().equals(URI_BF_MAIN_ENTRY)) {
                this.combineArchive.addMainEntry(entry);
                this.handledAnnotations.add(annot);
                continue;
            }
            if (!this.annotationHasOmexTag(annot, annotations)) continue;
            this.handledAnnotations.add(annot);
            try {
                Path annoPath = this.researchObject.getRoot().resolve(annot.getContent().toString());
                ArrayList errors = new ArrayList();
                MetaDataFile.readFile((Path)annoPath, archiveEntries, (CombineArchive)this.combineArchive, null, null, (boolean)true, errors);
                if (errors.size() <= 0) continue;
                for (String err : errors) {
                    LOGGER.warn((Object[])new Object[]{"wasn't able to read omex meta file ", annot.getContent(), " in research object at ", this.sourceFile, " because ", err});
                    this.notifications.add(new CaRoNotification(4, "wasn't able to read omex meta file " + annot.getContent() + " in research object at " + this.sourceFile + " because " + err));
                }
            }
            catch (CombineArchiveException | IOException | ParseException | JDOMException e) {
                LOGGER.warn((Exception)e, (Object[])new Object[]{"reading meta data file ", annot.getContent(), " in research object at ", this.sourceFile, " failed"});
                this.notifications.add(new CaRoNotification(8, "reading meta data file " + annot.getContent() + " in research object at " + this.sourceFile + " failed because: " + e.getMessage()));
            }
        }
    }

    private boolean annotationHasOmexTag(PathAnnotation annotation, List<PathAnnotation> annotations) {
        for (PathAnnotation annot : annotations) {
            if (!annot.getAbout().equals(annotation.getUri()) || !annot.getContent().equals(URI_OMEX_META)) continue;
            this.handledAnnotations.add(annot);
            return true;
        }
        return false;
    }

    private List<PathAnnotation> getAnnotations(PathMetadata pmd, List<PathAnnotation> annotations) {
        ArrayList<PathAnnotation> curAnnotations = new ArrayList<PathAnnotation>();
        for (PathAnnotation annot : annotations) {
            if (!annot.getAbout().equals(pmd.getUri())) continue;
            curAnnotations.add(annot);
        }
        return curAnnotations;
    }

    private boolean handleRemoteFile(PathMetadata pmd) {
        LOGGER.warn((Object[])new Object[]{"skipping manifest entry ", pmd.getUri(), " as it seems to be no local file"});
        this.notifications.add(new CaRoNotification(4, "skipping manifest entry " + pmd.getUri() + " as it seems to be no local file"));
        return false;
    }

    private boolean includeFile(Path target) {
        for (String path : CA_RESTRICTIONS) {
            if (!target.startsWith(path)) continue;
            this.notifications.add(new CaRoNotification(4, "dropping " + path + " as this is a special file in combine archives!"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean write(File target) {
        if (this.combineArchive == null) {
            return false;
        }
        try {
            this.combineArchive.pack();
            this.combineArchive.close();
            Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
            Files.move(this.temporaryLocation.toPath(), target.toPath(), new CopyOption[0]);
            return true;
        }
        catch (IOException | TransformerException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to save combine archive to ", target});
            this.notifications.add(new CaRoNotification(8, "wasn't able to save combine archive to " + target + " : " + e.getMessage()));
            return false;
        }
    }

    public CombineArchive getCombineArchive() {
        return this.combineArchive;
    }
}

