/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.caro;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.caro.CaRoNotification;
import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.meta.omex.VCard;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.taverna.robundle.Bundle;
import org.apache.taverna.robundle.manifest.Agent;
import org.jdom2.Namespace;

public abstract class CaRoConverter {
    public static final String[] RO_RESTRICTIONS = new String[]{"/.ro/manifest.json", "/META-INF/container.xml", "/META-INF/manifest.xml", "/mimetype"};
    public static final String[] CA_RESTRICTIONS = new String[]{"/metadata.rdf", "/manifest.xml"};
    public static Namespace RDF_NAMESPACE = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    public static URI URI_TURTLE_MIME;
    public static URI URI_OMEX_META;
    public static URI URI_MAIN_ENTRY;
    public static URI URI_BF_MAIN_ENTRY;
    public static URI URI_RO_CONV_ANNOTATION;
    public static URI URI_RO_COPY_ANNOTATION;
    public static URI URI_CA_RO_CONV;
    public static URI URI_RO_CA_CONV;
    protected File sourceFile;
    protected CombineArchive combineArchive;
    protected Bundle researchObject;
    protected List<CaRoNotification> notifications;

    public CaRoConverter(File sourceFile) {
        this.sourceFile = sourceFile;
        this.combineArchive = null;
        this.researchObject = null;
        this.notifications = new ArrayList<CaRoNotification>();
    }

    public boolean hasErrors() {
        for (CaRoNotification crn : this.notifications) {
            if (crn.getSeverity() != 8) continue;
            return true;
        }
        return false;
    }

    public boolean hasWarnings() {
        for (CaRoNotification crn : this.notifications) {
            if (crn.getSeverity() != 4) continue;
            return true;
        }
        return false;
    }

    public List<CaRoNotification> getNotifications() {
        return this.notifications;
    }

    protected abstract boolean openSourceContainer();

    protected abstract boolean closeSourceContainer();

    protected abstract boolean convert();

    protected abstract boolean write(File var1);

    public boolean convertTo(File target) {
        if (!this.openSourceContainer()) {
            LOGGER.error((Object[])new Object[]{"wasn't able to open ", this.sourceFile});
            this.notifications.add(new CaRoNotification(8, "wasn't able to open " + this.sourceFile));
            this.closeSourceContainer();
            return false;
        }
        if (!this.convert()) {
            LOGGER.error((Object[])new Object[]{"wasn't able to convert ", this.sourceFile});
            this.notifications.add(new CaRoNotification(8, "wasn't able to convert " + this.sourceFile));
            this.closeSourceContainer();
            return false;
        }
        if (!this.closeSourceContainer()) {
            LOGGER.error((Object[])new Object[]{"wasn't able to close ", this.sourceFile});
            this.notifications.add(new CaRoNotification(8, "wasn't able to close " + this.sourceFile));
            this.closeSourceContainer();
            return false;
        }
        if (!this.write(target)) {
            LOGGER.error((Object[])new Object[]{"wasn't able to write ", target});
            this.notifications.add(new CaRoNotification(8, "wasn't able to write " + target));
            this.closeSourceContainer();
            return false;
        }
        return true;
    }

    protected static VCard agentToVCard(Agent agent) {
        if (agent == null) {
            return null;
        }
        VCard vcard = new VCard();
        String name = agent.getName();
        URI mail = agent.getUri();
        boolean emptyVcard = true;
        if (name != null && name.length() > 0) {
            String[] names = name.split(" ");
            if (names.length > 1) {
                vcard.setGivenName(names[0]);
                vcard.setFamilyName("");
                for (int i = 1; i < names.length; ++i) {
                    vcard.setFamilyName(vcard.getFamilyName() + (i < names.length - 1 ? " " : "") + names[i]);
                }
            } else if (names.length == 1) {
                vcard.setGivenName(names[0]);
            }
            emptyVcard = false;
        }
        if (mail != null && mail.getScheme().equals("mailto")) {
            vcard.setEmail(mail.getRawSchemeSpecificPart());
            emptyVcard = false;
        }
        return emptyVcard ? null : vcard;
    }

    protected static Agent vcardToAgent(VCard vcard, List<CaRoNotification> notifications) {
        if (vcard == null) {
            return null;
        }
        Agent agent = new Agent();
        boolean emptyAgent = true;
        String name = "";
        if (vcard.getGivenName() != null && vcard.getFamilyName() != null) {
            name = vcard.getGivenName() + " " + vcard.getFamilyName();
        } else if (vcard.getGivenName() != null) {
            name = vcard.getGivenName();
        } else if (vcard.getFamilyName() != null) {
            name = vcard.getFamilyName();
        }
        if (name.length() > 0) {
            agent.setName(name);
            emptyAgent = false;
        }
        try {
            if (vcard.getEmail() != null && vcard.getEmail().length() > 0) {
                agent.setUri(new URI("mailto", vcard.getEmail(), null));
                emptyAgent = false;
            }
        }
        catch (URISyntaxException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"wasn't able to create mailto uri for ", vcard.getEmail()});
            notifications.add(new CaRoNotification(4, "wasn't able to create mailto uri for " + vcard.getEmail()));
        }
        return emptyAgent ? null : agent;
    }

    public static boolean sameVcard(VCard a, VCard b) {
        if (a.getFamilyName() == null && b.getFamilyName() != null) {
            return false;
        }
        if (a.getGivenName() == null && b.getGivenName() != null) {
            return false;
        }
        if (a.getFamilyName() != null && b.getFamilyName() == null) {
            return false;
        }
        if (a.getGivenName() != null && b.getGivenName() == null) {
            return false;
        }
        if (!(a.getGivenName() != null && !a.getGivenName().equals(b.getGivenName()) || a.getFamilyName() != null && !a.getFamilyName().equals(b.getFamilyName()) || a.getGivenName() == null && a.getFamilyName() == null)) {
            return true;
        }
        return a.getEmail() != null && a.getEmail().equals(b.getEmail());
    }

    static {
        try {
            URI_TURTLE_MIME = new URI("http://purl.org/NET/mediatypes/text/turtle");
            URI_OMEX_META = new URI("http://sems.uni-rostock.de/CaRo/annotations#omexMeta");
            URI_MAIN_ENTRY = new URI("http://sems.uni-rostock.de/CaRo/annotations#mainEntry");
            URI_BF_MAIN_ENTRY = new URI("http://binfalse.de#rootdocument");
            URI_CA_RO_CONV = new URI("http://sems.uni-rostock.de/CaRo/annotations#ca2ro");
            URI_RO_CA_CONV = new URI("http://sems.uni-rostock.de/CaRo/annotations#ro2ca");
            URI_RO_CONV_ANNOTATION = new URI("http://sems.uni-rostock.de/CaRo/annotations#roConvertedAnnotation");
            URI_RO_COPY_ANNOTATION = new URI("http://sems.uni-rostock.de/CaRo/annotations#roCopiedAnnotation");
        }
        catch (URISyntaxException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot create turtle URI"});
        }
    }
}

