/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.CombineArchiveException;
import de.unirostock.sems.cbarchive.Utils;
import de.unirostock.sems.cbarchive.meta.MetaDataFile;
import de.unirostock.sems.cbarchive.meta.MetaDataHolder;
import de.unirostock.sems.cbarchive.meta.MetaDataObject;
import de.unirostock.sems.cbarchive.meta.OmexMetaDataObject;
import de.unirostock.sems.cbarchive.meta.omex.OmexDescription;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CombineArchive
extends MetaDataHolder
implements Closeable {
    public static final String MANIFEST_LOCATION = "/manifest.xml";
    public static final String METADATA_LOCATION = "/metadata.rdf";
    private HashMap<String, ArchiveEntry> entries;
    private FileSystem zipfs;
    private List<ArchiveEntry> mainEntries;
    private List<Path> metaDataFiles;
    private MetaDataFile metaData;
    private List<String> errors;
    private File zipFileLocation;
    private static final String MIME_REGEX = "[a-zA-Z0-9+.-]+/[a-zA-Z0-9+.-]+";
    private static final String PURL_PREFIX = "http://purl.org/NET/mediatypes/";

    public CombineArchive(File zipFile) throws IOException, JDOMException, ParseException, CombineArchiveException {
        this.init(zipFile, false);
    }

    public CombineArchive(File zipFile, boolean continueOnError) throws IOException, JDOMException, ParseException, CombineArchiveException {
        this.init(zipFile, continueOnError);
    }

    private void init(File zipFile, boolean continueOnError) throws IOException, JDOMException, ParseException, CombineArchiveException {
        if (zipFile.exists() && zipFile.length() == 0L) {
            zipFile.delete();
        }
        this.zipFileLocation = zipFile;
        this.errors = new ArrayList<String>();
        this.mainEntries = new ArrayList<ArchiveEntry>();
        this.entries = new HashMap();
        HashMap<String, String> zip_properties = new HashMap<String, String>();
        zip_properties.put("create", "true");
        zip_properties.put("encoding", "UTF-8");
        boolean existingArchive = zipFile.exists();
        try {
            this.zipfs = FileSystems.newFileSystem(URI.create("jar:" + zipFile.toURI()), zip_properties);
        }
        catch (IOException | UnsupportedOperationException | ProviderNotFoundException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot read archive " + zipFile.toURI() + " (file system creation failed)"});
            this.errors.add("cannot read archive " + zipFile.toURI() + " (file system creation failed)");
            if (!continueOnError) {
                throw e;
            }
            return;
        }
        this.metaDataFiles = new ArrayList<Path>();
        this.metaData = new MetaDataFile();
        Path mani = this.zipfs.getPath(MANIFEST_LOCATION, new String[0]).normalize();
        if (Files.isRegularFile(mani, new LinkOption[0])) {
            this.parseManifest(mani, continueOnError);
        } else if (existingArchive) {
            LOGGER.error((Object[])new Object[]{"this is not a combine archive"});
            this.errors.add("this is not a combine archive");
            if (!continueOnError) {
                this.zipfs.close();
                throw new CombineArchiveException("this is no combine archive");
            }
        }
        this.cleanUp();
    }

    public File getZipLocation() {
        return this.zipFileLocation;
    }

    public ArchiveEntry getMainEntry() {
        if (this.mainEntries == null) {
            return null;
        }
        return this.mainEntries.size() > 0 ? this.mainEntries.get(0) : null;
    }

    public List<ArchiveEntry> getMainEntries() {
        return this.mainEntries;
    }

    public void setMainEntry(ArchiveEntry mainEntry) {
        this.mainEntries.clear();
        this.addMainEntry(mainEntry);
    }

    public void addMainEntry(ArchiveEntry mainEntry) {
        this.mainEntries.add(mainEntry);
    }

    public void removeMainEntry(ArchiveEntry entry) {
        this.mainEntries.remove(entry);
    }

    private String prepareLocation(String location) {
        if ((location = Utils.pathFixer(location)).startsWith("./")) {
            location = location.substring(1);
        }
        if (!location.startsWith("/")) {
            location = "/" + location;
        }
        return location;
    }

    public ArchiveEntry getEntry(String location) {
        location = this.prepareLocation(location);
        return this.entries.get(location);
    }

    public boolean removeEntry(String location) throws IOException {
        ArchiveEntry entry = this.entries.remove(location = this.prepareLocation(location));
        if (entry != null) {
            this.mainEntries.remove(entry);
            Files.delete(entry.getPath());
            return true;
        }
        return false;
    }

    public boolean removeEntry(ArchiveEntry entry) throws IOException {
        if (this.entries.remove(entry.getFilePath()) != null) {
            this.mainEntries.remove(entry);
            Files.delete(entry.getPath());
            return true;
        }
        return false;
    }

    public ArchiveEntry getEntryByLocation(String location) {
        location = this.prepareLocation(location);
        return this.entries.get(location);
    }

    public ArchiveEntry replaceFile(File toInsert, ArchiveEntry oldEntry) throws IOException {
        this.addEntry(toInsert, oldEntry.getFilePath(), oldEntry.getFormat(), false);
        this.entries.put(oldEntry.getFilePath(), oldEntry);
        return oldEntry;
    }

    public ArchiveEntry addEntry(File toInsert, String targetName, URI format) throws IOException {
        return this.addEntry(toInsert, targetName, format, false);
    }

    public ArchiveEntry addEntry(File toInsert, String targetName, String format) throws IOException {
        URI formatUri = null;
        try {
            formatUri = new URI(format);
        }
        catch (URISyntaxException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"could not parse URI ", format});
            this.errors.add("could not parse URI " + format);
            return null;
        }
        return this.addEntry(toInsert, targetName, formatUri, false);
    }

    public ArchiveEntry addEntry(File toInsert, String targetName, URI format, boolean mainEntry) throws IOException {
        if ((targetName = this.prepareLocation(targetName)).equals(MANIFEST_LOCATION)) {
            throw new IllegalArgumentException("it's not allowed to name a file /manifest.xml");
        }
        if (targetName.equals(METADATA_LOCATION)) {
            throw new IllegalArgumentException("it's not allowed to name a file /metadata.rdf");
        }
        if (targetName.matches("^/metadata-[0-9]*\\.rdf$")) {
            throw new IllegalArgumentException("it's not allowed to name a file like metadata-[0-9]*.rdf");
        }
        Path insertPath = this.zipfs.getPath(targetName, new String[0]).normalize();
        Files.createDirectories(insertPath.getParent(), new FileAttribute[0]);
        Files.copy(toInsert.toPath(), insertPath, Utils.COPY_OPTION);
        ArchiveEntry entry = new ArchiveEntry(this, insertPath, format);
        this.entries.put(entry.getFilePath(), entry);
        if (mainEntry) {
            LOGGER.debug((Object[])new Object[]{"setting main entry:"});
            this.addMainEntry(entry);
        }
        return entry;
    }

    public ArchiveEntry addEntry(File toInsert, String targetName, String format, boolean mainEntry) throws IOException {
        URI formatUri = null;
        try {
            formatUri = new URI(format);
        }
        catch (URISyntaxException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"could not parse URI ", format});
            this.errors.add("could not parse URI " + format);
            return null;
        }
        return this.addEntry(toInsert, targetName, formatUri, mainEntry);
    }

    public ArchiveEntry addEntry(File baseDir, File file, URI format, boolean mainEntry) throws IOException {
        if (!file.exists()) {
            throw new IOException("file does not exist.");
        }
        if (!file.getAbsolutePath().contains(baseDir.getAbsolutePath())) {
            throw new IOException("file must be in basedir.");
        }
        String localName = file.getAbsolutePath().replace(baseDir.getAbsolutePath(), "");
        return this.addEntry(file, localName, format, mainEntry);
    }

    public ArchiveEntry addEntry(File baseDir, File file, String format, boolean mainEntry) throws IOException {
        URI formatUri = null;
        try {
            formatUri = new URI(format);
        }
        catch (URISyntaxException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"could not parse URI ", format});
            this.errors.add("could not parse URI " + format);
            return null;
        }
        return this.addEntry(baseDir, file, formatUri, mainEntry);
    }

    public ArchiveEntry addEntry(File baseDir, File file, URI format) throws IOException {
        if (!file.exists()) {
            throw new IOException("file does not exist.");
        }
        if (!file.getAbsolutePath().contains(baseDir.getAbsolutePath())) {
            throw new IOException("file must be in basedir.");
        }
        String localName = file.getAbsolutePath().replace(baseDir.getAbsolutePath(), "");
        return this.addEntry(file, localName, format, false);
    }

    public ArchiveEntry addEntry(File baseDir, File file, String format) throws IOException {
        URI formatUri = null;
        try {
            formatUri = new URI(format);
        }
        catch (URISyntaxException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"could not parse URI ", format});
            this.errors.add("could not parse URI " + format);
            return null;
        }
        return this.addEntry(baseDir, file, formatUri, false);
    }

    @Deprecated
    public ArchiveEntry addEntry(File baseDir, File file, String format, OmexDescription description, boolean mainEntry) throws IOException {
        if (!file.exists()) {
            throw new IOException("file does not exist.");
        }
        if (!file.getAbsolutePath().contains(baseDir.getAbsolutePath())) {
            throw new IOException("file must be in basedir.");
        }
        String localName = file.getAbsolutePath().replace(baseDir.getAbsolutePath(), "");
        ArchiveEntry entry = this.addEntry(file, localName, format, mainEntry);
        entry.addDescription(new OmexMetaDataObject(description));
        return entry;
    }

    @Deprecated
    public ArchiveEntry addEntry(File baseDir, File file, String format, OmexDescription description) throws IOException {
        if (!file.exists()) {
            throw new IOException("file does not exist.");
        }
        if (!file.getAbsolutePath().contains(baseDir.getAbsolutePath())) {
            throw new IOException("file must be in basedir.");
        }
        String localName = file.getAbsolutePath().replace(baseDir.getAbsolutePath(), "");
        ArchiveEntry entry = this.addEntry(file, localName, format, false);
        entry.addDescription(new OmexMetaDataObject(description));
        return entry;
    }

    public List<ArchiveEntry> getEntriesWithFormat(URI format) {
        ArrayList<ArchiveEntry> list = new ArrayList<ArchiveEntry>();
        for (ArchiveEntry e : this.entries.values()) {
            if (!e.getFormat().equals(format)) continue;
            list.add(e);
        }
        return list;
    }

    public int getNumEntriesWithFormat(URI format) {
        return this.getEntriesWithFormat(format).size();
    }

    public boolean hasEntriesWithFormat(URI format) {
        return this.getEntriesWithFormat(format).size() > 0;
    }

    @Deprecated
    public boolean HasEntriesWithFormat(URI format) {
        return this.hasEntriesWithFormat(format);
    }

    public Collection<ArchiveEntry> getEntries() {
        return this.entries.values();
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public Iterator<ArchiveEntry> getEnumerator() {
        return this.entries.values().iterator();
    }

    @Override
    public String getEntityPath() {
        return ".";
    }

    public MetaDataHolder getMetaOfMeta() {
        return this.metaData;
    }

    private Element createManifestEntry(String location, URI format, boolean mainEntry) {
        Element element = new Element("content", Utils.omexNs);
        element.setAttribute("location", location);
        element.setAttribute("format", format.toString());
        if (mainEntry) {
            element.setAttribute("master", "" + mainEntry);
        }
        return element;
    }

    private void writeManifest(boolean singleFile) throws IOException, TransformerException {
        File manifestFile = File.createTempFile("combineArchiveManifest", "tmp");
        Document doc = new Document();
        Element root = new Element("omexManifest", Utils.omexNs);
        doc.addContent((Content)root);
        root.addContent((Content)this.createManifestEntry(".", Utils.getOmexSpecUri(), false));
        root.addContent((Content)this.createManifestEntry("./manifest.xml", Utils.getOmexManifestUri(), false));
        for (ArchiveEntry e : this.entries.values()) {
            root.addContent((Content)this.createManifestEntry("." + e.getPath().toString(), e.getFormat(), this.mainEntries.contains(e)));
        }
        File baseDir = Files.createTempDirectory("combineArchive", new FileAttribute[0]).toFile();
        List<File> descr = singleFile ? MetaDataFile.writeFile(baseDir, this.entries, this, this.metaData) : MetaDataFile.writeFiles(baseDir, this.entries, this, this.metaData);
        for (File f : descr) {
            root.addContent((Content)this.createManifestEntry("." + f.getAbsolutePath().replace(baseDir.getAbsolutePath(), ""), Utils.getOmexMetaDataUri(), false));
            Path newMeta = this.zipfs.getPath(f.getAbsolutePath().replace(baseDir.getAbsolutePath(), ""), new String[0]).normalize();
            Files.copy(f.toPath(), newMeta, Utils.COPY_OPTION);
            this.metaDataFiles.add(newMeta);
            f.delete();
        }
        baseDir.delete();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(manifestFile));
            bw.write(Utils.prettyPrintDocument(doc));
        }
        catch (IOException | TransformerException e) {
            e.printStackTrace();
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot write manifest file to ", manifestFile});
            throw e;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
        Files.copy(manifestFile.toPath(), this.zipfs.getPath(MANIFEST_LOCATION, new String[0]).normalize(), Utils.COPY_OPTION);
        manifestFile.delete();
    }

    public void pack(boolean multipleMetaFiles) throws IOException, TransformerException {
        for (Path meta : this.metaDataFiles) {
            Files.delete(meta);
        }
        this.metaDataFiles = new ArrayList<Path>();
        this.writeManifest(!multipleMetaFiles);
    }

    public void pack() throws IOException, TransformerException {
        this.cleanUp();
        this.pack(false);
    }

    /*
     * Unable to fully structure code
     */
    private void parseManifest(Path manifest, boolean continueOnError) throws IOException, JDOMException, ParseException, CombineArchiveException {
        doc = null;
        try {
            doc = Utils.readXmlDocument(manifest);
        }
        catch (JDOMException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot read manifest of archive"});
            this.errors.add("cannot read manifest of archive. xml seems to be invalid.");
            if (!continueOnError) {
                throw e;
            }
            return;
        }
        catch (IOException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot read manifest of archive."});
            this.errors.add("cannot read manifest of archive. io error.");
            if (!continueOnError) {
                throw e;
            }
            return;
        }
        this.metaDataFiles = new ArrayList<Path>();
        this.metaData = new MetaDataFile();
        nl = Utils.getElementsByTagName(doc.getRootElement(), "content", Utils.omexNs);
        for (i = 0; i < nl.size(); ++i) {
            content = nl.get(i);
            location = null;
            master = null;
            format = null;
            attr = content.getAttribute("location");
            if (attr != null) {
                location = attr.getValue();
            }
            if ((attr = content.getAttribute("format")) != null) {
                try {
                    if (!attr.getValue().startsWith("http")) {
                        throw new URISyntaxException(attr.getValue(), "expected http uri");
                    }
                    format = new URI(attr.getValue());
                }
                catch (URISyntaxException e) {
                    foundMime = false;
                    mime = attr.getValue();
                    if (mime.matches("[a-zA-Z0-9+.-]+/[a-zA-Z0-9+.-]+")) {
                        try {
                            format = new URI("http://purl.org/NET/mediatypes/" + mime);
                            foundMime = true;
                        }
                        catch (URISyntaxException e1) {
                            LOGGER.error((Object[])new Object[]{"couldn't convert mime ", mime, " to uri ", "http://purl.org/NET/mediatypes/", mime});
                            this.errors.add("couldn't convert mime " + mime + " to uri " + "http://purl.org/NET/mediatypes/" + mime);
                        }
                    }
                    if (foundMime) ** GOTO lbl59
                    LOGGER.error((Object[])new Object[]{"archive seems to be corrupt. format ", attr.getValue(), " not a valid URI."});
                    this.errors.add("archive seems to be corrupt. format " + attr.getValue() + " not a valid URI.");
                    if (continueOnError) continue;
                    throw new IOException("archive seems to be corrupt. format " + attr.getValue() + " not a valid URI.");
                }
            } else {
                LOGGER.error((Object[])new Object[]{"didn't find format for entry", i});
                this.errors.add("didn't find format for entry" + i);
                if (continueOnError) continue;
                throw new IOException("didn't find format for entry" + i);
            }
lbl59:
            // 2 sources

            attr = content.getAttribute("master");
            if (attr != null) {
                master = attr.getValue();
            }
            if (location == null) {
                LOGGER.error((Object[])new Object[]{"manifest invalid. unknown location of entry ", i});
                this.errors.add("manifest invalid. unknown location of entry " + i);
                if (continueOnError) continue;
                throw new IOException("manifest invalid. unknown location of entry " + i);
            }
            if (format.equals(Utils.getOmexSpecUri()) || format.toString().startsWith(Utils.getOmexSpecUri().toString() + ".version")) continue;
            if (!location.startsWith("/")) {
                location = "/" + location;
            }
            if (!Files.isRegularFile(locFile = this.zipfs.getPath(location = this.prepareLocation(Paths.get(location, new String[0]).normalize().toString()), new String[0]).normalize(), new LinkOption[0])) {
                LOGGER.error((Object[])new Object[]{"archive seems to be corrupt. file ", locFile, " not found."});
                this.errors.add("archive seems to be corrupt. file " + locFile + " not found.");
                if (continueOnError) continue;
                throw new IOException("archive seems to be corrupt. file " + locFile + " not found.");
            }
            if (format.equals(Utils.getOmexMetaDataUri())) {
                this.metaDataFiles.add(locFile);
                continue;
            }
            if (format.equals(Utils.getOmexManifestUri())) continue;
            entry = new ArchiveEntry(this, locFile, format);
            if (master != null && Boolean.parseBoolean(master)) {
                this.addMainEntry(entry);
            }
            this.entries.put(location, entry);
        }
        for (Path f : this.metaDataFiles) {
            MetaDataFile.readFile(f, this.entries, this, this.metaData, this.metaDataFiles, continueOnError, this.errors);
        }
    }

    public void moveEntry(String oldPath, String newPath) throws IOException {
        String alt = this.prepareLocation(oldPath);
        String neu = this.prepareLocation(newPath);
        ArchiveEntry entry = this.getEntryByLocation(alt);
        if (entry == null) {
            throw new IOException("no such entry in archive");
        }
        boolean wasMain = this.mainEntries.contains(entry);
        this.entries.remove(alt);
        Path neuPath = this.zipfs.getPath(neu, new String[0]).normalize();
        Files.createDirectories(neuPath.getParent(), new FileAttribute[0]);
        Files.move(this.zipfs.getPath(alt, new String[0]).normalize(), neuPath, StandardCopyOption.ATOMIC_MOVE);
        ArchiveEntry newEntry = new ArchiveEntry(this, neuPath, entry.getFormat());
        this.entries.put(neu, newEntry);
        if (wasMain) {
            this.addMainEntry(newEntry);
        }
        List<MetaDataObject> meta = entry.getDescriptions();
        for (MetaDataObject m : meta) {
            newEntry.addDescription(m);
        }
    }

    public File extract(Path archivePath, File destination) throws IOException {
        if (!Files.isRegularFile(archivePath, new LinkOption[0])) {
            throw new IOException(archivePath + " is not a regular file");
        }
        if (destination.isDirectory()) {
            destination = destination.toPath().resolve("./" + archivePath.normalize().toString()).normalize().toFile();
        }
        Files.createDirectories(destination.toPath().getParent(), new FileAttribute[0]);
        Files.copy(archivePath, destination.toPath(), Utils.COPY_OPTION);
        return destination;
    }

    public File extractTo(File destination) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.zipfs.getPath("/", new String[0]));){
            for (Path file : directoryStream) {
                CombineArchive.extract(file, destination.toPath());
            }
        }
        return destination;
    }

    private static void extract(Path zipPath, Path destination) throws IOException {
        if (Files.isDirectory(zipPath, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(zipPath);){
                for (Path file : directoryStream) {
                    CombineArchive.extract(file, destination);
                }
            }
        } else {
            Path fileOutZip = destination.resolve("./" + zipPath.normalize().toString()).normalize();
            Files.createDirectories(fileOutZip.getParent(), new FileAttribute[0]);
            Files.copy(zipPath, fileOutZip, Utils.COPY_OPTION);
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public void clearErrors() {
        this.errors.clear();
    }

    private void cleanUp() {
        for (Path p : this.zipfs.getRootDirectories()) {
            this.cleanUp(p);
        }
    }

    private void cleanUp(Path p) {
        if (Files.isDirectory(p, new LinkOption[0])) {
            try {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(p);){
                    for (Path file : stream) {
                        this.cleanUp(file);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn((Exception)e, (Object[])new Object[]{"couldn't look into directory ", p});
                }
                if (!p.toString().equals("/")) {
                    Files.delete(p);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.zipfs != null) {
            this.zipfs.close();
        }
    }
}

