/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.meta.omex;

import de.unirostock.sems.cbarchive.Utils;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.json.simple.JSONObject;

public class VCard {
    private String familyName;
    private String givenName;
    private String email;
    private String organization;

    public boolean isEmpty() {
        return !(this.familyName != null && this.familyName.length() >= 1 || this.givenName != null && this.givenName.length() >= 1 || this.email != null && this.email.length() >= 1);
    }

    public VCard() {
        this.familyName = null;
        this.givenName = null;
        this.email = null;
        this.organization = null;
    }

    public VCard(String familyName, String givenName, String email, String organization) {
        this.familyName = familyName;
        this.givenName = givenName;
        this.email = email;
        this.organization = organization;
    }

    public VCard(Element element) {
        List<Element> list = Utils.getElementsByTagName(element, "family-name", Utils.vcNS);
        if (list.size() > 0) {
            this.familyName = list.get(0).getText();
        }
        if ((list = Utils.getElementsByTagName(element, "given-name", Utils.vcNS)).size() > 0) {
            this.givenName = list.get(0).getText();
        }
        if ((list = Utils.getElementsByTagName(element, "email", Utils.vcNS)).size() > 0) {
            this.email = list.get(0).getText();
        }
        if ((list = Utils.getElementsByTagName(element, "organization-name", Utils.vcNS)).size() > 0) {
            this.organization = list.get(0).getText();
        }
    }

    public void toXml(Element parent) {
        if (this.isEmpty()) {
            return;
        }
        Element creator = new Element("creator", Utils.dcNS);
        Element bag = new Element("Bag", Utils.rdfNS);
        Element li = new Element("li", Utils.rdfNS);
        li.setAttribute("parseType", "Resource", Utils.rdfNS);
        if (this.familyName != null && this.familyName.length() > 0 || this.givenName != null && this.givenName.length() > 0) {
            Element n = new Element("n", Utils.vcNS);
            n.setAttribute("parseType", "Resource", Utils.rdfNS);
            if (this.familyName != null && this.familyName.length() > 0) {
                Element famName = new Element("family-name", Utils.vcNS);
                famName.setText(this.familyName);
                n.addContent((Content)famName);
            }
            if (this.givenName != null && this.givenName.length() > 0) {
                Element givName = new Element("given-name", Utils.vcNS);
                givName.setText(this.givenName);
                n.addContent((Content)givName);
            }
            li.addContent((Content)n);
        }
        if (this.email != null && this.email.length() > 0) {
            Element mail = new Element("email", Utils.vcNS);
            mail.setText(this.email);
            li.addContent((Content)mail);
        }
        if (this.organization != null && this.organization.length() > 0) {
            Element org = new Element("org", Utils.vcNS);
            Element orgName = new Element("organization-name", Utils.vcNS);
            orgName.setText(this.organization);
            org.setAttribute("parseType", "Resource", Utils.rdfNS);
            org.addContent((Content)orgName);
            li.addContent((Content)org);
        }
        creator.addContent((Content)bag);
        bag.addContent((Content)li);
        parent.addContent((Content)creator);
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public Object toJsonObject() {
        JSONObject descr = new JSONObject();
        descr.put((Object)"familyName", (Object)this.familyName);
        descr.put((Object)"givenName", (Object)this.givenName);
        descr.put((Object)"email", (Object)this.email);
        descr.put((Object)"organization", (Object)this.organization);
        return descr;
    }
}

