/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.meta;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.Utils;
import de.unirostock.sems.cbarchive.meta.MetaDataHolder;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class MetaDataObject {
    protected MetaDataHolder about = null;
    protected String fragmentIdentifier = null;
    protected Element description;

    public MetaDataObject(Element describingElement) {
        this.description = describingElement;
    }

    public void setAbout(MetaDataHolder about) {
        this.about = about;
        this.fragmentIdentifier = null;
        this.description.setAttribute("about", this.getAbout(), Utils.rdfNS);
    }

    public void setAbout(MetaDataHolder about, String fragmentIdentifier) {
        this.about = about;
        this.fragmentIdentifier = fragmentIdentifier;
        this.description.setAttribute("about", this.getAbout(), Utils.rdfNS);
    }

    public String getAbout() {
        if (this.about == null) {
            return "";
        }
        if (this.fragmentIdentifier != null) {
            return this.about.getEntityPath() + "#" + this.fragmentIdentifier;
        }
        return this.about.getEntityPath();
    }

    public abstract void injectDescription(Element var1);

    public Element getXmlDescription() {
        this.description.setAttribute("about", this.getAbout(), Utils.rdfNS);
        return this.description;
    }

    public boolean equalsPathNoMatter(MetaDataObject otherMeta) {
        if (otherMeta == null) {
            return false;
        }
        if (this.fragmentIdentifier == null && otherMeta.fragmentIdentifier == null || this.fragmentIdentifier != null && otherMeta.fragmentIdentifier != null && this.fragmentIdentifier.equals(otherMeta.fragmentIdentifier)) {
            try {
                Element elementOne = this.description.clone().setAttribute("about", "", Utils.rdfNS);
                Element elementTwo = otherMeta.description.clone().setAttribute("about", "", Utils.rdfNS);
                String one = Utils.prettyPrintDocument(new Document(elementOne));
                String two = Utils.prettyPrintDocument(new Document(elementTwo));
                return one.equals(two);
            }
            catch (IOException | TransformerException e) {
                e.printStackTrace();
                LOGGER.error((Exception)e, (Object[])new Object[]{"cannot convert jdom element tree to string"});
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !MetaDataObject.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        MetaDataObject otherMeta = (MetaDataObject)obj;
        return this.about == otherMeta.about && this.equalsPathNoMatter(otherMeta);
    }

    public abstract MetaDataObject clone();
}

