/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive;

import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.CombineArchiveException;
import de.unirostock.sems.cbarchive.meta.DefaultMetaDataObject;
import de.unirostock.sems.cbarchive.meta.MetaDataObject;
import de.unirostock.sems.cbarchive.meta.OmexMetaDataObject;
import de.unirostock.sems.cbarchive.meta.omex.OmexDescription;
import de.unirostock.sems.cbarchive.meta.omex.VCard;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.transform.TransformerException;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class Example {
    public static boolean PRINT = true;
    private static PrintStream ps = System.out;

    public static void createExample() throws IOException, TransformerException, JDOMException, ParseException, CombineArchiveException, URISyntaxException {
        ps.println("--- creating archive. ---");
        ArrayList<VCard> creators = new ArrayList<VCard>();
        creators.add(new VCard("Scharm", "Martin", "martin.scharm@uni-rostock.de", "University of Rostock"));
        creators.add(new VCard("Waltemath", "Dagmar", "dagmar.waltemath@uni-rostock.de", "University of Rostock"));
        CombineArchive ca = new CombineArchive(new File("/tmp/testArchive.zip"));
        ArchiveEntry SBMLFile = ca.addEntry(new File("/tmp/base/path"), new File("/tmp/base/path/file.sbml"), new URI("http://identifiers.org/combine.specifications/sbml"));
        SBMLFile.addDescription(new OmexMetaDataObject(new OmexDescription(creators, new Date())));
        ArchiveEntry CellMLFile = ca.addEntry(new File("/tmp/base/path/subdir/file.cellml"), "/subdir/file.cellml", new URI("http://identifiers.org/combine.specifications/cellml.1.0"), true);
        CellMLFile.addDescription(new OmexMetaDataObject(new OmexDescription(creators, new Date())));
        Element metaParent = new Element("stuff");
        Element metaElement = new Element("myMetaElement");
        metaElement.setAttribute("someAttribute", "someValue");
        metaElement.addContent("some content");
        metaParent.addContent((Content)metaElement);
        CellMLFile.addDescription("someFragment", new DefaultMetaDataObject(metaParent));
        ca.addDescription(new OmexMetaDataObject(new OmexDescription(creators, new Date())));
        ca.pack();
        ca.close();
    }

    public static void readExample() throws IOException, JDOMException, ParseException, CombineArchiveException {
        ps.println("--- reading archive. ---");
        File archiveFile = new File("/tmp/testArchive.zip");
        File destination = new File("/tmp/myDestination");
        File tmpEntryExtract = new File("/tmp/myExtractedEntry");
        CombineArchive ca = new CombineArchive(archiveFile);
        ps.println("found " + ca.getDescriptions().size() + " meta data entries describing the archive.");
        for (ArchiveEntry entry : ca.getEntries()) {
            ps.println(">>> file name in archive: " + entry.getFileName() + "  -- apparently of format: " + entry.getFormat());
            ps.println("file can be read from: " + entry.extractFile(tmpEntryExtract).getAbsolutePath());
            InputStream myReader = Files.newInputStream(entry.getPath(), StandardOpenOption.READ);
            myReader.close();
            for (MetaDataObject description : entry.getDescriptions()) {
                ps.println("+ found some meta data about " + description.getAbout());
                if (description instanceof OmexMetaDataObject) {
                    OmexDescription desc = ((OmexMetaDataObject)description).getOmexDescription();
                    ps.println("file was created: " + desc.getCreated());
                    VCard firstCreator = desc.getCreators().get(0);
                    ps.println("file's first author: " + firstCreator.getGivenName() + " " + firstCreator.getFamilyName());
                } else {
                    ps.println("found some meta data of type '" + description.getClass().getName() + "' that we do not respect in this small example.");
                }
                Element meta = description.getXmlDescription();
                meta.getChildren();
            }
        }
        ca.extractTo(destination);
        ca.close();
    }

    public static void main(String[] args) throws Exception {
        if (!PRINT) {
            File tmp = File.createTempFile("CombineArchive", "temporary");
            tmp.deleteOnExit();
            ps = new PrintStream(new FileOutputStream(tmp));
        }
        Example.createExample();
        Example.readExample();
        if (!PRINT) {
            ps.close();
        }
    }
}

