/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.meta;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.Utils;
import de.unirostock.sems.cbarchive.meta.MetaDataObject;
import de.unirostock.sems.cbarchive.meta.omex.OmexDescription;
import org.jdom2.Element;

public class OmexMetaDataObject
extends MetaDataObject {
    protected OmexDescription description;

    public OmexMetaDataObject(OmexDescription description) {
        super(OmexMetaDataObject.createDummyXmltree(description));
        this.description = description;
    }

    public OmexMetaDataObject(OmexDescription description, Element describingElement) {
        super(describingElement);
        this.description = description;
    }

    @Override
    public void injectDescription(Element parent) {
        this.description.toXML(parent);
        ((MetaDataObject)this).description = parent;
    }

    public OmexDescription getOmexDescription() {
        return this.description;
    }

    private static final Element createDummyXmltree(OmexDescription description) {
        Element descElem = new Element("Description", Utils.rdfNS);
        description.toXML(descElem);
        return descElem;
    }

    public static OmexMetaDataObject tryToRead(Element element) {
        try {
            OmexDescription desc = new OmexDescription(element);
            if (desc.isEmpty()) {
                return null;
            }
            return new OmexMetaDataObject(desc, element);
        }
        catch (Exception e) {
            LOGGER.debug((Exception)e, (Object[])new Object[]{"could not parse OMEX description"});
            return null;
        }
    }

    @Override
    public MetaDataObject clone() {
        OmexMetaDataObject clone = new OmexMetaDataObject(this.description.clone());
        clone.setAbout(this.about, this.fragmentIdentifier);
        return clone;
    }
}

